package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RequestReviewParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRequestReviewParameters.builder()}.
 */
@Generated(from = "RequestReviewParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRequestReviewParameters extends RequestReviewParameters {
  private final @Nullable List<String> reviewers;
  private final @Nullable List<String> teamReviewers;

  private ImmutableRequestReviewParameters(
      @Nullable List<String> reviewers,
      @Nullable List<String> teamReviewers) {
    this.reviewers = reviewers;
    this.teamReviewers = teamReviewers;
  }

  /**
   *Request reviews from users (list of login) 
   */
  @JsonProperty
  @Override
  public Optional<List<String>> reviewers() {
    return Optional.ofNullable(reviewers);
  }

  /**
   *Request reviews from teams (list of slugs) 
   */
  @JsonProperty("team_reviewers")
  @Override
  public Optional<List<String>> teamReviewers() {
    return Optional.ofNullable(teamReviewers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RequestReviewParameters#reviewers() reviewers} attribute.
   * @param value The value for reviewers
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRequestReviewParameters withReviewers(List<String> value) {
    @Nullable List<String> newValue = Objects.requireNonNull(value, "reviewers");
    if (this.reviewers == newValue) return this;
    return new ImmutableRequestReviewParameters(newValue, this.teamReviewers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RequestReviewParameters#reviewers() reviewers} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for reviewers
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableRequestReviewParameters withReviewers(Optional<? extends List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.reviewers == value) return this;
    return new ImmutableRequestReviewParameters(value, this.teamReviewers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RequestReviewParameters#teamReviewers() teamReviewers} attribute.
   * @param value The value for teamReviewers
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRequestReviewParameters withTeamReviewers(List<String> value) {
    @Nullable List<String> newValue = Objects.requireNonNull(value, "teamReviewers");
    if (this.teamReviewers == newValue) return this;
    return new ImmutableRequestReviewParameters(this.reviewers, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RequestReviewParameters#teamReviewers() teamReviewers} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for teamReviewers
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableRequestReviewParameters withTeamReviewers(Optional<? extends List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.teamReviewers == value) return this;
    return new ImmutableRequestReviewParameters(this.reviewers, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRequestReviewParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRequestReviewParameters
        && equalTo((ImmutableRequestReviewParameters) another);
  }

  private boolean equalTo(ImmutableRequestReviewParameters another) {
    return Objects.equals(reviewers, another.reviewers)
        && Objects.equals(teamReviewers, another.teamReviewers);
  }

  /**
   * Computes a hash code from attributes: {@code reviewers}, {@code teamReviewers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reviewers);
    h += (h << 5) + Objects.hashCode(teamReviewers);
    return h;
  }

  /**
   * Prints the immutable value {@code RequestReviewParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("RequestReviewParameters{");
    if (reviewers != null) {
      builder.append("reviewers=").append(reviewers);
    }
    if (teamReviewers != null) {
      if (builder.length() > 24) builder.append(", ");
      builder.append("teamReviewers=").append(teamReviewers);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RequestReviewParameters", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends RequestReviewParameters {
    @Nullable Optional<List<String>> reviewers = Optional.empty();
    @Nullable Optional<List<String>> teamReviewers = Optional.empty();
    @JsonProperty
    public void setReviewers(Optional<List<String>> reviewers) {
      this.reviewers = reviewers;
    }
    @JsonProperty("team_reviewers")
    public void setTeamReviewers(Optional<List<String>> teamReviewers) {
      this.teamReviewers = teamReviewers;
    }
    @Override
    public Optional<List<String>> reviewers() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<String>> teamReviewers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRequestReviewParameters fromJson(Json json) {
    ImmutableRequestReviewParameters.Builder builder = ImmutableRequestReviewParameters.builder();
    if (json.reviewers != null) {
      builder.reviewers(json.reviewers);
    }
    if (json.teamReviewers != null) {
      builder.teamReviewers(json.teamReviewers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RequestReviewParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RequestReviewParameters instance
   */
  public static ImmutableRequestReviewParameters copyOf(RequestReviewParameters instance) {
    if (instance instanceof ImmutableRequestReviewParameters) {
      return (ImmutableRequestReviewParameters) instance;
    }
    return ImmutableRequestReviewParameters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRequestReviewParameters ImmutableRequestReviewParameters}.
   * <pre>
   * ImmutableRequestReviewParameters.builder()
   *    .reviewers(List&amp;lt;String&amp;gt;) // optional {@link RequestReviewParameters#reviewers() reviewers}
   *    .teamReviewers(List&amp;lt;String&amp;gt;) // optional {@link RequestReviewParameters#teamReviewers() teamReviewers}
   *    .build();
   * </pre>
   * @return A new ImmutableRequestReviewParameters builder
   */
  public static ImmutableRequestReviewParameters.Builder builder() {
    return new ImmutableRequestReviewParameters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRequestReviewParameters ImmutableRequestReviewParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RequestReviewParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable List<String> reviewers;
    private @Nullable List<String> teamReviewers;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RequestReviewParameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RequestReviewParameters instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<List<String>> reviewersOptional = instance.reviewers();
      if (reviewersOptional.isPresent()) {
        reviewers(reviewersOptional);
      }
      Optional<List<String>> teamReviewersOptional = instance.teamReviewers();
      if (teamReviewersOptional.isPresent()) {
        teamReviewers(teamReviewersOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link RequestReviewParameters#reviewers() reviewers} to reviewers.
     * @param reviewers The value for reviewers
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reviewers(List<String> reviewers) {
      this.reviewers = Objects.requireNonNull(reviewers, "reviewers");
      return this;
    }

    /**
     * Initializes the optional value {@link RequestReviewParameters#reviewers() reviewers} to reviewers.
     * @param reviewers The value for reviewers
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reviewers(Optional<? extends List<String>> reviewers) {
      this.reviewers = reviewers.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RequestReviewParameters#teamReviewers() teamReviewers} to teamReviewers.
     * @param teamReviewers The value for teamReviewers
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder teamReviewers(List<String> teamReviewers) {
      this.teamReviewers = Objects.requireNonNull(teamReviewers, "teamReviewers");
      return this;
    }

    /**
     * Initializes the optional value {@link RequestReviewParameters#teamReviewers() teamReviewers} to teamReviewers.
     * @param teamReviewers The value for teamReviewers
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("team_reviewers")
    public final Builder teamReviewers(Optional<? extends List<String>> teamReviewers) {
      this.teamReviewers = teamReviewers.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRequestReviewParameters ImmutableRequestReviewParameters}.
     * @return An immutable instance of RequestReviewParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRequestReviewParameters build() {
      return new ImmutableRequestReviewParameters(reviewers, teamReviewers);
    }
  }
}
