package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReviewComment}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReviewComment.builder()}.
 */
@Generated(from = "ReviewComment", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReviewComment extends ReviewComment {
  private final String path;
  private final int position;
  private final String body;

  private ImmutableReviewComment(String path, int position, String body) {
    this.path = path;
    this.position = position;
    this.body = body;
  }

  /**
   * Relative path to the file that necessitates a review comment.
   * @return the path to the file.
   */
  @JsonProperty
  @Override
  public String path() {
    return path;
  }

  /**
   * Position in the diff where you want to add a review comment.
   * @return the position in the diff.
   */
  @JsonProperty
  @Override
  public int position() {
    return position;
  }

  /**
   * Text of the review comment.
   * @return the text of the review.
   */
  @JsonProperty
  @Override
  public String body() {
    return body;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReviewComment#path() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReviewComment withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return new ImmutableReviewComment(newValue, this.position, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReviewComment#position() position} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for position
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReviewComment withPosition(int value) {
    if (this.position == value) return this;
    return new ImmutableReviewComment(this.path, value, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReviewComment#body() body} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReviewComment withBody(String value) {
    String newValue = Objects.requireNonNull(value, "body");
    if (this.body.equals(newValue)) return this;
    return new ImmutableReviewComment(this.path, this.position, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReviewComment} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReviewComment
        && equalTo((ImmutableReviewComment) another);
  }

  private boolean equalTo(ImmutableReviewComment another) {
    return path.equals(another.path)
        && position == another.position
        && body.equals(another.body);
  }

  /**
   * Computes a hash code from attributes: {@code path}, {@code position}, {@code body}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + path.hashCode();
    h += (h << 5) + position;
    h += (h << 5) + body.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReviewComment} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReviewComment{"
        + "path=" + path
        + ", position=" + position
        + ", body=" + body
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReviewComment", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ReviewComment {
    @Nullable String path;
    int position;
    boolean positionIsSet;
    @Nullable String body;
    @JsonProperty
    public void setPath(String path) {
      this.path = path;
    }
    @JsonProperty
    public void setPosition(int position) {
      this.position = position;
      this.positionIsSet = true;
    }
    @JsonProperty
    public void setBody(String body) {
      this.body = body;
    }
    @Override
    public String path() { throw new UnsupportedOperationException(); }
    @Override
    public int position() { throw new UnsupportedOperationException(); }
    @Override
    public String body() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableReviewComment fromJson(Json json) {
    ImmutableReviewComment.Builder builder = ImmutableReviewComment.builder();
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.positionIsSet) {
      builder.position(json.position);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReviewComment} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReviewComment instance
   */
  public static ImmutableReviewComment copyOf(ReviewComment instance) {
    if (instance instanceof ImmutableReviewComment) {
      return (ImmutableReviewComment) instance;
    }
    return ImmutableReviewComment.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReviewComment ImmutableReviewComment}.
   * <pre>
   * ImmutableReviewComment.builder()
   *    .path(String) // required {@link ReviewComment#path() path}
   *    .position(int) // required {@link ReviewComment#position() position}
   *    .body(String) // required {@link ReviewComment#body() body}
   *    .build();
   * </pre>
   * @return A new ImmutableReviewComment builder
   */
  public static ImmutableReviewComment.Builder builder() {
    return new ImmutableReviewComment.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReviewComment ImmutableReviewComment}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReviewComment", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PATH = 0x1L;
    private static final long INIT_BIT_POSITION = 0x2L;
    private static final long INIT_BIT_BODY = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String path;
    private int position;
    private @Nullable String body;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReviewComment} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReviewComment instance) {
      Objects.requireNonNull(instance, "instance");
      path(instance.path());
      position(instance.position());
      body(instance.body());
      return this;
    }

    /**
     * Initializes the value for the {@link ReviewComment#path() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link ReviewComment#position() position} attribute.
     * @param position The value for position 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder position(int position) {
      this.position = position;
      initBits &= ~INIT_BIT_POSITION;
      return this;
    }

    /**
     * Initializes the value for the {@link ReviewComment#body() body} attribute.
     * @param body The value for body 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(String body) {
      this.body = Objects.requireNonNull(body, "body");
      initBits &= ~INIT_BIT_BODY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReviewComment ImmutableReviewComment}.
     * @return An immutable instance of ReviewComment
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReviewComment build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableReviewComment(path, position, body);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_POSITION) != 0) attributes.add("position");
      if ((initBits & INIT_BIT_BODY) != 0) attributes.add("body");
      return "Cannot build ReviewComment, some of required attributes are not set " + attributes;
    }
  }
}
