package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitComparison}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitComparison.builder()}.
 */
@Generated(from = "CommitComparison", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitComparison implements CommitComparison {
  private final @Nullable Commit baseCommit;
  private final @Nullable Commit mergeBaseCommit;
  private final @Nullable String status;
  private final int aheadBy;
  private final int behindBy;
  private final @Nullable List<Commit> commits;
  private final @Nullable List<File> files;

  private ImmutableCommitComparison(
      @Nullable Commit baseCommit,
      @Nullable Commit mergeBaseCommit,
      @Nullable String status,
      int aheadBy,
      int behindBy,
      @Nullable List<Commit> commits,
      @Nullable List<File> files) {
    this.baseCommit = baseCommit;
    this.mergeBaseCommit = mergeBaseCommit;
    this.status = status;
    this.aheadBy = aheadBy;
    this.behindBy = behindBy;
    this.commits = commits;
    this.files = files;
  }

  /**
   *Base 
   */
  @JsonProperty
  @Override
  public @Nullable Commit baseCommit() {
    return baseCommit;
  }

  /**
   *Merge base 
   */
  @JsonProperty
  @Override
  public @Nullable Commit mergeBaseCommit() {
    return mergeBaseCommit;
  }

  /**
   *Status 
   */
  @JsonProperty
  @Override
  public @Nullable String status() {
    return status;
  }

  /**
   *Ahead by 
   */
  @JsonProperty
  @Override
  public int aheadBy() {
    return aheadBy;
  }

  /**
   *Behind by 
   */
  @JsonProperty
  @Override
  public int behindBy() {
    return behindBy;
  }

  /**
   *Commits 
   */
  @JsonProperty
  @Override
  public @Nullable List<Commit> commits() {
    return commits;
  }

  /**
   *Files 
   */
  @JsonProperty
  @Override
  public @Nullable List<File> files() {
    return files;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitComparison#baseCommit() baseCommit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for baseCommit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitComparison withBaseCommit(@Nullable Commit value) {
    if (this.baseCommit == value) return this;
    return new ImmutableCommitComparison(value, this.mergeBaseCommit, this.status, this.aheadBy, this.behindBy, this.commits, this.files);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitComparison#mergeBaseCommit() mergeBaseCommit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mergeBaseCommit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitComparison withMergeBaseCommit(@Nullable Commit value) {
    if (this.mergeBaseCommit == value) return this;
    return new ImmutableCommitComparison(this.baseCommit, value, this.status, this.aheadBy, this.behindBy, this.commits, this.files);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitComparison#status() status} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitComparison withStatus(@Nullable String value) {
    if (Objects.equals(this.status, value)) return this;
    return new ImmutableCommitComparison(
        this.baseCommit,
        this.mergeBaseCommit,
        value,
        this.aheadBy,
        this.behindBy,
        this.commits,
        this.files);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitComparison#aheadBy() aheadBy} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for aheadBy
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitComparison withAheadBy(int value) {
    if (this.aheadBy == value) return this;
    return new ImmutableCommitComparison(
        this.baseCommit,
        this.mergeBaseCommit,
        this.status,
        value,
        this.behindBy,
        this.commits,
        this.files);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitComparison#behindBy() behindBy} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for behindBy
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitComparison withBehindBy(int value) {
    if (this.behindBy == value) return this;
    return new ImmutableCommitComparison(
        this.baseCommit,
        this.mergeBaseCommit,
        this.status,
        this.aheadBy,
        value,
        this.commits,
        this.files);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitComparison#commits() commits}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitComparison withCommits(@Nullable Commit... elements) {
    if (elements == null) {
      return new ImmutableCommitComparison(
          this.baseCommit,
          this.mergeBaseCommit,
          this.status,
          this.aheadBy,
          this.behindBy,
          null,
          this.files);
    }
    @Nullable List<Commit> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCommitComparison(
        this.baseCommit,
        this.mergeBaseCommit,
        this.status,
        this.aheadBy,
        this.behindBy,
        newValue,
        this.files);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitComparison#commits() commits}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of commits elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitComparison withCommits(@Nullable Iterable<? extends Commit> elements) {
    if (this.commits == elements) return this;
    @Nullable List<Commit> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCommitComparison(
        this.baseCommit,
        this.mergeBaseCommit,
        this.status,
        this.aheadBy,
        this.behindBy,
        newValue,
        this.files);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitComparison#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitComparison withFiles(@Nullable File... elements) {
    if (elements == null) {
      return new ImmutableCommitComparison(
          this.baseCommit,
          this.mergeBaseCommit,
          this.status,
          this.aheadBy,
          this.behindBy,
          this.commits,
          null);
    }
    @Nullable List<File> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCommitComparison(
        this.baseCommit,
        this.mergeBaseCommit,
        this.status,
        this.aheadBy,
        this.behindBy,
        this.commits,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitComparison#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitComparison withFiles(@Nullable Iterable<? extends File> elements) {
    if (this.files == elements) return this;
    @Nullable List<File> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCommitComparison(
        this.baseCommit,
        this.mergeBaseCommit,
        this.status,
        this.aheadBy,
        this.behindBy,
        this.commits,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitComparison} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitComparison
        && equalTo((ImmutableCommitComparison) another);
  }

  private boolean equalTo(ImmutableCommitComparison another) {
    return Objects.equals(baseCommit, another.baseCommit)
        && Objects.equals(mergeBaseCommit, another.mergeBaseCommit)
        && Objects.equals(status, another.status)
        && aheadBy == another.aheadBy
        && behindBy == another.behindBy
        && Objects.equals(commits, another.commits)
        && Objects.equals(files, another.files);
  }

  /**
   * Computes a hash code from attributes: {@code baseCommit}, {@code mergeBaseCommit}, {@code status}, {@code aheadBy}, {@code behindBy}, {@code commits}, {@code files}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(baseCommit);
    h += (h << 5) + Objects.hashCode(mergeBaseCommit);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + aheadBy;
    h += (h << 5) + behindBy;
    h += (h << 5) + Objects.hashCode(commits);
    h += (h << 5) + Objects.hashCode(files);
    return h;
  }

  /**
   * Prints the immutable value {@code CommitComparison} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CommitComparison{"
        + "baseCommit=" + baseCommit
        + ", mergeBaseCommit=" + mergeBaseCommit
        + ", status=" + status
        + ", aheadBy=" + aheadBy
        + ", behindBy=" + behindBy
        + ", commits=" + commits
        + ", files=" + files
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CommitComparison", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CommitComparison {
    @Nullable Commit baseCommit;
    @Nullable Commit mergeBaseCommit;
    @Nullable String status;
    int aheadBy;
    boolean aheadByIsSet;
    int behindBy;
    boolean behindByIsSet;
    @Nullable List<Commit> commits = null;
    @Nullable List<File> files = null;
    @JsonProperty
    public void setBaseCommit(@Nullable Commit baseCommit) {
      this.baseCommit = baseCommit;
    }
    @JsonProperty
    public void setMergeBaseCommit(@Nullable Commit mergeBaseCommit) {
      this.mergeBaseCommit = mergeBaseCommit;
    }
    @JsonProperty
    public void setStatus(@Nullable String status) {
      this.status = status;
    }
    @JsonProperty
    public void setAheadBy(int aheadBy) {
      this.aheadBy = aheadBy;
      this.aheadByIsSet = true;
    }
    @JsonProperty
    public void setBehindBy(int behindBy) {
      this.behindBy = behindBy;
      this.behindByIsSet = true;
    }
    @JsonProperty
    public void setCommits(@Nullable List<Commit> commits) {
      this.commits = commits;
    }
    @JsonProperty
    public void setFiles(@Nullable List<File> files) {
      this.files = files;
    }
    @Override
    public Commit baseCommit() { throw new UnsupportedOperationException(); }
    @Override
    public Commit mergeBaseCommit() { throw new UnsupportedOperationException(); }
    @Override
    public String status() { throw new UnsupportedOperationException(); }
    @Override
    public int aheadBy() { throw new UnsupportedOperationException(); }
    @Override
    public int behindBy() { throw new UnsupportedOperationException(); }
    @Override
    public List<Commit> commits() { throw new UnsupportedOperationException(); }
    @Override
    public List<File> files() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCommitComparison fromJson(Json json) {
    ImmutableCommitComparison.Builder builder = ImmutableCommitComparison.builder();
    if (json.baseCommit != null) {
      builder.baseCommit(json.baseCommit);
    }
    if (json.mergeBaseCommit != null) {
      builder.mergeBaseCommit(json.mergeBaseCommit);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.aheadByIsSet) {
      builder.aheadBy(json.aheadBy);
    }
    if (json.behindByIsSet) {
      builder.behindBy(json.behindBy);
    }
    if (json.commits != null) {
      builder.addAllCommits(json.commits);
    }
    if (json.files != null) {
      builder.addAllFiles(json.files);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CommitComparison} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitComparison instance
   */
  public static ImmutableCommitComparison copyOf(CommitComparison instance) {
    if (instance instanceof ImmutableCommitComparison) {
      return (ImmutableCommitComparison) instance;
    }
    return ImmutableCommitComparison.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitComparison ImmutableCommitComparison}.
   * <pre>
   * ImmutableCommitComparison.builder()
   *    .baseCommit(com.spotify.github.v3.repos.Commit | null) // nullable {@link CommitComparison#baseCommit() baseCommit}
   *    .mergeBaseCommit(com.spotify.github.v3.repos.Commit | null) // nullable {@link CommitComparison#mergeBaseCommit() mergeBaseCommit}
   *    .status(String | null) // nullable {@link CommitComparison#status() status}
   *    .aheadBy(int) // required {@link CommitComparison#aheadBy() aheadBy}
   *    .behindBy(int) // required {@link CommitComparison#behindBy() behindBy}
   *    .commits(List&amp;lt;com.spotify.github.v3.repos.Commit&amp;gt; | null) // nullable {@link CommitComparison#commits() commits}
   *    .files(List&amp;lt;com.spotify.github.v3.repos.File&amp;gt; | null) // nullable {@link CommitComparison#files() files}
   *    .build();
   * </pre>
   * @return A new ImmutableCommitComparison builder
   */
  public static ImmutableCommitComparison.Builder builder() {
    return new ImmutableCommitComparison.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitComparison ImmutableCommitComparison}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitComparison", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_AHEAD_BY = 0x1L;
    private static final long INIT_BIT_BEHIND_BY = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Commit baseCommit;
    private @Nullable Commit mergeBaseCommit;
    private @Nullable String status;
    private int aheadBy;
    private int behindBy;
    private List<Commit> commits = null;
    private List<File> files = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommitComparison} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitComparison instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Commit baseCommitValue = instance.baseCommit();
      if (baseCommitValue != null) {
        baseCommit(baseCommitValue);
      }
      @Nullable Commit mergeBaseCommitValue = instance.mergeBaseCommit();
      if (mergeBaseCommitValue != null) {
        mergeBaseCommit(mergeBaseCommitValue);
      }
      @Nullable String statusValue = instance.status();
      if (statusValue != null) {
        status(statusValue);
      }
      aheadBy(instance.aheadBy());
      behindBy(instance.behindBy());
      @Nullable List<Commit> commitsValue = instance.commits();
      if (commitsValue != null) {
        addAllCommits(commitsValue);
      }
      @Nullable List<File> filesValue = instance.files();
      if (filesValue != null) {
        addAllFiles(filesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CommitComparison#baseCommit() baseCommit} attribute.
     * @param baseCommit The value for baseCommit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder baseCommit(@Nullable Commit baseCommit) {
      this.baseCommit = baseCommit;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitComparison#mergeBaseCommit() mergeBaseCommit} attribute.
     * @param mergeBaseCommit The value for mergeBaseCommit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergeBaseCommit(@Nullable Commit mergeBaseCommit) {
      this.mergeBaseCommit = mergeBaseCommit;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitComparison#status() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder status(@Nullable String status) {
      this.status = status;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitComparison#aheadBy() aheadBy} attribute.
     * @param aheadBy The value for aheadBy 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder aheadBy(int aheadBy) {
      this.aheadBy = aheadBy;
      initBits &= ~INIT_BIT_AHEAD_BY;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitComparison#behindBy() behindBy} attribute.
     * @param behindBy The value for behindBy 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder behindBy(int behindBy) {
      this.behindBy = behindBy;
      initBits &= ~INIT_BIT_BEHIND_BY;
      return this;
    }

    /**
     * Adds one element to {@link CommitComparison#commits() commits} list.
     * @param element A commits element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommits(Commit element) {
      if (this.commits == null) {
        this.commits = new ArrayList<Commit>();
      }
      this.commits.add(Objects.requireNonNull(element, "commits element"));
      return this;
    }

    /**
     * Adds elements to {@link CommitComparison#commits() commits} list.
     * @param elements An array of commits elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommits(Commit... elements) {
      if (this.commits == null) {
        this.commits = new ArrayList<Commit>();
      }
      for (Commit element : elements) {
        this.commits.add(Objects.requireNonNull(element, "commits element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CommitComparison#commits() commits} list.
     * @param elements An iterable of commits elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commits(@Nullable Iterable<? extends Commit> elements) {
      if (elements == null) {
        this.commits = null;
        return this;
      }
      this.commits = new ArrayList<Commit>();
      return addAllCommits(elements);
    }

    /**
     * Adds elements to {@link CommitComparison#commits() commits} list.
     * @param elements An iterable of commits elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllCommits(Iterable<? extends Commit> elements) {
      Objects.requireNonNull(elements, "commits element");
      if (this.commits == null) {
        this.commits = new ArrayList<Commit>();
      }
      for (Commit element : elements) {
        this.commits.add(Objects.requireNonNull(element, "commits element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CommitComparison#files() files} list.
     * @param element A files element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFiles(File element) {
      if (this.files == null) {
        this.files = new ArrayList<File>();
      }
      this.files.add(Objects.requireNonNull(element, "files element"));
      return this;
    }

    /**
     * Adds elements to {@link CommitComparison#files() files} list.
     * @param elements An array of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFiles(File... elements) {
      if (this.files == null) {
        this.files = new ArrayList<File>();
      }
      for (File element : elements) {
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CommitComparison#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder files(@Nullable Iterable<? extends File> elements) {
      if (elements == null) {
        this.files = null;
        return this;
      }
      this.files = new ArrayList<File>();
      return addAllFiles(elements);
    }

    /**
     * Adds elements to {@link CommitComparison#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFiles(Iterable<? extends File> elements) {
      Objects.requireNonNull(elements, "files element");
      if (this.files == null) {
        this.files = new ArrayList<File>();
      }
      for (File element : elements) {
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitComparison ImmutableCommitComparison}.
     * @return An immutable instance of CommitComparison
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitComparison build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCommitComparison(
          baseCommit,
          mergeBaseCommit,
          status,
          aheadBy,
          behindBy,
          commits == null ? null : createUnmodifiableList(true, commits),
          files == null ? null : createUnmodifiableList(true, files));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AHEAD_BY) != 0) attributes.add("aheadBy");
      if ((initBits & INIT_BIT_BEHIND_BY) != 0) attributes.add("behindBy");
      return "Cannot build CommitComparison, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
