package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepositoryBase}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepositoryBase.builder()}.
 */
@Generated(from = "RepositoryBase", generator = "Immutables")
@SuppressWarnings({"all", "deprecation"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepositoryBase implements RepositoryBase {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable Integer id;
  private final @Nullable String name;
  private final @Nullable String fullName;
  private final @Nullable String description;
  private final @Nullable Boolean isPrivate;
  private final @Nullable Boolean isArchived;
  private final @Nullable Boolean isPublic;
  private final @Nullable Boolean fork;
  private final @Nullable URI url;
  private final @Nullable URI htmlUrl;
  private final @Nullable Boolean allowSquashMerge;
  private final @Nullable Boolean allowMergeCommit;
  private final @Nullable Boolean allowRebaseMerge;
  private final @Nullable String archiveUrl;
  private final @Nullable String assigneesUrl;
  private final @Nullable String blobsUrl;
  private final @Nullable String branchesUrl;
  private final @Nullable URI cloneUrl;
  private final @Nullable String collaboratorsUrl;
  private final @Nullable String commentsUrl;
  private final @Nullable String commitsUrl;
  private final @Nullable String compareUrl;
  private final @Nullable String contentsUrl;
  private final @Nullable URI contributorsUrl;
  private final @Nullable URI deploymentsUrl;
  private final @Nullable URI downloadsUrl;
  private final @Nullable URI eventsUrl;
  private final @Nullable URI forksUrl;
  private final @Nullable String gitCommitsUrl;
  private final @Nullable String gitRefsUrl;
  private final @Nullable String gitTagsUrl;
  private final @Nullable URI gitUrl;
  private final @Nullable URI hooksUrl;
  private final @Nullable String homepage;
  private final @Nullable String language;
  private final @Nullable Integer forksCount;
  private final @Nullable Integer stargazersCount;
  private final @Nullable Integer watchersCount;
  private final @Nullable Integer size;
  private final @Nullable String defaultBranch;
  private final @Nullable Integer openIssuesCount;
  private final @Nullable Boolean hasIssues;
  private final @Nullable Boolean hasWiki;
  private final @Nullable Boolean hasPages;
  private final @Nullable Boolean hasDownloads;
  private final @Nullable Permissions permissions;
  private final @Nullable Integer forks;
  private final @Nullable GitHubInstant pushedAt;
  private final @Nullable String issuesUrl;
  private final @Nullable String issueCommentUrl;
  private final @Nullable String issueEventsUrl;
  private final @Nullable String keysUrl;
  private final @Nullable String labelsUrl;
  private final @Nullable URI languagesUrl;
  private final @Nullable URI mergesUrl;
  private final @Nullable String milestonesUrl;
  private final @Nullable URI mirrorUrl;
  private final @Nullable String notificationsUrl;
  private final @Nullable Integer openIssues;
  private final @Nullable String pullsUrl;
  private final @Nullable String releasesUrl;
  private final @Nullable String sshUrl;
  private final @Nullable URI stargazersUrl;
  private final @Nullable String statusesUrl;
  private final @Nullable URI subscribersUrl;
  private final @Nullable URI subscriptionUrl;
  private final @Nullable URI svnUrl;
  private final @Nullable URI tagsUrl;
  private final @Nullable String treesUrl;
  private final @Nullable String teamsUrl;
  private final @Nullable Integer watchers;
  private final @Nullable Integer stargazers;
  private final @Nullable String masterBranch;

  private ImmutableRepositoryBase(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable Integer id,
      @Nullable String name,
      @Nullable String fullName,
      @Nullable String description,
      @Nullable Boolean isPrivate,
      @Nullable Boolean isArchived,
      @Nullable Boolean isPublic,
      @Nullable Boolean fork,
      @Nullable URI url,
      @Nullable URI htmlUrl,
      @Nullable Boolean allowSquashMerge,
      @Nullable Boolean allowMergeCommit,
      @Nullable Boolean allowRebaseMerge,
      @Nullable String archiveUrl,
      @Nullable String assigneesUrl,
      @Nullable String blobsUrl,
      @Nullable String branchesUrl,
      @Nullable URI cloneUrl,
      @Nullable String collaboratorsUrl,
      @Nullable String commentsUrl,
      @Nullable String commitsUrl,
      @Nullable String compareUrl,
      @Nullable String contentsUrl,
      @Nullable URI contributorsUrl,
      @Nullable URI deploymentsUrl,
      @Nullable URI downloadsUrl,
      @Nullable URI eventsUrl,
      @Nullable URI forksUrl,
      @Nullable String gitCommitsUrl,
      @Nullable String gitRefsUrl,
      @Nullable String gitTagsUrl,
      @Nullable URI gitUrl,
      @Nullable URI hooksUrl,
      @Nullable String homepage,
      @Nullable String language,
      @Nullable Integer forksCount,
      @Nullable Integer stargazersCount,
      @Nullable Integer watchersCount,
      @Nullable Integer size,
      @Nullable String defaultBranch,
      @Nullable Integer openIssuesCount,
      @Nullable Boolean hasIssues,
      @Nullable Boolean hasWiki,
      @Nullable Boolean hasPages,
      @Nullable Boolean hasDownloads,
      @Nullable Permissions permissions,
      @Nullable Integer forks,
      @Nullable GitHubInstant pushedAt,
      @Nullable String issuesUrl,
      @Nullable String issueCommentUrl,
      @Nullable String issueEventsUrl,
      @Nullable String keysUrl,
      @Nullable String labelsUrl,
      @Nullable URI languagesUrl,
      @Nullable URI mergesUrl,
      @Nullable String milestonesUrl,
      @Nullable URI mirrorUrl,
      @Nullable String notificationsUrl,
      @Nullable Integer openIssues,
      @Nullable String pullsUrl,
      @Nullable String releasesUrl,
      @Nullable String sshUrl,
      @Nullable URI stargazersUrl,
      @Nullable String statusesUrl,
      @Nullable URI subscribersUrl,
      @Nullable URI subscriptionUrl,
      @Nullable URI svnUrl,
      @Nullable URI tagsUrl,
      @Nullable String treesUrl,
      @Nullable String teamsUrl,
      @Nullable Integer watchers,
      @Nullable Integer stargazers,
      @Nullable String masterBranch) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.id = id;
    this.name = name;
    this.fullName = fullName;
    this.description = description;
    this.isPrivate = isPrivate;
    this.isArchived = isArchived;
    this.isPublic = isPublic;
    this.fork = fork;
    this.url = url;
    this.htmlUrl = htmlUrl;
    this.allowSquashMerge = allowSquashMerge;
    this.allowMergeCommit = allowMergeCommit;
    this.allowRebaseMerge = allowRebaseMerge;
    this.archiveUrl = archiveUrl;
    this.assigneesUrl = assigneesUrl;
    this.blobsUrl = blobsUrl;
    this.branchesUrl = branchesUrl;
    this.cloneUrl = cloneUrl;
    this.collaboratorsUrl = collaboratorsUrl;
    this.commentsUrl = commentsUrl;
    this.commitsUrl = commitsUrl;
    this.compareUrl = compareUrl;
    this.contentsUrl = contentsUrl;
    this.contributorsUrl = contributorsUrl;
    this.deploymentsUrl = deploymentsUrl;
    this.downloadsUrl = downloadsUrl;
    this.eventsUrl = eventsUrl;
    this.forksUrl = forksUrl;
    this.gitCommitsUrl = gitCommitsUrl;
    this.gitRefsUrl = gitRefsUrl;
    this.gitTagsUrl = gitTagsUrl;
    this.gitUrl = gitUrl;
    this.hooksUrl = hooksUrl;
    this.homepage = homepage;
    this.language = language;
    this.forksCount = forksCount;
    this.stargazersCount = stargazersCount;
    this.watchersCount = watchersCount;
    this.size = size;
    this.defaultBranch = defaultBranch;
    this.openIssuesCount = openIssuesCount;
    this.hasIssues = hasIssues;
    this.hasWiki = hasWiki;
    this.hasPages = hasPages;
    this.hasDownloads = hasDownloads;
    this.permissions = permissions;
    this.forks = forks;
    this.pushedAt = pushedAt;
    this.issuesUrl = issuesUrl;
    this.issueCommentUrl = issueCommentUrl;
    this.issueEventsUrl = issueEventsUrl;
    this.keysUrl = keysUrl;
    this.labelsUrl = labelsUrl;
    this.languagesUrl = languagesUrl;
    this.mergesUrl = mergesUrl;
    this.milestonesUrl = milestonesUrl;
    this.mirrorUrl = mirrorUrl;
    this.notificationsUrl = notificationsUrl;
    this.openIssues = openIssues;
    this.pullsUrl = pullsUrl;
    this.releasesUrl = releasesUrl;
    this.sshUrl = sshUrl;
    this.stargazersUrl = stargazersUrl;
    this.statusesUrl = statusesUrl;
    this.subscribersUrl = subscribersUrl;
    this.subscriptionUrl = subscriptionUrl;
    this.svnUrl = svnUrl;
    this.tagsUrl = tagsUrl;
    this.treesUrl = treesUrl;
    this.teamsUrl = teamsUrl;
    this.watchers = watchers;
    this.stargazers = stargazers;
    this.masterBranch = masterBranch;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   *ID 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *Name 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *Full name: org/repo 
   */
  @JsonProperty
  @Override
  public @Nullable String fullName() {
    return fullName;
  }

  /**
   *Description 
   */
  @JsonProperty
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   *Is it private 
   */
  @JsonProperty("private")
  @Override
  public @Nullable Boolean isPrivate() {
    return isPrivate;
  }

  /**
   *Is it archived 
   */
  @JsonProperty("archived")
  @Override
  public @Nullable Boolean isArchived() {
    return isArchived;
  }

  /**
   *Is it public 
   */
  @JsonProperty("public")
  @Override
  public Optional<Boolean> isPublic() {
    return Optional.ofNullable(isPublic);
  }

  /**
   *Is it a fork 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean fork() {
    return fork;
  }

  /**
   *API URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *HTML URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Allow squash merges 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean allowSquashMerge() {
    return allowSquashMerge;
  }

  /**
   *Allow merge commits 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean allowMergeCommit() {
    return allowMergeCommit;
  }

  /**
   *Allow rebase merges 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean allowRebaseMerge() {
    return allowRebaseMerge;
  }

  /**
   *Archive URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String archiveUrl() {
    return archiveUrl;
  }

  /**
   *Assignees URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String assigneesUrl() {
    return assigneesUrl;
  }

  /**
   *Blobs URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String blobsUrl() {
    return blobsUrl;
  }

  /**
   *Branches URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String branchesUrl() {
    return branchesUrl;
  }

  /**
   *Clone URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI cloneUrl() {
    return cloneUrl;
  }

  /**
   *Collaborators URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String collaboratorsUrl() {
    return collaboratorsUrl;
  }

  /**
   *Comments URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String commentsUrl() {
    return commentsUrl;
  }

  /**
   *Commits URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String commitsUrl() {
    return commitsUrl;
  }

  /**
   *Compare URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String compareUrl() {
    return compareUrl;
  }

  /**
   *Contents URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String contentsUrl() {
    return contentsUrl;
  }

  /**
   *Contributors URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI contributorsUrl() {
    return contributorsUrl;
  }

  /**
   *Deployments URL 
   */
  @JsonProperty
  @Override
  public Optional<URI> deploymentsUrl() {
    return Optional.ofNullable(deploymentsUrl);
  }

  /**
   *Downloads URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI downloadsUrl() {
    return downloadsUrl;
  }

  /**
   *Events URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI eventsUrl() {
    return eventsUrl;
  }

  /**
   *Forks URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI forksUrl() {
    return forksUrl;
  }

  /**
   *Git commits URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String gitCommitsUrl() {
    return gitCommitsUrl;
  }

  /**
   *Git references URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String gitRefsUrl() {
    return gitRefsUrl;
  }

  /**
   *Git tags URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String gitTagsUrl() {
    return gitTagsUrl;
  }

  /**
   *Git URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI gitUrl() {
    return gitUrl;
  }

  /**
   *Hooks URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI hooksUrl() {
    return hooksUrl;
  }

  /**
   *Homepage URL 
   */
  @JsonProperty
  @Override
  public Optional<String> homepage() {
    return Optional.ofNullable(homepage);
  }

  /**
   *Language 
   */
  @JsonProperty
  @Override
  public Optional<String> language() {
    return Optional.ofNullable(language);
  }

  /**
   *Forks count 
   */
  @JsonProperty
  @Override
  public @Nullable Integer forksCount() {
    return forksCount;
  }

  /**
   *Stargazers count 
   */
  @JsonProperty
  @Override
  public @Nullable Integer stargazersCount() {
    return stargazersCount;
  }

  /**
   *Watchers count 
   */
  @JsonProperty
  @Override
  public @Nullable Integer watchersCount() {
    return watchersCount;
  }

  /**
   *Size in kB 
   */
  @JsonProperty
  @Override
  public @Nullable Integer size() {
    return size;
  }

  /**
   *Default branch 
   */
  @JsonProperty
  @Override
  public @Nullable String defaultBranch() {
    return defaultBranch;
  }

  /**
   *Open issues count 
   */
  @JsonProperty
  @Override
  public @Nullable Integer openIssuesCount() {
    return openIssuesCount;
  }

  /**
   *Does it have issues 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean hasIssues() {
    return hasIssues;
  }

  /**
   *Does it have wiki 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean hasWiki() {
    return hasWiki;
  }

  /**
   *Does it have pages 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean hasPages() {
    return hasPages;
  }

  /**
   *Does it have downloads 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean hasDownloads() {
    return hasDownloads;
  }

  /**
   *Permissions 
   */
  @JsonProperty
  @Override
  public Optional<Permissions> permissions() {
    return Optional.ofNullable(permissions);
  }

  /**
   *Deprecated forks, {@link #forksCount()} 
   */
  @JsonProperty
  @Deprecated
  @Override
  public @Nullable Integer forks() {
    return forks;
  }

  /**
   *Pushed date 
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant pushedAt() {
    return pushedAt;
  }

  /**
   *Issues URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String issuesUrl() {
    return issuesUrl;
  }

  /**
   *Issue Comment URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String issueCommentUrl() {
    return issueCommentUrl;
  }

  /**
   *Issue event URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String issueEventsUrl() {
    return issueEventsUrl;
  }

  /**
   *Keys URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String keysUrl() {
    return keysUrl;
  }

  /**
   *Labels URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String labelsUrl() {
    return labelsUrl;
  }

  /**
   *Languages URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI languagesUrl() {
    return languagesUrl;
  }

  /**
   *Merges URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI mergesUrl() {
    return mergesUrl;
  }

  /**
   *Milestones URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String milestonesUrl() {
    return milestonesUrl;
  }

  /**
   *Mirror url, if this repo is a mirror 
   */
  @JsonProperty
  @Override
  public Optional<URI> mirrorUrl() {
    return Optional.ofNullable(mirrorUrl);
  }

  /**
   *Notifications URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String notificationsUrl() {
    return notificationsUrl;
  }

  /**
   *Deprecated open issues, {@link #openIssuesCount()} 
   */
  @JsonProperty
  @Deprecated
  @Override
  public Optional<Integer> openIssues() {
    return Optional.ofNullable(openIssues);
  }

  /**
   *Pulls URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String pullsUrl() {
    return pullsUrl;
  }

  /**
   *Releases URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String releasesUrl() {
    return releasesUrl;
  }

  /**
   *SSH URL. 
   */
  @JsonProperty
  @Override
  public @Nullable String sshUrl() {
    return sshUrl;
  }

  /**
   *Stargazers URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI stargazersUrl() {
    return stargazersUrl;
  }

  /**
   *Statuses URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String statusesUrl() {
    return statusesUrl;
  }

  /**
   *Subscribers URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI subscribersUrl() {
    return subscribersUrl;
  }

  /**
   *Subscription URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI subscriptionUrl() {
    return subscriptionUrl;
  }

  /**
   *Subversion URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI svnUrl() {
    return svnUrl;
  }

  /**
   *Tags URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI tagsUrl() {
    return tagsUrl;
  }

  /**
   *Trees URL template 
   */
  @JsonProperty
  @Override
  public @Nullable String treesUrl() {
    return treesUrl;
  }

  /**
   *Teams URL 
   */
  @JsonProperty
  @Override
  public @Nullable String teamsUrl() {
    return teamsUrl;
  }

  /**
   *Deprecated watchers, {@link #watchersCount()} 
   */
  @JsonProperty
  @Deprecated
  @Override
  public Optional<Integer> watchers() {
    return Optional.ofNullable(watchers);
  }

  /**
   *Deprecated stargazers, {@link #stargazersCount()} 
   */
  @JsonProperty
  @Deprecated
  @Override
  public Optional<Integer> stargazers() {
    return Optional.ofNullable(stargazers);
  }

  /**
   *Deprecated masterBranch, {@link #defaultBranch()} 
   */
  @JsonProperty
  @Deprecated
  @Override
  public Optional<String> masterBranch() {
    return Optional.ofNullable(masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableRepositoryBase(
        value,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        value,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        value,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        value,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#fullName() fullName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fullName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withFullName(@Nullable String value) {
    if (Objects.equals(this.fullName, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        value,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withDescription(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        newValue,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        value,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#isPrivate() isPrivate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isPrivate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withIsPrivate(@Nullable Boolean value) {
    if (Objects.equals(this.isPrivate, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        value,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#isArchived() isArchived} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isArchived (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withIsArchived(@Nullable Boolean value) {
    if (Objects.equals(this.isArchived, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        value,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#isPublic() isPublic} attribute.
   * @param value The value for isPublic
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withIsPublic(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isPublic, newValue)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        newValue,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#isPublic() isPublic} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isPublic
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withIsPublic(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isPublic, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        value,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#fork() fork} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fork (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withFork(@Nullable Boolean value) {
    if (Objects.equals(this.fork, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        value,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        value,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        value,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#allowSquashMerge() allowSquashMerge} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for allowSquashMerge (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withAllowSquashMerge(@Nullable Boolean value) {
    if (Objects.equals(this.allowSquashMerge, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        value,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#allowMergeCommit() allowMergeCommit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for allowMergeCommit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withAllowMergeCommit(@Nullable Boolean value) {
    if (Objects.equals(this.allowMergeCommit, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        value,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#allowRebaseMerge() allowRebaseMerge} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for allowRebaseMerge (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withAllowRebaseMerge(@Nullable Boolean value) {
    if (Objects.equals(this.allowRebaseMerge, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        value,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#archiveUrl() archiveUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for archiveUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withArchiveUrl(@Nullable String value) {
    if (Objects.equals(this.archiveUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        value,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#assigneesUrl() assigneesUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for assigneesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withAssigneesUrl(@Nullable String value) {
    if (Objects.equals(this.assigneesUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        value,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#blobsUrl() blobsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blobsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withBlobsUrl(@Nullable String value) {
    if (Objects.equals(this.blobsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        value,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#branchesUrl() branchesUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for branchesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withBranchesUrl(@Nullable String value) {
    if (Objects.equals(this.branchesUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        value,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#cloneUrl() cloneUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cloneUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withCloneUrl(@Nullable URI value) {
    if (this.cloneUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        value,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#collaboratorsUrl() collaboratorsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collaboratorsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withCollaboratorsUrl(@Nullable String value) {
    if (Objects.equals(this.collaboratorsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        value,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#commentsUrl() commentsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commentsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withCommentsUrl(@Nullable String value) {
    if (Objects.equals(this.commentsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        value,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#commitsUrl() commitsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withCommitsUrl(@Nullable String value) {
    if (Objects.equals(this.commitsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        value,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#compareUrl() compareUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for compareUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withCompareUrl(@Nullable String value) {
    if (Objects.equals(this.compareUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        value,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#contentsUrl() contentsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withContentsUrl(@Nullable String value) {
    if (Objects.equals(this.contentsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        value,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#contributorsUrl() contributorsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contributorsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withContributorsUrl(@Nullable URI value) {
    if (this.contributorsUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        value,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#deploymentsUrl() deploymentsUrl} attribute.
   * @param value The value for deploymentsUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withDeploymentsUrl(URI value) {
    @Nullable URI newValue = Objects.requireNonNull(value, "deploymentsUrl");
    if (this.deploymentsUrl == newValue) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        newValue,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#deploymentsUrl() deploymentsUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for deploymentsUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableRepositoryBase withDeploymentsUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.deploymentsUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        value,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#downloadsUrl() downloadsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withDownloadsUrl(@Nullable URI value) {
    if (this.downloadsUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        value,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#eventsUrl() eventsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withEventsUrl(@Nullable URI value) {
    if (this.eventsUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        value,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#forksUrl() forksUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forksUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withForksUrl(@Nullable URI value) {
    if (this.forksUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        value,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#gitCommitsUrl() gitCommitsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gitCommitsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withGitCommitsUrl(@Nullable String value) {
    if (Objects.equals(this.gitCommitsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        value,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#gitRefsUrl() gitRefsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gitRefsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withGitRefsUrl(@Nullable String value) {
    if (Objects.equals(this.gitRefsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        value,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#gitTagsUrl() gitTagsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gitTagsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withGitTagsUrl(@Nullable String value) {
    if (Objects.equals(this.gitTagsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        value,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#gitUrl() gitUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gitUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withGitUrl(@Nullable URI value) {
    if (this.gitUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        value,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#hooksUrl() hooksUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hooksUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withHooksUrl(@Nullable URI value) {
    if (this.hooksUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        value,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#homepage() homepage} attribute.
   * @param value The value for homepage
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withHomepage(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "homepage");
    if (Objects.equals(this.homepage, newValue)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        newValue,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#homepage() homepage} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for homepage
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withHomepage(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.homepage, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        value,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#language() language} attribute.
   * @param value The value for language
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withLanguage(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "language");
    if (Objects.equals(this.language, newValue)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        newValue,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#language() language} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for language
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withLanguage(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.language, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        value,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#forksCount() forksCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forksCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withForksCount(@Nullable Integer value) {
    if (Objects.equals(this.forksCount, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        value,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#stargazersCount() stargazersCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stargazersCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withStargazersCount(@Nullable Integer value) {
    if (Objects.equals(this.stargazersCount, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        value,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#watchersCount() watchersCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for watchersCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withWatchersCount(@Nullable Integer value) {
    if (Objects.equals(this.watchersCount, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        value,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#size() size} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for size (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withSize(@Nullable Integer value) {
    if (Objects.equals(this.size, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        value,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#defaultBranch() defaultBranch} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultBranch (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withDefaultBranch(@Nullable String value) {
    if (Objects.equals(this.defaultBranch, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        value,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#openIssuesCount() openIssuesCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for openIssuesCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withOpenIssuesCount(@Nullable Integer value) {
    if (Objects.equals(this.openIssuesCount, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        value,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#hasIssues() hasIssues} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hasIssues (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withHasIssues(@Nullable Boolean value) {
    if (Objects.equals(this.hasIssues, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        value,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#hasWiki() hasWiki} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hasWiki (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withHasWiki(@Nullable Boolean value) {
    if (Objects.equals(this.hasWiki, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        value,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#hasPages() hasPages} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hasPages (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withHasPages(@Nullable Boolean value) {
    if (Objects.equals(this.hasPages, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        value,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#hasDownloads() hasDownloads} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hasDownloads (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withHasDownloads(@Nullable Boolean value) {
    if (Objects.equals(this.hasDownloads, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        value,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#permissions() permissions} attribute.
   * @param value The value for permissions
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withPermissions(Permissions value) {
    @Nullable Permissions newValue = Objects.requireNonNull(value, "permissions");
    if (this.permissions == newValue) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        newValue,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#permissions() permissions} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for permissions
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableRepositoryBase withPermissions(Optional<? extends Permissions> optional) {
    @Nullable Permissions value = optional.orElse(null);
    if (this.permissions == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        value,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#forks() forks} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forks (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  @Deprecated
  public final ImmutableRepositoryBase withForks(@Nullable Integer value) {
    if (Objects.equals(this.forks, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        value,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#pushedAt() pushedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pushedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withPushedAt(@Nullable GitHubInstant value) {
    if (this.pushedAt == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        value,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#issuesUrl() issuesUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for issuesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withIssuesUrl(@Nullable String value) {
    if (Objects.equals(this.issuesUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        value,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#issueCommentUrl() issueCommentUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for issueCommentUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withIssueCommentUrl(@Nullable String value) {
    if (Objects.equals(this.issueCommentUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        value,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#issueEventsUrl() issueEventsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for issueEventsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withIssueEventsUrl(@Nullable String value) {
    if (Objects.equals(this.issueEventsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        value,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#keysUrl() keysUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keysUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withKeysUrl(@Nullable String value) {
    if (Objects.equals(this.keysUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        value,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#labelsUrl() labelsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for labelsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withLabelsUrl(@Nullable String value) {
    if (Objects.equals(this.labelsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        value,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#languagesUrl() languagesUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for languagesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withLanguagesUrl(@Nullable URI value) {
    if (this.languagesUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        value,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#mergesUrl() mergesUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mergesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withMergesUrl(@Nullable URI value) {
    if (this.mergesUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        value,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#milestonesUrl() milestonesUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for milestonesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withMilestonesUrl(@Nullable String value) {
    if (Objects.equals(this.milestonesUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        value,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#mirrorUrl() mirrorUrl} attribute.
   * @param value The value for mirrorUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepositoryBase withMirrorUrl(URI value) {
    @Nullable URI newValue = Objects.requireNonNull(value, "mirrorUrl");
    if (this.mirrorUrl == newValue) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        newValue,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#mirrorUrl() mirrorUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mirrorUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableRepositoryBase withMirrorUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.mirrorUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        value,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#notificationsUrl() notificationsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for notificationsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withNotificationsUrl(@Nullable String value) {
    if (Objects.equals(this.notificationsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        value,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#openIssues() openIssues} attribute.
   * @param value The value for openIssues
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableRepositoryBase withOpenIssues(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.openIssues, newValue)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        newValue,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#openIssues() openIssues} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for openIssues
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableRepositoryBase withOpenIssues(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.openIssues, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        value,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#pullsUrl() pullsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pullsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withPullsUrl(@Nullable String value) {
    if (Objects.equals(this.pullsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        value,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#releasesUrl() releasesUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for releasesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withReleasesUrl(@Nullable String value) {
    if (Objects.equals(this.releasesUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        value,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#sshUrl() sshUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sshUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withSshUrl(@Nullable String value) {
    if (Objects.equals(this.sshUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        value,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#stargazersUrl() stargazersUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stargazersUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withStargazersUrl(@Nullable URI value) {
    if (this.stargazersUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        value,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#statusesUrl() statusesUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for statusesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withStatusesUrl(@Nullable String value) {
    if (Objects.equals(this.statusesUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        value,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#subscribersUrl() subscribersUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for subscribersUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withSubscribersUrl(@Nullable URI value) {
    if (this.subscribersUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        value,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#subscriptionUrl() subscriptionUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for subscriptionUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withSubscriptionUrl(@Nullable URI value) {
    if (this.subscriptionUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        value,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#svnUrl() svnUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for svnUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withSvnUrl(@Nullable URI value) {
    if (this.svnUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        value,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#tagsUrl() tagsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tagsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withTagsUrl(@Nullable URI value) {
    if (this.tagsUrl == value) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        value,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#treesUrl() treesUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for treesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withTreesUrl(@Nullable String value) {
    if (Objects.equals(this.treesUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        value,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryBase#teamsUrl() teamsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for teamsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryBase withTeamsUrl(@Nullable String value) {
    if (Objects.equals(this.teamsUrl, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        value,
        this.watchers,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#watchers() watchers} attribute.
   * @param value The value for watchers
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableRepositoryBase withWatchers(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.watchers, newValue)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        newValue,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#watchers() watchers} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for watchers
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableRepositoryBase withWatchers(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.watchers, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        value,
        this.stargazers,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#stargazers() stargazers} attribute.
   * @param value The value for stargazers
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableRepositoryBase withStargazers(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.stargazers, newValue)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        newValue,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#stargazers() stargazers} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for stargazers
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableRepositoryBase withStargazers(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.stargazers, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        value,
        this.masterBranch);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepositoryBase#masterBranch() masterBranch} attribute.
   * @param value The value for masterBranch
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableRepositoryBase withMasterBranch(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "masterBranch");
    if (Objects.equals(this.masterBranch, newValue)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepositoryBase#masterBranch() masterBranch} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for masterBranch
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableRepositoryBase withMasterBranch(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.masterBranch, value)) return this;
    return new ImmutableRepositoryBase(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.name,
        this.fullName,
        this.description,
        this.isPrivate,
        this.isArchived,
        this.isPublic,
        this.fork,
        this.url,
        this.htmlUrl,
        this.allowSquashMerge,
        this.allowMergeCommit,
        this.allowRebaseMerge,
        this.archiveUrl,
        this.assigneesUrl,
        this.blobsUrl,
        this.branchesUrl,
        this.cloneUrl,
        this.collaboratorsUrl,
        this.commentsUrl,
        this.commitsUrl,
        this.compareUrl,
        this.contentsUrl,
        this.contributorsUrl,
        this.deploymentsUrl,
        this.downloadsUrl,
        this.eventsUrl,
        this.forksUrl,
        this.gitCommitsUrl,
        this.gitRefsUrl,
        this.gitTagsUrl,
        this.gitUrl,
        this.hooksUrl,
        this.homepage,
        this.language,
        this.forksCount,
        this.stargazersCount,
        this.watchersCount,
        this.size,
        this.defaultBranch,
        this.openIssuesCount,
        this.hasIssues,
        this.hasWiki,
        this.hasPages,
        this.hasDownloads,
        this.permissions,
        this.forks,
        this.pushedAt,
        this.issuesUrl,
        this.issueCommentUrl,
        this.issueEventsUrl,
        this.keysUrl,
        this.labelsUrl,
        this.languagesUrl,
        this.mergesUrl,
        this.milestonesUrl,
        this.mirrorUrl,
        this.notificationsUrl,
        this.openIssues,
        this.pullsUrl,
        this.releasesUrl,
        this.sshUrl,
        this.stargazersUrl,
        this.statusesUrl,
        this.subscribersUrl,
        this.subscriptionUrl,
        this.svnUrl,
        this.tagsUrl,
        this.treesUrl,
        this.teamsUrl,
        this.watchers,
        this.stargazers,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepositoryBase} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepositoryBase
        && equalTo((ImmutableRepositoryBase) another);
  }

  private boolean equalTo(ImmutableRepositoryBase another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(fullName, another.fullName)
        && Objects.equals(description, another.description)
        && Objects.equals(isPrivate, another.isPrivate)
        && Objects.equals(isArchived, another.isArchived)
        && Objects.equals(isPublic, another.isPublic)
        && Objects.equals(fork, another.fork)
        && Objects.equals(url, another.url)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(allowSquashMerge, another.allowSquashMerge)
        && Objects.equals(allowMergeCommit, another.allowMergeCommit)
        && Objects.equals(allowRebaseMerge, another.allowRebaseMerge)
        && Objects.equals(archiveUrl, another.archiveUrl)
        && Objects.equals(assigneesUrl, another.assigneesUrl)
        && Objects.equals(blobsUrl, another.blobsUrl)
        && Objects.equals(branchesUrl, another.branchesUrl)
        && Objects.equals(cloneUrl, another.cloneUrl)
        && Objects.equals(collaboratorsUrl, another.collaboratorsUrl)
        && Objects.equals(commentsUrl, another.commentsUrl)
        && Objects.equals(commitsUrl, another.commitsUrl)
        && Objects.equals(compareUrl, another.compareUrl)
        && Objects.equals(contentsUrl, another.contentsUrl)
        && Objects.equals(contributorsUrl, another.contributorsUrl)
        && Objects.equals(deploymentsUrl, another.deploymentsUrl)
        && Objects.equals(downloadsUrl, another.downloadsUrl)
        && Objects.equals(eventsUrl, another.eventsUrl)
        && Objects.equals(forksUrl, another.forksUrl)
        && Objects.equals(gitCommitsUrl, another.gitCommitsUrl)
        && Objects.equals(gitRefsUrl, another.gitRefsUrl)
        && Objects.equals(gitTagsUrl, another.gitTagsUrl)
        && Objects.equals(gitUrl, another.gitUrl)
        && Objects.equals(hooksUrl, another.hooksUrl)
        && Objects.equals(homepage, another.homepage)
        && Objects.equals(language, another.language)
        && Objects.equals(forksCount, another.forksCount)
        && Objects.equals(stargazersCount, another.stargazersCount)
        && Objects.equals(watchersCount, another.watchersCount)
        && Objects.equals(size, another.size)
        && Objects.equals(defaultBranch, another.defaultBranch)
        && Objects.equals(openIssuesCount, another.openIssuesCount)
        && Objects.equals(hasIssues, another.hasIssues)
        && Objects.equals(hasWiki, another.hasWiki)
        && Objects.equals(hasPages, another.hasPages)
        && Objects.equals(hasDownloads, another.hasDownloads)
        && Objects.equals(permissions, another.permissions)
        && Objects.equals(forks, another.forks)
        && Objects.equals(pushedAt, another.pushedAt)
        && Objects.equals(issuesUrl, another.issuesUrl)
        && Objects.equals(issueCommentUrl, another.issueCommentUrl)
        && Objects.equals(issueEventsUrl, another.issueEventsUrl)
        && Objects.equals(keysUrl, another.keysUrl)
        && Objects.equals(labelsUrl, another.labelsUrl)
        && Objects.equals(languagesUrl, another.languagesUrl)
        && Objects.equals(mergesUrl, another.mergesUrl)
        && Objects.equals(milestonesUrl, another.milestonesUrl)
        && Objects.equals(mirrorUrl, another.mirrorUrl)
        && Objects.equals(notificationsUrl, another.notificationsUrl)
        && Objects.equals(openIssues, another.openIssues)
        && Objects.equals(pullsUrl, another.pullsUrl)
        && Objects.equals(releasesUrl, another.releasesUrl)
        && Objects.equals(sshUrl, another.sshUrl)
        && Objects.equals(stargazersUrl, another.stargazersUrl)
        && Objects.equals(statusesUrl, another.statusesUrl)
        && Objects.equals(subscribersUrl, another.subscribersUrl)
        && Objects.equals(subscriptionUrl, another.subscriptionUrl)
        && Objects.equals(svnUrl, another.svnUrl)
        && Objects.equals(tagsUrl, another.tagsUrl)
        && Objects.equals(treesUrl, another.treesUrl)
        && Objects.equals(teamsUrl, another.teamsUrl)
        && Objects.equals(watchers, another.watchers)
        && Objects.equals(stargazers, another.stargazers)
        && Objects.equals(masterBranch, another.masterBranch);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code id}, {@code name}, {@code fullName}, {@code description}, {@code isPrivate}, {@code isArchived}, {@code isPublic}, {@code fork}, {@code url}, {@code htmlUrl}, {@code allowSquashMerge}, {@code allowMergeCommit}, {@code allowRebaseMerge}, {@code archiveUrl}, {@code assigneesUrl}, {@code blobsUrl}, {@code branchesUrl}, {@code cloneUrl}, {@code collaboratorsUrl}, {@code commentsUrl}, {@code commitsUrl}, {@code compareUrl}, {@code contentsUrl}, {@code contributorsUrl}, {@code deploymentsUrl}, {@code downloadsUrl}, {@code eventsUrl}, {@code forksUrl}, {@code gitCommitsUrl}, {@code gitRefsUrl}, {@code gitTagsUrl}, {@code gitUrl}, {@code hooksUrl}, {@code homepage}, {@code language}, {@code forksCount}, {@code stargazersCount}, {@code watchersCount}, {@code size}, {@code defaultBranch}, {@code openIssuesCount}, {@code hasIssues}, {@code hasWiki}, {@code hasPages}, {@code hasDownloads}, {@code permissions}, {@code forks}, {@code pushedAt}, {@code issuesUrl}, {@code issueCommentUrl}, {@code issueEventsUrl}, {@code keysUrl}, {@code labelsUrl}, {@code languagesUrl}, {@code mergesUrl}, {@code milestonesUrl}, {@code mirrorUrl}, {@code notificationsUrl}, {@code openIssues}, {@code pullsUrl}, {@code releasesUrl}, {@code sshUrl}, {@code stargazersUrl}, {@code statusesUrl}, {@code subscribersUrl}, {@code subscriptionUrl}, {@code svnUrl}, {@code tagsUrl}, {@code treesUrl}, {@code teamsUrl}, {@code watchers}, {@code stargazers}, {@code masterBranch}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(fullName);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(isPrivate);
    h += (h << 5) + Objects.hashCode(isArchived);
    h += (h << 5) + Objects.hashCode(isPublic);
    h += (h << 5) + Objects.hashCode(fork);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(allowSquashMerge);
    h += (h << 5) + Objects.hashCode(allowMergeCommit);
    h += (h << 5) + Objects.hashCode(allowRebaseMerge);
    h += (h << 5) + Objects.hashCode(archiveUrl);
    h += (h << 5) + Objects.hashCode(assigneesUrl);
    h += (h << 5) + Objects.hashCode(blobsUrl);
    h += (h << 5) + Objects.hashCode(branchesUrl);
    h += (h << 5) + Objects.hashCode(cloneUrl);
    h += (h << 5) + Objects.hashCode(collaboratorsUrl);
    h += (h << 5) + Objects.hashCode(commentsUrl);
    h += (h << 5) + Objects.hashCode(commitsUrl);
    h += (h << 5) + Objects.hashCode(compareUrl);
    h += (h << 5) + Objects.hashCode(contentsUrl);
    h += (h << 5) + Objects.hashCode(contributorsUrl);
    h += (h << 5) + Objects.hashCode(deploymentsUrl);
    h += (h << 5) + Objects.hashCode(downloadsUrl);
    h += (h << 5) + Objects.hashCode(eventsUrl);
    h += (h << 5) + Objects.hashCode(forksUrl);
    h += (h << 5) + Objects.hashCode(gitCommitsUrl);
    h += (h << 5) + Objects.hashCode(gitRefsUrl);
    h += (h << 5) + Objects.hashCode(gitTagsUrl);
    h += (h << 5) + Objects.hashCode(gitUrl);
    h += (h << 5) + Objects.hashCode(hooksUrl);
    h += (h << 5) + Objects.hashCode(homepage);
    h += (h << 5) + Objects.hashCode(language);
    h += (h << 5) + Objects.hashCode(forksCount);
    h += (h << 5) + Objects.hashCode(stargazersCount);
    h += (h << 5) + Objects.hashCode(watchersCount);
    h += (h << 5) + Objects.hashCode(size);
    h += (h << 5) + Objects.hashCode(defaultBranch);
    h += (h << 5) + Objects.hashCode(openIssuesCount);
    h += (h << 5) + Objects.hashCode(hasIssues);
    h += (h << 5) + Objects.hashCode(hasWiki);
    h += (h << 5) + Objects.hashCode(hasPages);
    h += (h << 5) + Objects.hashCode(hasDownloads);
    h += (h << 5) + Objects.hashCode(permissions);
    h += (h << 5) + Objects.hashCode(forks);
    h += (h << 5) + Objects.hashCode(pushedAt);
    h += (h << 5) + Objects.hashCode(issuesUrl);
    h += (h << 5) + Objects.hashCode(issueCommentUrl);
    h += (h << 5) + Objects.hashCode(issueEventsUrl);
    h += (h << 5) + Objects.hashCode(keysUrl);
    h += (h << 5) + Objects.hashCode(labelsUrl);
    h += (h << 5) + Objects.hashCode(languagesUrl);
    h += (h << 5) + Objects.hashCode(mergesUrl);
    h += (h << 5) + Objects.hashCode(milestonesUrl);
    h += (h << 5) + Objects.hashCode(mirrorUrl);
    h += (h << 5) + Objects.hashCode(notificationsUrl);
    h += (h << 5) + Objects.hashCode(openIssues);
    h += (h << 5) + Objects.hashCode(pullsUrl);
    h += (h << 5) + Objects.hashCode(releasesUrl);
    h += (h << 5) + Objects.hashCode(sshUrl);
    h += (h << 5) + Objects.hashCode(stargazersUrl);
    h += (h << 5) + Objects.hashCode(statusesUrl);
    h += (h << 5) + Objects.hashCode(subscribersUrl);
    h += (h << 5) + Objects.hashCode(subscriptionUrl);
    h += (h << 5) + Objects.hashCode(svnUrl);
    h += (h << 5) + Objects.hashCode(tagsUrl);
    h += (h << 5) + Objects.hashCode(treesUrl);
    h += (h << 5) + Objects.hashCode(teamsUrl);
    h += (h << 5) + Objects.hashCode(watchers);
    h += (h << 5) + Objects.hashCode(stargazers);
    h += (h << 5) + Objects.hashCode(masterBranch);
    return h;
  }

  /**
   * Prints the immutable value {@code RepositoryBase} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("RepositoryBase{");
    if (createdAt != null) {
      builder.append("createdAt=").append(createdAt);
    }
    if (updatedAt != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("updatedAt=").append(updatedAt);
    }
    if (id != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("id=").append(id);
    }
    if (name != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("name=").append(name);
    }
    if (fullName != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("fullName=").append(fullName);
    }
    if (description != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("description=").append(description);
    }
    if (isPrivate != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("isPrivate=").append(isPrivate);
    }
    if (isArchived != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("isArchived=").append(isArchived);
    }
    if (isPublic != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("isPublic=").append(isPublic);
    }
    if (fork != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("fork=").append(fork);
    }
    if (url != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (htmlUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    if (allowSquashMerge != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("allowSquashMerge=").append(allowSquashMerge);
    }
    if (allowMergeCommit != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("allowMergeCommit=").append(allowMergeCommit);
    }
    if (allowRebaseMerge != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("allowRebaseMerge=").append(allowRebaseMerge);
    }
    if (archiveUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("archiveUrl=").append(archiveUrl);
    }
    if (assigneesUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("assigneesUrl=").append(assigneesUrl);
    }
    if (blobsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("blobsUrl=").append(blobsUrl);
    }
    if (branchesUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("branchesUrl=").append(branchesUrl);
    }
    if (cloneUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("cloneUrl=").append(cloneUrl);
    }
    if (collaboratorsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("collaboratorsUrl=").append(collaboratorsUrl);
    }
    if (commentsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("commentsUrl=").append(commentsUrl);
    }
    if (commitsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("commitsUrl=").append(commitsUrl);
    }
    if (compareUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("compareUrl=").append(compareUrl);
    }
    if (contentsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("contentsUrl=").append(contentsUrl);
    }
    if (contributorsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("contributorsUrl=").append(contributorsUrl);
    }
    if (deploymentsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("deploymentsUrl=").append(deploymentsUrl);
    }
    if (downloadsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("downloadsUrl=").append(downloadsUrl);
    }
    if (eventsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("eventsUrl=").append(eventsUrl);
    }
    if (forksUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("forksUrl=").append(forksUrl);
    }
    if (gitCommitsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("gitCommitsUrl=").append(gitCommitsUrl);
    }
    if (gitRefsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("gitRefsUrl=").append(gitRefsUrl);
    }
    if (gitTagsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("gitTagsUrl=").append(gitTagsUrl);
    }
    if (gitUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("gitUrl=").append(gitUrl);
    }
    if (hooksUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("hooksUrl=").append(hooksUrl);
    }
    if (homepage != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("homepage=").append(homepage);
    }
    if (language != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("language=").append(language);
    }
    if (forksCount != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("forksCount=").append(forksCount);
    }
    if (stargazersCount != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("stargazersCount=").append(stargazersCount);
    }
    if (watchersCount != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("watchersCount=").append(watchersCount);
    }
    if (size != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("size=").append(size);
    }
    if (defaultBranch != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("defaultBranch=").append(defaultBranch);
    }
    if (openIssuesCount != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("openIssuesCount=").append(openIssuesCount);
    }
    if (hasIssues != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("hasIssues=").append(hasIssues);
    }
    if (hasWiki != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("hasWiki=").append(hasWiki);
    }
    if (hasPages != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("hasPages=").append(hasPages);
    }
    if (hasDownloads != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("hasDownloads=").append(hasDownloads);
    }
    if (permissions != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("permissions=").append(permissions);
    }
    if (forks != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("forks=").append(forks);
    }
    if (pushedAt != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("pushedAt=").append(pushedAt);
    }
    if (issuesUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("issuesUrl=").append(issuesUrl);
    }
    if (issueCommentUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("issueCommentUrl=").append(issueCommentUrl);
    }
    if (issueEventsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("issueEventsUrl=").append(issueEventsUrl);
    }
    if (keysUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("keysUrl=").append(keysUrl);
    }
    if (labelsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("labelsUrl=").append(labelsUrl);
    }
    if (languagesUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("languagesUrl=").append(languagesUrl);
    }
    if (mergesUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("mergesUrl=").append(mergesUrl);
    }
    if (milestonesUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("milestonesUrl=").append(milestonesUrl);
    }
    if (mirrorUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("mirrorUrl=").append(mirrorUrl);
    }
    if (notificationsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("notificationsUrl=").append(notificationsUrl);
    }
    if (openIssues != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("openIssues=").append(openIssues);
    }
    if (pullsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("pullsUrl=").append(pullsUrl);
    }
    if (releasesUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("releasesUrl=").append(releasesUrl);
    }
    if (sshUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("sshUrl=").append(sshUrl);
    }
    if (stargazersUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("stargazersUrl=").append(stargazersUrl);
    }
    if (statusesUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("statusesUrl=").append(statusesUrl);
    }
    if (subscribersUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("subscribersUrl=").append(subscribersUrl);
    }
    if (subscriptionUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("subscriptionUrl=").append(subscriptionUrl);
    }
    if (svnUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("svnUrl=").append(svnUrl);
    }
    if (tagsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("tagsUrl=").append(tagsUrl);
    }
    if (treesUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("treesUrl=").append(treesUrl);
    }
    if (teamsUrl != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("teamsUrl=").append(teamsUrl);
    }
    if (watchers != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("watchers=").append(watchers);
    }
    if (stargazers != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("stargazers=").append(stargazers);
    }
    if (masterBranch != null) {
      if (builder.length() > 15) builder.append(", ");
      builder.append("masterBranch=").append(masterBranch);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RepositoryBase", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RepositoryBase {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable Integer id;
    @Nullable String name;
    @Nullable String fullName;
    @Nullable Optional<String> description = Optional.empty();
    @Nullable Boolean isPrivate;
    @Nullable Boolean isArchived;
    @Nullable Optional<Boolean> isPublic = Optional.empty();
    @Nullable Boolean fork;
    @Nullable URI url;
    @Nullable URI htmlUrl;
    @Nullable Boolean allowSquashMerge;
    @Nullable Boolean allowMergeCommit;
    @Nullable Boolean allowRebaseMerge;
    @Nullable String archiveUrl;
    @Nullable String assigneesUrl;
    @Nullable String blobsUrl;
    @Nullable String branchesUrl;
    @Nullable URI cloneUrl;
    @Nullable String collaboratorsUrl;
    @Nullable String commentsUrl;
    @Nullable String commitsUrl;
    @Nullable String compareUrl;
    @Nullable String contentsUrl;
    @Nullable URI contributorsUrl;
    @Nullable Optional<URI> deploymentsUrl = Optional.empty();
    @Nullable URI downloadsUrl;
    @Nullable URI eventsUrl;
    @Nullable URI forksUrl;
    @Nullable String gitCommitsUrl;
    @Nullable String gitRefsUrl;
    @Nullable String gitTagsUrl;
    @Nullable URI gitUrl;
    @Nullable URI hooksUrl;
    @Nullable Optional<String> homepage = Optional.empty();
    @Nullable Optional<String> language = Optional.empty();
    @Nullable Integer forksCount;
    @Nullable Integer stargazersCount;
    @Nullable Integer watchersCount;
    @Nullable Integer size;
    @Nullable String defaultBranch;
    @Nullable Integer openIssuesCount;
    @Nullable Boolean hasIssues;
    @Nullable Boolean hasWiki;
    @Nullable Boolean hasPages;
    @Nullable Boolean hasDownloads;
    @Nullable Optional<Permissions> permissions = Optional.empty();
    @Nullable Integer forks;
    @Nullable GitHubInstant pushedAt;
    @Nullable String issuesUrl;
    @Nullable String issueCommentUrl;
    @Nullable String issueEventsUrl;
    @Nullable String keysUrl;
    @Nullable String labelsUrl;
    @Nullable URI languagesUrl;
    @Nullable URI mergesUrl;
    @Nullable String milestonesUrl;
    @Nullable Optional<URI> mirrorUrl = Optional.empty();
    @Nullable String notificationsUrl;
    @Nullable Optional<Integer> openIssues = Optional.empty();
    @Nullable String pullsUrl;
    @Nullable String releasesUrl;
    @Nullable String sshUrl;
    @Nullable URI stargazersUrl;
    @Nullable String statusesUrl;
    @Nullable URI subscribersUrl;
    @Nullable URI subscriptionUrl;
    @Nullable URI svnUrl;
    @Nullable URI tagsUrl;
    @Nullable String treesUrl;
    @Nullable String teamsUrl;
    @Nullable Optional<Integer> watchers = Optional.empty();
    @Nullable Optional<Integer> stargazers = Optional.empty();
    @Nullable Optional<String> masterBranch = Optional.empty();
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setFullName(@Nullable String fullName) {
      this.fullName = fullName;
    }
    @JsonProperty
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty("private")
    public void setIsPrivate(@Nullable Boolean isPrivate) {
      this.isPrivate = isPrivate;
    }
    @JsonProperty("archived")
    public void setIsArchived(@Nullable Boolean isArchived) {
      this.isArchived = isArchived;
    }
    @JsonProperty("public")
    public void setIsPublic(Optional<Boolean> isPublic) {
      this.isPublic = isPublic;
    }
    @JsonProperty
    public void setFork(@Nullable Boolean fork) {
      this.fork = fork;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setAllowSquashMerge(@Nullable Boolean allowSquashMerge) {
      this.allowSquashMerge = allowSquashMerge;
    }
    @JsonProperty
    public void setAllowMergeCommit(@Nullable Boolean allowMergeCommit) {
      this.allowMergeCommit = allowMergeCommit;
    }
    @JsonProperty
    public void setAllowRebaseMerge(@Nullable Boolean allowRebaseMerge) {
      this.allowRebaseMerge = allowRebaseMerge;
    }
    @JsonProperty
    public void setArchiveUrl(@Nullable String archiveUrl) {
      this.archiveUrl = archiveUrl;
    }
    @JsonProperty
    public void setAssigneesUrl(@Nullable String assigneesUrl) {
      this.assigneesUrl = assigneesUrl;
    }
    @JsonProperty
    public void setBlobsUrl(@Nullable String blobsUrl) {
      this.blobsUrl = blobsUrl;
    }
    @JsonProperty
    public void setBranchesUrl(@Nullable String branchesUrl) {
      this.branchesUrl = branchesUrl;
    }
    @JsonProperty
    public void setCloneUrl(@Nullable URI cloneUrl) {
      this.cloneUrl = cloneUrl;
    }
    @JsonProperty
    public void setCollaboratorsUrl(@Nullable String collaboratorsUrl) {
      this.collaboratorsUrl = collaboratorsUrl;
    }
    @JsonProperty
    public void setCommentsUrl(@Nullable String commentsUrl) {
      this.commentsUrl = commentsUrl;
    }
    @JsonProperty
    public void setCommitsUrl(@Nullable String commitsUrl) {
      this.commitsUrl = commitsUrl;
    }
    @JsonProperty
    public void setCompareUrl(@Nullable String compareUrl) {
      this.compareUrl = compareUrl;
    }
    @JsonProperty
    public void setContentsUrl(@Nullable String contentsUrl) {
      this.contentsUrl = contentsUrl;
    }
    @JsonProperty
    public void setContributorsUrl(@Nullable URI contributorsUrl) {
      this.contributorsUrl = contributorsUrl;
    }
    @JsonProperty
    public void setDeploymentsUrl(Optional<URI> deploymentsUrl) {
      this.deploymentsUrl = deploymentsUrl;
    }
    @JsonProperty
    public void setDownloadsUrl(@Nullable URI downloadsUrl) {
      this.downloadsUrl = downloadsUrl;
    }
    @JsonProperty
    public void setEventsUrl(@Nullable URI eventsUrl) {
      this.eventsUrl = eventsUrl;
    }
    @JsonProperty
    public void setForksUrl(@Nullable URI forksUrl) {
      this.forksUrl = forksUrl;
    }
    @JsonProperty
    public void setGitCommitsUrl(@Nullable String gitCommitsUrl) {
      this.gitCommitsUrl = gitCommitsUrl;
    }
    @JsonProperty
    public void setGitRefsUrl(@Nullable String gitRefsUrl) {
      this.gitRefsUrl = gitRefsUrl;
    }
    @JsonProperty
    public void setGitTagsUrl(@Nullable String gitTagsUrl) {
      this.gitTagsUrl = gitTagsUrl;
    }
    @JsonProperty
    public void setGitUrl(@Nullable URI gitUrl) {
      this.gitUrl = gitUrl;
    }
    @JsonProperty
    public void setHooksUrl(@Nullable URI hooksUrl) {
      this.hooksUrl = hooksUrl;
    }
    @JsonProperty
    public void setHomepage(Optional<String> homepage) {
      this.homepage = homepage;
    }
    @JsonProperty
    public void setLanguage(Optional<String> language) {
      this.language = language;
    }
    @JsonProperty
    public void setForksCount(@Nullable Integer forksCount) {
      this.forksCount = forksCount;
    }
    @JsonProperty
    public void setStargazersCount(@Nullable Integer stargazersCount) {
      this.stargazersCount = stargazersCount;
    }
    @JsonProperty
    public void setWatchersCount(@Nullable Integer watchersCount) {
      this.watchersCount = watchersCount;
    }
    @JsonProperty
    public void setSize(@Nullable Integer size) {
      this.size = size;
    }
    @JsonProperty
    public void setDefaultBranch(@Nullable String defaultBranch) {
      this.defaultBranch = defaultBranch;
    }
    @JsonProperty
    public void setOpenIssuesCount(@Nullable Integer openIssuesCount) {
      this.openIssuesCount = openIssuesCount;
    }
    @JsonProperty
    public void setHasIssues(@Nullable Boolean hasIssues) {
      this.hasIssues = hasIssues;
    }
    @JsonProperty
    public void setHasWiki(@Nullable Boolean hasWiki) {
      this.hasWiki = hasWiki;
    }
    @JsonProperty
    public void setHasPages(@Nullable Boolean hasPages) {
      this.hasPages = hasPages;
    }
    @JsonProperty
    public void setHasDownloads(@Nullable Boolean hasDownloads) {
      this.hasDownloads = hasDownloads;
    }
    @JsonProperty
    public void setPermissions(Optional<Permissions> permissions) {
      this.permissions = permissions;
    }
    @JsonProperty
    public void setForks(@Nullable Integer forks) {
      this.forks = forks;
    }
    @JsonProperty
    public void setPushedAt(@Nullable GitHubInstant pushedAt) {
      this.pushedAt = pushedAt;
    }
    @JsonProperty
    public void setIssuesUrl(@Nullable String issuesUrl) {
      this.issuesUrl = issuesUrl;
    }
    @JsonProperty
    public void setIssueCommentUrl(@Nullable String issueCommentUrl) {
      this.issueCommentUrl = issueCommentUrl;
    }
    @JsonProperty
    public void setIssueEventsUrl(@Nullable String issueEventsUrl) {
      this.issueEventsUrl = issueEventsUrl;
    }
    @JsonProperty
    public void setKeysUrl(@Nullable String keysUrl) {
      this.keysUrl = keysUrl;
    }
    @JsonProperty
    public void setLabelsUrl(@Nullable String labelsUrl) {
      this.labelsUrl = labelsUrl;
    }
    @JsonProperty
    public void setLanguagesUrl(@Nullable URI languagesUrl) {
      this.languagesUrl = languagesUrl;
    }
    @JsonProperty
    public void setMergesUrl(@Nullable URI mergesUrl) {
      this.mergesUrl = mergesUrl;
    }
    @JsonProperty
    public void setMilestonesUrl(@Nullable String milestonesUrl) {
      this.milestonesUrl = milestonesUrl;
    }
    @JsonProperty
    public void setMirrorUrl(Optional<URI> mirrorUrl) {
      this.mirrorUrl = mirrorUrl;
    }
    @JsonProperty
    public void setNotificationsUrl(@Nullable String notificationsUrl) {
      this.notificationsUrl = notificationsUrl;
    }
    @JsonProperty
    public void setOpenIssues(Optional<Integer> openIssues) {
      this.openIssues = openIssues;
    }
    @JsonProperty
    public void setPullsUrl(@Nullable String pullsUrl) {
      this.pullsUrl = pullsUrl;
    }
    @JsonProperty
    public void setReleasesUrl(@Nullable String releasesUrl) {
      this.releasesUrl = releasesUrl;
    }
    @JsonProperty
    public void setSshUrl(@Nullable String sshUrl) {
      this.sshUrl = sshUrl;
    }
    @JsonProperty
    public void setStargazersUrl(@Nullable URI stargazersUrl) {
      this.stargazersUrl = stargazersUrl;
    }
    @JsonProperty
    public void setStatusesUrl(@Nullable String statusesUrl) {
      this.statusesUrl = statusesUrl;
    }
    @JsonProperty
    public void setSubscribersUrl(@Nullable URI subscribersUrl) {
      this.subscribersUrl = subscribersUrl;
    }
    @JsonProperty
    public void setSubscriptionUrl(@Nullable URI subscriptionUrl) {
      this.subscriptionUrl = subscriptionUrl;
    }
    @JsonProperty
    public void setSvnUrl(@Nullable URI svnUrl) {
      this.svnUrl = svnUrl;
    }
    @JsonProperty
    public void setTagsUrl(@Nullable URI tagsUrl) {
      this.tagsUrl = tagsUrl;
    }
    @JsonProperty
    public void setTreesUrl(@Nullable String treesUrl) {
      this.treesUrl = treesUrl;
    }
    @JsonProperty
    public void setTeamsUrl(@Nullable String teamsUrl) {
      this.teamsUrl = teamsUrl;
    }
    @JsonProperty
    public void setWatchers(Optional<Integer> watchers) {
      this.watchers = watchers;
    }
    @JsonProperty
    public void setStargazers(Optional<Integer> stargazers) {
      this.stargazers = stargazers;
    }
    @JsonProperty
    public void setMasterBranch(Optional<String> masterBranch) {
      this.masterBranch = masterBranch;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String fullName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean isPrivate() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean isArchived() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isPublic() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean fork() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean allowSquashMerge() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean allowMergeCommit() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean allowRebaseMerge() { throw new UnsupportedOperationException(); }
    @Override
    public String archiveUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String assigneesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String blobsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String branchesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI cloneUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String collaboratorsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String commentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String commitsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String compareUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String contentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI contributorsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> deploymentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI downloadsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI eventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI forksUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String gitCommitsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String gitRefsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String gitTagsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI gitUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI hooksUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> homepage() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> language() { throw new UnsupportedOperationException(); }
    @Override
    public Integer forksCount() { throw new UnsupportedOperationException(); }
    @Override
    public Integer stargazersCount() { throw new UnsupportedOperationException(); }
    @Override
    public Integer watchersCount() { throw new UnsupportedOperationException(); }
    @Override
    public Integer size() { throw new UnsupportedOperationException(); }
    @Override
    public String defaultBranch() { throw new UnsupportedOperationException(); }
    @Override
    public Integer openIssuesCount() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean hasIssues() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean hasWiki() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean hasPages() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean hasDownloads() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Permissions> permissions() { throw new UnsupportedOperationException(); }
    @Override
    public Integer forks() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant pushedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String issuesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String issueCommentUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String issueEventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String keysUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String labelsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI languagesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI mergesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String milestonesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> mirrorUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String notificationsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> openIssues() { throw new UnsupportedOperationException(); }
    @Override
    public String pullsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String releasesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String sshUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI stargazersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String statusesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI subscribersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI subscriptionUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI svnUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI tagsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String treesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String teamsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> watchers() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> stargazers() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> masterBranch() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRepositoryBase fromJson(Json json) {
    ImmutableRepositoryBase.Builder builder = ImmutableRepositoryBase.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.fullName != null) {
      builder.fullName(json.fullName);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.isPrivate != null) {
      builder.isPrivate(json.isPrivate);
    }
    if (json.isArchived != null) {
      builder.isArchived(json.isArchived);
    }
    if (json.isPublic != null) {
      builder.isPublic(json.isPublic);
    }
    if (json.fork != null) {
      builder.fork(json.fork);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.allowSquashMerge != null) {
      builder.allowSquashMerge(json.allowSquashMerge);
    }
    if (json.allowMergeCommit != null) {
      builder.allowMergeCommit(json.allowMergeCommit);
    }
    if (json.allowRebaseMerge != null) {
      builder.allowRebaseMerge(json.allowRebaseMerge);
    }
    if (json.archiveUrl != null) {
      builder.archiveUrl(json.archiveUrl);
    }
    if (json.assigneesUrl != null) {
      builder.assigneesUrl(json.assigneesUrl);
    }
    if (json.blobsUrl != null) {
      builder.blobsUrl(json.blobsUrl);
    }
    if (json.branchesUrl != null) {
      builder.branchesUrl(json.branchesUrl);
    }
    if (json.cloneUrl != null) {
      builder.cloneUrl(json.cloneUrl);
    }
    if (json.collaboratorsUrl != null) {
      builder.collaboratorsUrl(json.collaboratorsUrl);
    }
    if (json.commentsUrl != null) {
      builder.commentsUrl(json.commentsUrl);
    }
    if (json.commitsUrl != null) {
      builder.commitsUrl(json.commitsUrl);
    }
    if (json.compareUrl != null) {
      builder.compareUrl(json.compareUrl);
    }
    if (json.contentsUrl != null) {
      builder.contentsUrl(json.contentsUrl);
    }
    if (json.contributorsUrl != null) {
      builder.contributorsUrl(json.contributorsUrl);
    }
    if (json.deploymentsUrl != null) {
      builder.deploymentsUrl(json.deploymentsUrl);
    }
    if (json.downloadsUrl != null) {
      builder.downloadsUrl(json.downloadsUrl);
    }
    if (json.eventsUrl != null) {
      builder.eventsUrl(json.eventsUrl);
    }
    if (json.forksUrl != null) {
      builder.forksUrl(json.forksUrl);
    }
    if (json.gitCommitsUrl != null) {
      builder.gitCommitsUrl(json.gitCommitsUrl);
    }
    if (json.gitRefsUrl != null) {
      builder.gitRefsUrl(json.gitRefsUrl);
    }
    if (json.gitTagsUrl != null) {
      builder.gitTagsUrl(json.gitTagsUrl);
    }
    if (json.gitUrl != null) {
      builder.gitUrl(json.gitUrl);
    }
    if (json.hooksUrl != null) {
      builder.hooksUrl(json.hooksUrl);
    }
    if (json.homepage != null) {
      builder.homepage(json.homepage);
    }
    if (json.language != null) {
      builder.language(json.language);
    }
    if (json.forksCount != null) {
      builder.forksCount(json.forksCount);
    }
    if (json.stargazersCount != null) {
      builder.stargazersCount(json.stargazersCount);
    }
    if (json.watchersCount != null) {
      builder.watchersCount(json.watchersCount);
    }
    if (json.size != null) {
      builder.size(json.size);
    }
    if (json.defaultBranch != null) {
      builder.defaultBranch(json.defaultBranch);
    }
    if (json.openIssuesCount != null) {
      builder.openIssuesCount(json.openIssuesCount);
    }
    if (json.hasIssues != null) {
      builder.hasIssues(json.hasIssues);
    }
    if (json.hasWiki != null) {
      builder.hasWiki(json.hasWiki);
    }
    if (json.hasPages != null) {
      builder.hasPages(json.hasPages);
    }
    if (json.hasDownloads != null) {
      builder.hasDownloads(json.hasDownloads);
    }
    if (json.permissions != null) {
      builder.permissions(json.permissions);
    }
    if (json.forks != null) {
      builder.forks(json.forks);
    }
    if (json.pushedAt != null) {
      builder.pushedAt(json.pushedAt);
    }
    if (json.issuesUrl != null) {
      builder.issuesUrl(json.issuesUrl);
    }
    if (json.issueCommentUrl != null) {
      builder.issueCommentUrl(json.issueCommentUrl);
    }
    if (json.issueEventsUrl != null) {
      builder.issueEventsUrl(json.issueEventsUrl);
    }
    if (json.keysUrl != null) {
      builder.keysUrl(json.keysUrl);
    }
    if (json.labelsUrl != null) {
      builder.labelsUrl(json.labelsUrl);
    }
    if (json.languagesUrl != null) {
      builder.languagesUrl(json.languagesUrl);
    }
    if (json.mergesUrl != null) {
      builder.mergesUrl(json.mergesUrl);
    }
    if (json.milestonesUrl != null) {
      builder.milestonesUrl(json.milestonesUrl);
    }
    if (json.mirrorUrl != null) {
      builder.mirrorUrl(json.mirrorUrl);
    }
    if (json.notificationsUrl != null) {
      builder.notificationsUrl(json.notificationsUrl);
    }
    if (json.openIssues != null) {
      builder.openIssues(json.openIssues);
    }
    if (json.pullsUrl != null) {
      builder.pullsUrl(json.pullsUrl);
    }
    if (json.releasesUrl != null) {
      builder.releasesUrl(json.releasesUrl);
    }
    if (json.sshUrl != null) {
      builder.sshUrl(json.sshUrl);
    }
    if (json.stargazersUrl != null) {
      builder.stargazersUrl(json.stargazersUrl);
    }
    if (json.statusesUrl != null) {
      builder.statusesUrl(json.statusesUrl);
    }
    if (json.subscribersUrl != null) {
      builder.subscribersUrl(json.subscribersUrl);
    }
    if (json.subscriptionUrl != null) {
      builder.subscriptionUrl(json.subscriptionUrl);
    }
    if (json.svnUrl != null) {
      builder.svnUrl(json.svnUrl);
    }
    if (json.tagsUrl != null) {
      builder.tagsUrl(json.tagsUrl);
    }
    if (json.treesUrl != null) {
      builder.treesUrl(json.treesUrl);
    }
    if (json.teamsUrl != null) {
      builder.teamsUrl(json.teamsUrl);
    }
    if (json.watchers != null) {
      builder.watchers(json.watchers);
    }
    if (json.stargazers != null) {
      builder.stargazers(json.stargazers);
    }
    if (json.masterBranch != null) {
      builder.masterBranch(json.masterBranch);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RepositoryBase} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepositoryBase instance
   */
  public static ImmutableRepositoryBase copyOf(RepositoryBase instance) {
    if (instance instanceof ImmutableRepositoryBase) {
      return (ImmutableRepositoryBase) instance;
    }
    return ImmutableRepositoryBase.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepositoryBase ImmutableRepositoryBase}.
   * <pre>
   * ImmutableRepositoryBase.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link RepositoryBase#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link RepositoryBase#updatedAt() updatedAt}
   *    .id(Integer | null) // nullable {@link RepositoryBase#id() id}
   *    .name(String | null) // nullable {@link RepositoryBase#name() name}
   *    .fullName(String | null) // nullable {@link RepositoryBase#fullName() fullName}
   *    .description(String) // optional {@link RepositoryBase#description() description}
   *    .isPrivate(Boolean | null) // nullable {@link RepositoryBase#isPrivate() isPrivate}
   *    .isArchived(Boolean | null) // nullable {@link RepositoryBase#isArchived() isArchived}
   *    .isPublic(Boolean) // optional {@link RepositoryBase#isPublic() isPublic}
   *    .fork(Boolean | null) // nullable {@link RepositoryBase#fork() fork}
   *    .url(java.net.URI | null) // nullable {@link RepositoryBase#url() url}
   *    .htmlUrl(java.net.URI | null) // nullable {@link RepositoryBase#htmlUrl() htmlUrl}
   *    .allowSquashMerge(Boolean | null) // nullable {@link RepositoryBase#allowSquashMerge() allowSquashMerge}
   *    .allowMergeCommit(Boolean | null) // nullable {@link RepositoryBase#allowMergeCommit() allowMergeCommit}
   *    .allowRebaseMerge(Boolean | null) // nullable {@link RepositoryBase#allowRebaseMerge() allowRebaseMerge}
   *    .archiveUrl(String | null) // nullable {@link RepositoryBase#archiveUrl() archiveUrl}
   *    .assigneesUrl(String | null) // nullable {@link RepositoryBase#assigneesUrl() assigneesUrl}
   *    .blobsUrl(String | null) // nullable {@link RepositoryBase#blobsUrl() blobsUrl}
   *    .branchesUrl(String | null) // nullable {@link RepositoryBase#branchesUrl() branchesUrl}
   *    .cloneUrl(java.net.URI | null) // nullable {@link RepositoryBase#cloneUrl() cloneUrl}
   *    .collaboratorsUrl(String | null) // nullable {@link RepositoryBase#collaboratorsUrl() collaboratorsUrl}
   *    .commentsUrl(String | null) // nullable {@link RepositoryBase#commentsUrl() commentsUrl}
   *    .commitsUrl(String | null) // nullable {@link RepositoryBase#commitsUrl() commitsUrl}
   *    .compareUrl(String | null) // nullable {@link RepositoryBase#compareUrl() compareUrl}
   *    .contentsUrl(String | null) // nullable {@link RepositoryBase#contentsUrl() contentsUrl}
   *    .contributorsUrl(java.net.URI | null) // nullable {@link RepositoryBase#contributorsUrl() contributorsUrl}
   *    .deploymentsUrl(java.net.URI) // optional {@link RepositoryBase#deploymentsUrl() deploymentsUrl}
   *    .downloadsUrl(java.net.URI | null) // nullable {@link RepositoryBase#downloadsUrl() downloadsUrl}
   *    .eventsUrl(java.net.URI | null) // nullable {@link RepositoryBase#eventsUrl() eventsUrl}
   *    .forksUrl(java.net.URI | null) // nullable {@link RepositoryBase#forksUrl() forksUrl}
   *    .gitCommitsUrl(String | null) // nullable {@link RepositoryBase#gitCommitsUrl() gitCommitsUrl}
   *    .gitRefsUrl(String | null) // nullable {@link RepositoryBase#gitRefsUrl() gitRefsUrl}
   *    .gitTagsUrl(String | null) // nullable {@link RepositoryBase#gitTagsUrl() gitTagsUrl}
   *    .gitUrl(java.net.URI | null) // nullable {@link RepositoryBase#gitUrl() gitUrl}
   *    .hooksUrl(java.net.URI | null) // nullable {@link RepositoryBase#hooksUrl() hooksUrl}
   *    .homepage(String) // optional {@link RepositoryBase#homepage() homepage}
   *    .language(String) // optional {@link RepositoryBase#language() language}
   *    .forksCount(Integer | null) // nullable {@link RepositoryBase#forksCount() forksCount}
   *    .stargazersCount(Integer | null) // nullable {@link RepositoryBase#stargazersCount() stargazersCount}
   *    .watchersCount(Integer | null) // nullable {@link RepositoryBase#watchersCount() watchersCount}
   *    .size(Integer | null) // nullable {@link RepositoryBase#size() size}
   *    .defaultBranch(String | null) // nullable {@link RepositoryBase#defaultBranch() defaultBranch}
   *    .openIssuesCount(Integer | null) // nullable {@link RepositoryBase#openIssuesCount() openIssuesCount}
   *    .hasIssues(Boolean | null) // nullable {@link RepositoryBase#hasIssues() hasIssues}
   *    .hasWiki(Boolean | null) // nullable {@link RepositoryBase#hasWiki() hasWiki}
   *    .hasPages(Boolean | null) // nullable {@link RepositoryBase#hasPages() hasPages}
   *    .hasDownloads(Boolean | null) // nullable {@link RepositoryBase#hasDownloads() hasDownloads}
   *    .permissions(com.spotify.github.v3.repos.Permissions) // optional {@link RepositoryBase#permissions() permissions}
   *    .forks(Integer | null) // nullable {@link RepositoryBase#forks() forks}
   *    .pushedAt(com.spotify.github.GitHubInstant | null) // nullable {@link RepositoryBase#pushedAt() pushedAt}
   *    .issuesUrl(String | null) // nullable {@link RepositoryBase#issuesUrl() issuesUrl}
   *    .issueCommentUrl(String | null) // nullable {@link RepositoryBase#issueCommentUrl() issueCommentUrl}
   *    .issueEventsUrl(String | null) // nullable {@link RepositoryBase#issueEventsUrl() issueEventsUrl}
   *    .keysUrl(String | null) // nullable {@link RepositoryBase#keysUrl() keysUrl}
   *    .labelsUrl(String | null) // nullable {@link RepositoryBase#labelsUrl() labelsUrl}
   *    .languagesUrl(java.net.URI | null) // nullable {@link RepositoryBase#languagesUrl() languagesUrl}
   *    .mergesUrl(java.net.URI | null) // nullable {@link RepositoryBase#mergesUrl() mergesUrl}
   *    .milestonesUrl(String | null) // nullable {@link RepositoryBase#milestonesUrl() milestonesUrl}
   *    .mirrorUrl(java.net.URI) // optional {@link RepositoryBase#mirrorUrl() mirrorUrl}
   *    .notificationsUrl(String | null) // nullable {@link RepositoryBase#notificationsUrl() notificationsUrl}
   *    .openIssues(Integer) // optional {@link RepositoryBase#openIssues() openIssues}
   *    .pullsUrl(String | null) // nullable {@link RepositoryBase#pullsUrl() pullsUrl}
   *    .releasesUrl(String | null) // nullable {@link RepositoryBase#releasesUrl() releasesUrl}
   *    .sshUrl(String | null) // nullable {@link RepositoryBase#sshUrl() sshUrl}
   *    .stargazersUrl(java.net.URI | null) // nullable {@link RepositoryBase#stargazersUrl() stargazersUrl}
   *    .statusesUrl(String | null) // nullable {@link RepositoryBase#statusesUrl() statusesUrl}
   *    .subscribersUrl(java.net.URI | null) // nullable {@link RepositoryBase#subscribersUrl() subscribersUrl}
   *    .subscriptionUrl(java.net.URI | null) // nullable {@link RepositoryBase#subscriptionUrl() subscriptionUrl}
   *    .svnUrl(java.net.URI | null) // nullable {@link RepositoryBase#svnUrl() svnUrl}
   *    .tagsUrl(java.net.URI | null) // nullable {@link RepositoryBase#tagsUrl() tagsUrl}
   *    .treesUrl(String | null) // nullable {@link RepositoryBase#treesUrl() treesUrl}
   *    .teamsUrl(String | null) // nullable {@link RepositoryBase#teamsUrl() teamsUrl}
   *    .watchers(Integer) // optional {@link RepositoryBase#watchers() watchers}
   *    .stargazers(Integer) // optional {@link RepositoryBase#stargazers() stargazers}
   *    .masterBranch(String) // optional {@link RepositoryBase#masterBranch() masterBranch}
   *    .build();
   * </pre>
   * @return A new ImmutableRepositoryBase builder
   */
  public static ImmutableRepositoryBase.Builder builder() {
    return new ImmutableRepositoryBase.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepositoryBase ImmutableRepositoryBase}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepositoryBase", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable Integer id;
    private @Nullable String name;
    private @Nullable String fullName;
    private @Nullable String description;
    private @Nullable Boolean isPrivate;
    private @Nullable Boolean isArchived;
    private @Nullable Boolean isPublic;
    private @Nullable Boolean fork;
    private @Nullable URI url;
    private @Nullable URI htmlUrl;
    private @Nullable Boolean allowSquashMerge;
    private @Nullable Boolean allowMergeCommit;
    private @Nullable Boolean allowRebaseMerge;
    private @Nullable String archiveUrl;
    private @Nullable String assigneesUrl;
    private @Nullable String blobsUrl;
    private @Nullable String branchesUrl;
    private @Nullable URI cloneUrl;
    private @Nullable String collaboratorsUrl;
    private @Nullable String commentsUrl;
    private @Nullable String commitsUrl;
    private @Nullable String compareUrl;
    private @Nullable String contentsUrl;
    private @Nullable URI contributorsUrl;
    private @Nullable URI deploymentsUrl;
    private @Nullable URI downloadsUrl;
    private @Nullable URI eventsUrl;
    private @Nullable URI forksUrl;
    private @Nullable String gitCommitsUrl;
    private @Nullable String gitRefsUrl;
    private @Nullable String gitTagsUrl;
    private @Nullable URI gitUrl;
    private @Nullable URI hooksUrl;
    private @Nullable String homepage;
    private @Nullable String language;
    private @Nullable Integer forksCount;
    private @Nullable Integer stargazersCount;
    private @Nullable Integer watchersCount;
    private @Nullable Integer size;
    private @Nullable String defaultBranch;
    private @Nullable Integer openIssuesCount;
    private @Nullable Boolean hasIssues;
    private @Nullable Boolean hasWiki;
    private @Nullable Boolean hasPages;
    private @Nullable Boolean hasDownloads;
    private @Nullable Permissions permissions;
    private @Nullable Integer forks;
    private @Nullable GitHubInstant pushedAt;
    private @Nullable String issuesUrl;
    private @Nullable String issueCommentUrl;
    private @Nullable String issueEventsUrl;
    private @Nullable String keysUrl;
    private @Nullable String labelsUrl;
    private @Nullable URI languagesUrl;
    private @Nullable URI mergesUrl;
    private @Nullable String milestonesUrl;
    private @Nullable URI mirrorUrl;
    private @Nullable String notificationsUrl;
    private @Nullable Integer openIssues;
    private @Nullable String pullsUrl;
    private @Nullable String releasesUrl;
    private @Nullable String sshUrl;
    private @Nullable URI stargazersUrl;
    private @Nullable String statusesUrl;
    private @Nullable URI subscribersUrl;
    private @Nullable URI subscriptionUrl;
    private @Nullable URI svnUrl;
    private @Nullable URI tagsUrl;
    private @Nullable String treesUrl;
    private @Nullable String teamsUrl;
    private @Nullable Integer watchers;
    private @Nullable Integer stargazers;
    private @Nullable String masterBranch;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.repos.RepositoryBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepositoryBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof RepositoryBase) {
        RepositoryBase instance = (RepositoryBase) object;
        @Nullable String sshUrlValue = instance.sshUrl();
        if (sshUrlValue != null) {
          sshUrl(sshUrlValue);
        }
        @Nullable String archiveUrlValue = instance.archiveUrl();
        if (archiveUrlValue != null) {
          archiveUrl(archiveUrlValue);
        }
        Optional<String> languageOptional = instance.language();
        if (languageOptional.isPresent()) {
          language(languageOptional);
        }
        @Nullable URI languagesUrlValue = instance.languagesUrl();
        if (languagesUrlValue != null) {
          languagesUrl(languagesUrlValue);
        }
        @Nullable String assigneesUrlValue = instance.assigneesUrl();
        if (assigneesUrlValue != null) {
          assigneesUrl(assigneesUrlValue);
        }
        @Nullable String commitsUrlValue = instance.commitsUrl();
        if (commitsUrlValue != null) {
          commitsUrl(commitsUrlValue);
        }
        Optional<Integer> openIssuesOptional = instance.openIssues();
        if (openIssuesOptional.isPresent()) {
          openIssues(openIssuesOptional);
        }
        @Nullable URI cloneUrlValue = instance.cloneUrl();
        if (cloneUrlValue != null) {
          cloneUrl(cloneUrlValue);
        }
        @Nullable Integer forksCountValue = instance.forksCount();
        if (forksCountValue != null) {
          forksCount(forksCountValue);
        }
        @Nullable URI subscribersUrlValue = instance.subscribersUrl();
        if (subscribersUrlValue != null) {
          subscribersUrl(subscribersUrlValue);
        }
        @Nullable URI forksUrlValue = instance.forksUrl();
        if (forksUrlValue != null) {
          forksUrl(forksUrlValue);
        }
        @Nullable Integer watchersCountValue = instance.watchersCount();
        if (watchersCountValue != null) {
          watchersCount(watchersCountValue);
        }
        Optional<Permissions> permissionsOptional = instance.permissions();
        if (permissionsOptional.isPresent()) {
          permissions(permissionsOptional);
        }
        Optional<String> masterBranchOptional = instance.masterBranch();
        if (masterBranchOptional.isPresent()) {
          masterBranch(masterBranchOptional);
        }
        @Nullable String issueCommentUrlValue = instance.issueCommentUrl();
        if (issueCommentUrlValue != null) {
          issueCommentUrl(issueCommentUrlValue);
        }
        @Nullable String statusesUrlValue = instance.statusesUrl();
        if (statusesUrlValue != null) {
          statusesUrl(statusesUrlValue);
        }
        @Nullable Integer idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable String collaboratorsUrlValue = instance.collaboratorsUrl();
        if (collaboratorsUrlValue != null) {
          collaboratorsUrl(collaboratorsUrlValue);
        }
        @Nullable Boolean allowMergeCommitValue = instance.allowMergeCommit();
        if (allowMergeCommitValue != null) {
          allowMergeCommit(allowMergeCommitValue);
        }
        @Nullable Integer forksValue = instance.forks();
        if (forksValue != null) {
          forks(forksValue);
        }
        @Nullable String labelsUrlValue = instance.labelsUrl();
        if (labelsUrlValue != null) {
          labelsUrl(labelsUrlValue);
        }
        @Nullable String defaultBranchValue = instance.defaultBranch();
        if (defaultBranchValue != null) {
          defaultBranch(defaultBranchValue);
        }
        @Nullable String keysUrlValue = instance.keysUrl();
        if (keysUrlValue != null) {
          keysUrl(keysUrlValue);
        }
        @Nullable URI downloadsUrlValue = instance.downloadsUrl();
        if (downloadsUrlValue != null) {
          downloadsUrl(downloadsUrlValue);
        }
        @Nullable String contentsUrlValue = instance.contentsUrl();
        if (contentsUrlValue != null) {
          contentsUrl(contentsUrlValue);
        }
        @Nullable GitHubInstant pushedAtValue = instance.pushedAt();
        if (pushedAtValue != null) {
          pushedAt(pushedAtValue);
        }
        @Nullable URI tagsUrlValue = instance.tagsUrl();
        if (tagsUrlValue != null) {
          tagsUrl(tagsUrlValue);
        }
        @Nullable String commentsUrlValue = instance.commentsUrl();
        if (commentsUrlValue != null) {
          commentsUrl(commentsUrlValue);
        }
        @Nullable Integer sizeValue = instance.size();
        if (sizeValue != null) {
          size(sizeValue);
        }
        @Nullable Boolean allowRebaseMergeValue = instance.allowRebaseMerge();
        if (allowRebaseMergeValue != null) {
          allowRebaseMerge(allowRebaseMergeValue);
        }
        @Nullable String treesUrlValue = instance.treesUrl();
        if (treesUrlValue != null) {
          treesUrl(treesUrlValue);
        }
        @Nullable String nameValue = instance.name();
        if (nameValue != null) {
          name(nameValue);
        }
        @Nullable URI mergesUrlValue = instance.mergesUrl();
        if (mergesUrlValue != null) {
          mergesUrl(mergesUrlValue);
        }
        @Nullable String teamsUrlValue = instance.teamsUrl();
        if (teamsUrlValue != null) {
          teamsUrl(teamsUrlValue);
        }
        @Nullable String blobsUrlValue = instance.blobsUrl();
        if (blobsUrlValue != null) {
          blobsUrl(blobsUrlValue);
        }
        @Nullable Boolean hasPagesValue = instance.hasPages();
        if (hasPagesValue != null) {
          hasPages(hasPagesValue);
        }
        @Nullable String issueEventsUrlValue = instance.issueEventsUrl();
        if (issueEventsUrlValue != null) {
          issueEventsUrl(issueEventsUrlValue);
        }
        @Nullable String milestonesUrlValue = instance.milestonesUrl();
        if (milestonesUrlValue != null) {
          milestonesUrl(milestonesUrlValue);
        }
        @Nullable String issuesUrlValue = instance.issuesUrl();
        if (issuesUrlValue != null) {
          issuesUrl(issuesUrlValue);
        }
        @Nullable Boolean isArchivedValue = instance.isArchived();
        if (isArchivedValue != null) {
          isArchived(isArchivedValue);
        }
        @Nullable String releasesUrlValue = instance.releasesUrl();
        if (releasesUrlValue != null) {
          releasesUrl(releasesUrlValue);
        }
        Optional<String> descriptionOptional = instance.description();
        if (descriptionOptional.isPresent()) {
          description(descriptionOptional);
        }
        Optional<Integer> watchersOptional = instance.watchers();
        if (watchersOptional.isPresent()) {
          watchers(watchersOptional);
        }
        @Nullable String branchesUrlValue = instance.branchesUrl();
        if (branchesUrlValue != null) {
          branchesUrl(branchesUrlValue);
        }
        @Nullable Boolean isPrivateValue = instance.isPrivate();
        if (isPrivateValue != null) {
          isPrivate(isPrivateValue);
        }
        @Nullable URI contributorsUrlValue = instance.contributorsUrl();
        if (contributorsUrlValue != null) {
          contributorsUrl(contributorsUrlValue);
        }
        @Nullable String gitRefsUrlValue = instance.gitRefsUrl();
        if (gitRefsUrlValue != null) {
          gitRefsUrl(gitRefsUrlValue);
        }
        @Nullable URI hooksUrlValue = instance.hooksUrl();
        if (hooksUrlValue != null) {
          hooksUrl(hooksUrlValue);
        }
        @Nullable Integer openIssuesCountValue = instance.openIssuesCount();
        if (openIssuesCountValue != null) {
          openIssuesCount(openIssuesCountValue);
        }
        @Nullable Integer stargazersCountValue = instance.stargazersCount();
        if (stargazersCountValue != null) {
          stargazersCount(stargazersCountValue);
        }
        Optional<Boolean> isPublicOptional = instance.isPublic();
        if (isPublicOptional.isPresent()) {
          isPublic(isPublicOptional);
        }
        @Nullable Boolean hasIssuesValue = instance.hasIssues();
        if (hasIssuesValue != null) {
          hasIssues(hasIssuesValue);
        }
        @Nullable Boolean hasWikiValue = instance.hasWiki();
        if (hasWikiValue != null) {
          hasWiki(hasWikiValue);
        }
        @Nullable String compareUrlValue = instance.compareUrl();
        if (compareUrlValue != null) {
          compareUrl(compareUrlValue);
        }
        @Nullable String gitCommitsUrlValue = instance.gitCommitsUrl();
        if (gitCommitsUrlValue != null) {
          gitCommitsUrl(gitCommitsUrlValue);
        }
        @Nullable URI htmlUrlValue = instance.htmlUrl();
        if (htmlUrlValue != null) {
          htmlUrl(htmlUrlValue);
        }
        @Nullable URI stargazersUrlValue = instance.stargazersUrl();
        if (stargazersUrlValue != null) {
          stargazersUrl(stargazersUrlValue);
        }
        @Nullable String fullNameValue = instance.fullName();
        if (fullNameValue != null) {
          fullName(fullNameValue);
        }
        @Nullable URI svnUrlValue = instance.svnUrl();
        if (svnUrlValue != null) {
          svnUrl(svnUrlValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        Optional<URI> mirrorUrlOptional = instance.mirrorUrl();
        if (mirrorUrlOptional.isPresent()) {
          mirrorUrl(mirrorUrlOptional);
        }
        @Nullable String pullsUrlValue = instance.pullsUrl();
        if (pullsUrlValue != null) {
          pullsUrl(pullsUrlValue);
        }
        @Nullable Boolean hasDownloadsValue = instance.hasDownloads();
        if (hasDownloadsValue != null) {
          hasDownloads(hasDownloadsValue);
        }
        @Nullable Boolean forkValue = instance.fork();
        if (forkValue != null) {
          fork(forkValue);
        }
        Optional<Integer> stargazersOptional = instance.stargazers();
        if (stargazersOptional.isPresent()) {
          stargazers(stargazersOptional);
        }
        @Nullable Boolean allowSquashMergeValue = instance.allowSquashMerge();
        if (allowSquashMergeValue != null) {
          allowSquashMerge(allowSquashMergeValue);
        }
        Optional<URI> deploymentsUrlOptional = instance.deploymentsUrl();
        if (deploymentsUrlOptional.isPresent()) {
          deploymentsUrl(deploymentsUrlOptional);
        }
        @Nullable URI eventsUrlValue = instance.eventsUrl();
        if (eventsUrlValue != null) {
          eventsUrl(eventsUrlValue);
        }
        @Nullable String gitTagsUrlValue = instance.gitTagsUrl();
        if (gitTagsUrlValue != null) {
          gitTagsUrl(gitTagsUrlValue);
        }
        @Nullable String notificationsUrlValue = instance.notificationsUrl();
        if (notificationsUrlValue != null) {
          notificationsUrl(notificationsUrlValue);
        }
        @Nullable URI gitUrlValue = instance.gitUrl();
        if (gitUrlValue != null) {
          gitUrl(gitUrlValue);
        }
        Optional<String> homepageOptional = instance.homepage();
        if (homepageOptional.isPresent()) {
          homepage(homepageOptional);
        }
        @Nullable URI subscriptionUrlValue = instance.subscriptionUrl();
        if (subscriptionUrlValue != null) {
          subscriptionUrl(subscriptionUrlValue);
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        @Nullable GitHubInstant createdAtValue = instance.createdAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link RepositoryBase#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#fullName() fullName} attribute.
     * @param fullName The value for fullName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder fullName(@Nullable String fullName) {
      this.fullName = fullName;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#isPrivate() isPrivate} attribute.
     * @param isPrivate The value for isPrivate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("private")
    public final Builder isPrivate(@Nullable Boolean isPrivate) {
      this.isPrivate = isPrivate;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#isArchived() isArchived} attribute.
     * @param isArchived The value for isArchived (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("archived")
    public final Builder isArchived(@Nullable Boolean isArchived) {
      this.isArchived = isArchived;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#isPublic() isPublic} to isPublic.
     * @param isPublic The value for isPublic
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isPublic(boolean isPublic) {
      this.isPublic = isPublic;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#isPublic() isPublic} to isPublic.
     * @param isPublic The value for isPublic
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("public")
    public final Builder isPublic(Optional<Boolean> isPublic) {
      this.isPublic = isPublic.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#fork() fork} attribute.
     * @param fork The value for fork (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder fork(@Nullable Boolean fork) {
      this.fork = fork;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#allowSquashMerge() allowSquashMerge} attribute.
     * @param allowSquashMerge The value for allowSquashMerge (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder allowSquashMerge(@Nullable Boolean allowSquashMerge) {
      this.allowSquashMerge = allowSquashMerge;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#allowMergeCommit() allowMergeCommit} attribute.
     * @param allowMergeCommit The value for allowMergeCommit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder allowMergeCommit(@Nullable Boolean allowMergeCommit) {
      this.allowMergeCommit = allowMergeCommit;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#allowRebaseMerge() allowRebaseMerge} attribute.
     * @param allowRebaseMerge The value for allowRebaseMerge (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder allowRebaseMerge(@Nullable Boolean allowRebaseMerge) {
      this.allowRebaseMerge = allowRebaseMerge;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#archiveUrl() archiveUrl} attribute.
     * @param archiveUrl The value for archiveUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder archiveUrl(@Nullable String archiveUrl) {
      this.archiveUrl = archiveUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#assigneesUrl() assigneesUrl} attribute.
     * @param assigneesUrl The value for assigneesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder assigneesUrl(@Nullable String assigneesUrl) {
      this.assigneesUrl = assigneesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#blobsUrl() blobsUrl} attribute.
     * @param blobsUrl The value for blobsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder blobsUrl(@Nullable String blobsUrl) {
      this.blobsUrl = blobsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#branchesUrl() branchesUrl} attribute.
     * @param branchesUrl The value for branchesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder branchesUrl(@Nullable String branchesUrl) {
      this.branchesUrl = branchesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#cloneUrl() cloneUrl} attribute.
     * @param cloneUrl The value for cloneUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder cloneUrl(@Nullable URI cloneUrl) {
      this.cloneUrl = cloneUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#collaboratorsUrl() collaboratorsUrl} attribute.
     * @param collaboratorsUrl The value for collaboratorsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder collaboratorsUrl(@Nullable String collaboratorsUrl) {
      this.collaboratorsUrl = collaboratorsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#commentsUrl() commentsUrl} attribute.
     * @param commentsUrl The value for commentsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commentsUrl(@Nullable String commentsUrl) {
      this.commentsUrl = commentsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#commitsUrl() commitsUrl} attribute.
     * @param commitsUrl The value for commitsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitsUrl(@Nullable String commitsUrl) {
      this.commitsUrl = commitsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#compareUrl() compareUrl} attribute.
     * @param compareUrl The value for compareUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder compareUrl(@Nullable String compareUrl) {
      this.compareUrl = compareUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#contentsUrl() contentsUrl} attribute.
     * @param contentsUrl The value for contentsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder contentsUrl(@Nullable String contentsUrl) {
      this.contentsUrl = contentsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#contributorsUrl() contributorsUrl} attribute.
     * @param contributorsUrl The value for contributorsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder contributorsUrl(@Nullable URI contributorsUrl) {
      this.contributorsUrl = contributorsUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#deploymentsUrl() deploymentsUrl} to deploymentsUrl.
     * @param deploymentsUrl The value for deploymentsUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deploymentsUrl(URI deploymentsUrl) {
      this.deploymentsUrl = Objects.requireNonNull(deploymentsUrl, "deploymentsUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#deploymentsUrl() deploymentsUrl} to deploymentsUrl.
     * @param deploymentsUrl The value for deploymentsUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder deploymentsUrl(Optional<? extends URI> deploymentsUrl) {
      this.deploymentsUrl = deploymentsUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#downloadsUrl() downloadsUrl} attribute.
     * @param downloadsUrl The value for downloadsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder downloadsUrl(@Nullable URI downloadsUrl) {
      this.downloadsUrl = downloadsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#eventsUrl() eventsUrl} attribute.
     * @param eventsUrl The value for eventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder eventsUrl(@Nullable URI eventsUrl) {
      this.eventsUrl = eventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#forksUrl() forksUrl} attribute.
     * @param forksUrl The value for forksUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder forksUrl(@Nullable URI forksUrl) {
      this.forksUrl = forksUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#gitCommitsUrl() gitCommitsUrl} attribute.
     * @param gitCommitsUrl The value for gitCommitsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder gitCommitsUrl(@Nullable String gitCommitsUrl) {
      this.gitCommitsUrl = gitCommitsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#gitRefsUrl() gitRefsUrl} attribute.
     * @param gitRefsUrl The value for gitRefsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder gitRefsUrl(@Nullable String gitRefsUrl) {
      this.gitRefsUrl = gitRefsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#gitTagsUrl() gitTagsUrl} attribute.
     * @param gitTagsUrl The value for gitTagsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder gitTagsUrl(@Nullable String gitTagsUrl) {
      this.gitTagsUrl = gitTagsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#gitUrl() gitUrl} attribute.
     * @param gitUrl The value for gitUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder gitUrl(@Nullable URI gitUrl) {
      this.gitUrl = gitUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#hooksUrl() hooksUrl} attribute.
     * @param hooksUrl The value for hooksUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder hooksUrl(@Nullable URI hooksUrl) {
      this.hooksUrl = hooksUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#homepage() homepage} to homepage.
     * @param homepage The value for homepage
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder homepage(String homepage) {
      this.homepage = Objects.requireNonNull(homepage, "homepage");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#homepage() homepage} to homepage.
     * @param homepage The value for homepage
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder homepage(Optional<String> homepage) {
      this.homepage = homepage.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#language() language} to language.
     * @param language The value for language
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder language(String language) {
      this.language = Objects.requireNonNull(language, "language");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#language() language} to language.
     * @param language The value for language
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder language(Optional<String> language) {
      this.language = language.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#forksCount() forksCount} attribute.
     * @param forksCount The value for forksCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder forksCount(@Nullable Integer forksCount) {
      this.forksCount = forksCount;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#stargazersCount() stargazersCount} attribute.
     * @param stargazersCount The value for stargazersCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder stargazersCount(@Nullable Integer stargazersCount) {
      this.stargazersCount = stargazersCount;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#watchersCount() watchersCount} attribute.
     * @param watchersCount The value for watchersCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder watchersCount(@Nullable Integer watchersCount) {
      this.watchersCount = watchersCount;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#size() size} attribute.
     * @param size The value for size (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder size(@Nullable Integer size) {
      this.size = size;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#defaultBranch() defaultBranch} attribute.
     * @param defaultBranch The value for defaultBranch (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder defaultBranch(@Nullable String defaultBranch) {
      this.defaultBranch = defaultBranch;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#openIssuesCount() openIssuesCount} attribute.
     * @param openIssuesCount The value for openIssuesCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder openIssuesCount(@Nullable Integer openIssuesCount) {
      this.openIssuesCount = openIssuesCount;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#hasIssues() hasIssues} attribute.
     * @param hasIssues The value for hasIssues (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder hasIssues(@Nullable Boolean hasIssues) {
      this.hasIssues = hasIssues;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#hasWiki() hasWiki} attribute.
     * @param hasWiki The value for hasWiki (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder hasWiki(@Nullable Boolean hasWiki) {
      this.hasWiki = hasWiki;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#hasPages() hasPages} attribute.
     * @param hasPages The value for hasPages (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder hasPages(@Nullable Boolean hasPages) {
      this.hasPages = hasPages;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#hasDownloads() hasDownloads} attribute.
     * @param hasDownloads The value for hasDownloads (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder hasDownloads(@Nullable Boolean hasDownloads) {
      this.hasDownloads = hasDownloads;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#permissions() permissions} to permissions.
     * @param permissions The value for permissions
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder permissions(Permissions permissions) {
      this.permissions = Objects.requireNonNull(permissions, "permissions");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#permissions() permissions} to permissions.
     * @param permissions The value for permissions
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder permissions(Optional<? extends Permissions> permissions) {
      this.permissions = permissions.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#forks() forks} attribute.
     * @param forks The value for forks (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    @Deprecated
    public final Builder forks(@Nullable Integer forks) {
      this.forks = forks;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#pushedAt() pushedAt} attribute.
     * @param pushedAt The value for pushedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pushedAt(@Nullable GitHubInstant pushedAt) {
      this.pushedAt = pushedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#issuesUrl() issuesUrl} attribute.
     * @param issuesUrl The value for issuesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder issuesUrl(@Nullable String issuesUrl) {
      this.issuesUrl = issuesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#issueCommentUrl() issueCommentUrl} attribute.
     * @param issueCommentUrl The value for issueCommentUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder issueCommentUrl(@Nullable String issueCommentUrl) {
      this.issueCommentUrl = issueCommentUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#issueEventsUrl() issueEventsUrl} attribute.
     * @param issueEventsUrl The value for issueEventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder issueEventsUrl(@Nullable String issueEventsUrl) {
      this.issueEventsUrl = issueEventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#keysUrl() keysUrl} attribute.
     * @param keysUrl The value for keysUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder keysUrl(@Nullable String keysUrl) {
      this.keysUrl = keysUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#labelsUrl() labelsUrl} attribute.
     * @param labelsUrl The value for labelsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder labelsUrl(@Nullable String labelsUrl) {
      this.labelsUrl = labelsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#languagesUrl() languagesUrl} attribute.
     * @param languagesUrl The value for languagesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder languagesUrl(@Nullable URI languagesUrl) {
      this.languagesUrl = languagesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#mergesUrl() mergesUrl} attribute.
     * @param mergesUrl The value for mergesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergesUrl(@Nullable URI mergesUrl) {
      this.mergesUrl = mergesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#milestonesUrl() milestonesUrl} attribute.
     * @param milestonesUrl The value for milestonesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder milestonesUrl(@Nullable String milestonesUrl) {
      this.milestonesUrl = milestonesUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#mirrorUrl() mirrorUrl} to mirrorUrl.
     * @param mirrorUrl The value for mirrorUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mirrorUrl(URI mirrorUrl) {
      this.mirrorUrl = Objects.requireNonNull(mirrorUrl, "mirrorUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#mirrorUrl() mirrorUrl} to mirrorUrl.
     * @param mirrorUrl The value for mirrorUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mirrorUrl(Optional<? extends URI> mirrorUrl) {
      this.mirrorUrl = mirrorUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#notificationsUrl() notificationsUrl} attribute.
     * @param notificationsUrl The value for notificationsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder notificationsUrl(@Nullable String notificationsUrl) {
      this.notificationsUrl = notificationsUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#openIssues() openIssues} to openIssues.
     * @param openIssues The value for openIssues
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder openIssues(int openIssues) {
      this.openIssues = openIssues;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#openIssues() openIssues} to openIssues.
     * @param openIssues The value for openIssues
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    @Deprecated
    public final Builder openIssues(Optional<Integer> openIssues) {
      this.openIssues = openIssues.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#pullsUrl() pullsUrl} attribute.
     * @param pullsUrl The value for pullsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pullsUrl(@Nullable String pullsUrl) {
      this.pullsUrl = pullsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#releasesUrl() releasesUrl} attribute.
     * @param releasesUrl The value for releasesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder releasesUrl(@Nullable String releasesUrl) {
      this.releasesUrl = releasesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#sshUrl() sshUrl} attribute.
     * @param sshUrl The value for sshUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sshUrl(@Nullable String sshUrl) {
      this.sshUrl = sshUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#stargazersUrl() stargazersUrl} attribute.
     * @param stargazersUrl The value for stargazersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder stargazersUrl(@Nullable URI stargazersUrl) {
      this.stargazersUrl = stargazersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#statusesUrl() statusesUrl} attribute.
     * @param statusesUrl The value for statusesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder statusesUrl(@Nullable String statusesUrl) {
      this.statusesUrl = statusesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#subscribersUrl() subscribersUrl} attribute.
     * @param subscribersUrl The value for subscribersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder subscribersUrl(@Nullable URI subscribersUrl) {
      this.subscribersUrl = subscribersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#subscriptionUrl() subscriptionUrl} attribute.
     * @param subscriptionUrl The value for subscriptionUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder subscriptionUrl(@Nullable URI subscriptionUrl) {
      this.subscriptionUrl = subscriptionUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#svnUrl() svnUrl} attribute.
     * @param svnUrl The value for svnUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder svnUrl(@Nullable URI svnUrl) {
      this.svnUrl = svnUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#tagsUrl() tagsUrl} attribute.
     * @param tagsUrl The value for tagsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder tagsUrl(@Nullable URI tagsUrl) {
      this.tagsUrl = tagsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#treesUrl() treesUrl} attribute.
     * @param treesUrl The value for treesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder treesUrl(@Nullable String treesUrl) {
      this.treesUrl = treesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryBase#teamsUrl() teamsUrl} attribute.
     * @param teamsUrl The value for teamsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder teamsUrl(@Nullable String teamsUrl) {
      this.teamsUrl = teamsUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#watchers() watchers} to watchers.
     * @param watchers The value for watchers
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder watchers(int watchers) {
      this.watchers = watchers;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#watchers() watchers} to watchers.
     * @param watchers The value for watchers
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    @Deprecated
    public final Builder watchers(Optional<Integer> watchers) {
      this.watchers = watchers.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#stargazers() stargazers} to stargazers.
     * @param stargazers The value for stargazers
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder stargazers(int stargazers) {
      this.stargazers = stargazers;
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#stargazers() stargazers} to stargazers.
     * @param stargazers The value for stargazers
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    @Deprecated
    public final Builder stargazers(Optional<Integer> stargazers) {
      this.stargazers = stargazers.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#masterBranch() masterBranch} to masterBranch.
     * @param masterBranch The value for masterBranch
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder masterBranch(String masterBranch) {
      this.masterBranch = Objects.requireNonNull(masterBranch, "masterBranch");
      return this;
    }

    /**
     * Initializes the optional value {@link RepositoryBase#masterBranch() masterBranch} to masterBranch.
     * @param masterBranch The value for masterBranch
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    @Deprecated
    public final Builder masterBranch(Optional<String> masterBranch) {
      this.masterBranch = masterBranch.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepositoryBase ImmutableRepositoryBase}.
     * @return An immutable instance of RepositoryBase
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepositoryBase build() {
      return new ImmutableRepositoryBase(
          createdAt,
          updatedAt,
          id,
          name,
          fullName,
          description,
          isPrivate,
          isArchived,
          isPublic,
          fork,
          url,
          htmlUrl,
          allowSquashMerge,
          allowMergeCommit,
          allowRebaseMerge,
          archiveUrl,
          assigneesUrl,
          blobsUrl,
          branchesUrl,
          cloneUrl,
          collaboratorsUrl,
          commentsUrl,
          commitsUrl,
          compareUrl,
          contentsUrl,
          contributorsUrl,
          deploymentsUrl,
          downloadsUrl,
          eventsUrl,
          forksUrl,
          gitCommitsUrl,
          gitRefsUrl,
          gitTagsUrl,
          gitUrl,
          hooksUrl,
          homepage,
          language,
          forksCount,
          stargazersCount,
          watchersCount,
          size,
          defaultBranch,
          openIssuesCount,
          hasIssues,
          hasWiki,
          hasPages,
          hasDownloads,
          permissions,
          forks,
          pushedAt,
          issuesUrl,
          issueCommentUrl,
          issueEventsUrl,
          keysUrl,
          labelsUrl,
          languagesUrl,
          mergesUrl,
          milestonesUrl,
          mirrorUrl,
          notificationsUrl,
          openIssues,
          pullsUrl,
          releasesUrl,
          sshUrl,
          stargazersUrl,
          statusesUrl,
          subscribersUrl,
          subscriptionUrl,
          svnUrl,
          tagsUrl,
          treesUrl,
          teamsUrl,
          watchers,
          stargazers,
          masterBranch);
    }
  }
}
