package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepositoryInvitation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepositoryInvitation.builder()}.
 */
@Generated(from = "RepositoryInvitation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepositoryInvitation implements RepositoryInvitation {
  private final Integer id;
  private final String nodeId;
  private final Repository repository;
  private final @Nullable User invitee;
  private final @Nullable User inviter;
  private final String permissions;
  private final ZonedDateTime createdAt;
  private final @Nullable Optional<Boolean> expired;
  private final URI url;
  private final URI htmlUrl;

  private ImmutableRepositoryInvitation(
      Integer id,
      String nodeId,
      Repository repository,
      @Nullable User invitee,
      @Nullable User inviter,
      String permissions,
      ZonedDateTime createdAt,
      @Nullable Optional<Boolean> expired,
      URI url,
      URI htmlUrl) {
    this.id = id;
    this.nodeId = nodeId;
    this.repository = repository;
    this.invitee = invitee;
    this.inviter = inviter;
    this.permissions = permissions;
    this.createdAt = createdAt;
    this.expired = expired;
    this.url = url;
    this.htmlUrl = htmlUrl;
  }

  /**
   *Unique identifier of the repository invitation 
   */
  @JsonProperty
  @Override
  public Integer id() {
    return id;
  }

  /**
   *Node ID 
   */
  @JsonProperty
  @Override
  public String nodeId() {
    return nodeId;
  }

  /**
   *The repository that the invitee is being invited to 
   */
  @JsonProperty
  @Override
  public Repository repository() {
    return repository;
  }

  /**
   *The user that is receiving the invite 
   */
  @JsonProperty
  @Override
  public @Nullable User invitee() {
    return invitee;
  }

  /**
   *The user that sent the invite 
   */
  @JsonProperty
  @Override
  public @Nullable User inviter() {
    return inviter;
  }

  /**
   *The permission associated with the invitation 
   */
  @JsonProperty
  @Override
  public String permissions() {
    return permissions;
  }

  /**
   *Date when invite was created 
   */
  @JsonProperty
  @Override
  public ZonedDateTime createdAt() {
    return createdAt;
  }

  /**
   *Whether or not the invitation has expired 
   */
  @JsonProperty
  @Override
  public @Nullable Optional<Boolean> expired() {
    return expired;
  }

  /**
   *API URL 
   */
  @JsonProperty
  @Override
  public URI url() {
    return url;
  }

  /**
   *HTML URL 
   */
  @JsonProperty
  @Override
  public URI htmlUrl() {
    return htmlUrl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryInvitation#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryInvitation withId(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableRepositoryInvitation(
        newValue,
        this.nodeId,
        this.repository,
        this.invitee,
        this.inviter,
        this.permissions,
        this.createdAt,
        this.expired,
        this.url,
        this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryInvitation#nodeId() nodeId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryInvitation withNodeId(String value) {
    String newValue = Objects.requireNonNull(value, "nodeId");
    if (this.nodeId.equals(newValue)) return this;
    return new ImmutableRepositoryInvitation(
        this.id,
        newValue,
        this.repository,
        this.invitee,
        this.inviter,
        this.permissions,
        this.createdAt,
        this.expired,
        this.url,
        this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryInvitation#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryInvitation withRepository(Repository value) {
    if (this.repository == value) return this;
    Repository newValue = Objects.requireNonNull(value, "repository");
    return new ImmutableRepositoryInvitation(
        this.id,
        this.nodeId,
        newValue,
        this.invitee,
        this.inviter,
        this.permissions,
        this.createdAt,
        this.expired,
        this.url,
        this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryInvitation#invitee() invitee} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for invitee (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryInvitation withInvitee(@Nullable User value) {
    if (this.invitee == value) return this;
    return new ImmutableRepositoryInvitation(
        this.id,
        this.nodeId,
        this.repository,
        value,
        this.inviter,
        this.permissions,
        this.createdAt,
        this.expired,
        this.url,
        this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryInvitation#inviter() inviter} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inviter (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryInvitation withInviter(@Nullable User value) {
    if (this.inviter == value) return this;
    return new ImmutableRepositoryInvitation(
        this.id,
        this.nodeId,
        this.repository,
        this.invitee,
        value,
        this.permissions,
        this.createdAt,
        this.expired,
        this.url,
        this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryInvitation#permissions() permissions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for permissions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryInvitation withPermissions(String value) {
    String newValue = Objects.requireNonNull(value, "permissions");
    if (this.permissions.equals(newValue)) return this;
    return new ImmutableRepositoryInvitation(
        this.id,
        this.nodeId,
        this.repository,
        this.invitee,
        this.inviter,
        newValue,
        this.createdAt,
        this.expired,
        this.url,
        this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryInvitation#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryInvitation withCreatedAt(ZonedDateTime value) {
    if (this.createdAt == value) return this;
    ZonedDateTime newValue = Objects.requireNonNull(value, "createdAt");
    return new ImmutableRepositoryInvitation(
        this.id,
        this.nodeId,
        this.repository,
        this.invitee,
        this.inviter,
        this.permissions,
        newValue,
        this.expired,
        this.url,
        this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryInvitation#expired() expired} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expired (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryInvitation withExpired(@Nullable Optional<Boolean> value) {
    if (Objects.equals(this.expired, value)) return this;
    return new ImmutableRepositoryInvitation(
        this.id,
        this.nodeId,
        this.repository,
        this.invitee,
        this.inviter,
        this.permissions,
        this.createdAt,
        value,
        this.url,
        this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryInvitation#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryInvitation withUrl(URI value) {
    if (this.url == value) return this;
    URI newValue = Objects.requireNonNull(value, "url");
    return new ImmutableRepositoryInvitation(
        this.id,
        this.nodeId,
        this.repository,
        this.invitee,
        this.inviter,
        this.permissions,
        this.createdAt,
        this.expired,
        newValue,
        this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryInvitation#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryInvitation withHtmlUrl(URI value) {
    if (this.htmlUrl == value) return this;
    URI newValue = Objects.requireNonNull(value, "htmlUrl");
    return new ImmutableRepositoryInvitation(
        this.id,
        this.nodeId,
        this.repository,
        this.invitee,
        this.inviter,
        this.permissions,
        this.createdAt,
        this.expired,
        this.url,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepositoryInvitation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepositoryInvitation
        && equalTo((ImmutableRepositoryInvitation) another);
  }

  private boolean equalTo(ImmutableRepositoryInvitation another) {
    return id.equals(another.id)
        && nodeId.equals(another.nodeId)
        && repository.equals(another.repository)
        && Objects.equals(invitee, another.invitee)
        && Objects.equals(inviter, another.inviter)
        && permissions.equals(another.permissions)
        && createdAt.equals(another.createdAt)
        && Objects.equals(expired, another.expired)
        && url.equals(another.url)
        && htmlUrl.equals(another.htmlUrl);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code nodeId}, {@code repository}, {@code invitee}, {@code inviter}, {@code permissions}, {@code createdAt}, {@code expired}, {@code url}, {@code htmlUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + nodeId.hashCode();
    h += (h << 5) + repository.hashCode();
    h += (h << 5) + Objects.hashCode(invitee);
    h += (h << 5) + Objects.hashCode(inviter);
    h += (h << 5) + permissions.hashCode();
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + Objects.hashCode(expired);
    h += (h << 5) + url.hashCode();
    h += (h << 5) + htmlUrl.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RepositoryInvitation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RepositoryInvitation{"
        + "id=" + id
        + ", nodeId=" + nodeId
        + ", repository=" + repository
        + ", invitee=" + invitee
        + ", inviter=" + inviter
        + ", permissions=" + permissions
        + ", createdAt=" + createdAt
        + ", expired=" + expired
        + ", url=" + url
        + ", htmlUrl=" + htmlUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RepositoryInvitation", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RepositoryInvitation {
    @Nullable Integer id;
    @Nullable String nodeId;
    @Nullable Repository repository;
    @Nullable User invitee;
    @Nullable User inviter;
    @Nullable String permissions;
    @Nullable ZonedDateTime createdAt;
    @Nullable Optional<Boolean> expired;
    @Nullable URI url;
    @Nullable URI htmlUrl;
    @JsonProperty
    public void setId(Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setNodeId(String nodeId) {
      this.nodeId = nodeId;
    }
    @JsonProperty
    public void setRepository(Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setInvitee(@Nullable User invitee) {
      this.invitee = invitee;
    }
    @JsonProperty
    public void setInviter(@Nullable User inviter) {
      this.inviter = inviter;
    }
    @JsonProperty
    public void setPermissions(String permissions) {
      this.permissions = permissions;
    }
    @JsonProperty
    public void setCreatedAt(ZonedDateTime createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setExpired(@Nullable Optional<Boolean> expired) {
      this.expired = expired;
    }
    @JsonProperty
    public void setUrl(URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setHtmlUrl(URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public String nodeId() { throw new UnsupportedOperationException(); }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User invitee() { throw new UnsupportedOperationException(); }
    @Override
    public User inviter() { throw new UnsupportedOperationException(); }
    @Override
    public String permissions() { throw new UnsupportedOperationException(); }
    @Override
    public ZonedDateTime createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> expired() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRepositoryInvitation fromJson(Json json) {
    ImmutableRepositoryInvitation.Builder builder = ImmutableRepositoryInvitation.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.nodeId != null) {
      builder.nodeId(json.nodeId);
    }
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.invitee != null) {
      builder.invitee(json.invitee);
    }
    if (json.inviter != null) {
      builder.inviter(json.inviter);
    }
    if (json.permissions != null) {
      builder.permissions(json.permissions);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.expired != null) {
      builder.expired(json.expired);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RepositoryInvitation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepositoryInvitation instance
   */
  public static ImmutableRepositoryInvitation copyOf(RepositoryInvitation instance) {
    if (instance instanceof ImmutableRepositoryInvitation) {
      return (ImmutableRepositoryInvitation) instance;
    }
    return ImmutableRepositoryInvitation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepositoryInvitation ImmutableRepositoryInvitation}.
   * <pre>
   * ImmutableRepositoryInvitation.builder()
   *    .id(Integer) // required {@link RepositoryInvitation#id() id}
   *    .nodeId(String) // required {@link RepositoryInvitation#nodeId() nodeId}
   *    .repository(com.spotify.github.v3.repos.Repository) // required {@link RepositoryInvitation#repository() repository}
   *    .invitee(com.spotify.github.v3.User | null) // nullable {@link RepositoryInvitation#invitee() invitee}
   *    .inviter(com.spotify.github.v3.User | null) // nullable {@link RepositoryInvitation#inviter() inviter}
   *    .permissions(String) // required {@link RepositoryInvitation#permissions() permissions}
   *    .createdAt(java.time.ZonedDateTime) // required {@link RepositoryInvitation#createdAt() createdAt}
   *    .expired(Optional&amp;lt;Boolean&amp;gt; | null) // nullable {@link RepositoryInvitation#expired() expired}
   *    .url(java.net.URI) // required {@link RepositoryInvitation#url() url}
   *    .htmlUrl(java.net.URI) // required {@link RepositoryInvitation#htmlUrl() htmlUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableRepositoryInvitation builder
   */
  public static ImmutableRepositoryInvitation.Builder builder() {
    return new ImmutableRepositoryInvitation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepositoryInvitation ImmutableRepositoryInvitation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepositoryInvitation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NODE_ID = 0x2L;
    private static final long INIT_BIT_REPOSITORY = 0x4L;
    private static final long INIT_BIT_PERMISSIONS = 0x8L;
    private static final long INIT_BIT_CREATED_AT = 0x10L;
    private static final long INIT_BIT_URL = 0x20L;
    private static final long INIT_BIT_HTML_URL = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable Integer id;
    private @Nullable String nodeId;
    private @Nullable Repository repository;
    private @Nullable User invitee;
    private @Nullable User inviter;
    private @Nullable String permissions;
    private @Nullable ZonedDateTime createdAt;
    private @Nullable Optional<Boolean> expired;
    private @Nullable URI url;
    private @Nullable URI htmlUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RepositoryInvitation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepositoryInvitation instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      nodeId(instance.nodeId());
      repository(instance.repository());
      @Nullable User inviteeValue = instance.invitee();
      if (inviteeValue != null) {
        invitee(inviteeValue);
      }
      @Nullable User inviterValue = instance.inviter();
      if (inviterValue != null) {
        inviter(inviterValue);
      }
      permissions(instance.permissions());
      createdAt(instance.createdAt());
      @Nullable Optional<Boolean> expiredValue = instance.expired();
      if (expiredValue != null) {
        expired(expiredValue);
      }
      url(instance.url());
      htmlUrl(instance.htmlUrl());
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryInvitation#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(Integer id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryInvitation#nodeId() nodeId} attribute.
     * @param nodeId The value for nodeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder nodeId(String nodeId) {
      this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
      initBits &= ~INIT_BIT_NODE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryInvitation#repository() repository} attribute.
     * @param repository The value for repository 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(Repository repository) {
      this.repository = Objects.requireNonNull(repository, "repository");
      initBits &= ~INIT_BIT_REPOSITORY;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryInvitation#invitee() invitee} attribute.
     * @param invitee The value for invitee (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder invitee(@Nullable User invitee) {
      this.invitee = invitee;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryInvitation#inviter() inviter} attribute.
     * @param inviter The value for inviter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder inviter(@Nullable User inviter) {
      this.inviter = inviter;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryInvitation#permissions() permissions} attribute.
     * @param permissions The value for permissions 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder permissions(String permissions) {
      this.permissions = Objects.requireNonNull(permissions, "permissions");
      initBits &= ~INIT_BIT_PERMISSIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryInvitation#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(ZonedDateTime createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryInvitation#expired() expired} attribute.
     * @param expired The value for expired (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder expired(@Nullable Optional<Boolean> expired) {
      this.expired = expired;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryInvitation#url() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(URI url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryInvitation#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(URI htmlUrl) {
      this.htmlUrl = Objects.requireNonNull(htmlUrl, "htmlUrl");
      initBits &= ~INIT_BIT_HTML_URL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepositoryInvitation ImmutableRepositoryInvitation}.
     * @return An immutable instance of RepositoryInvitation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepositoryInvitation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRepositoryInvitation(id, nodeId, repository, invitee, inviter, permissions, createdAt, expired, url, htmlUrl);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NODE_ID) != 0) attributes.add("nodeId");
      if ((initBits & INIT_BIT_REPOSITORY) != 0) attributes.add("repository");
      if ((initBits & INIT_BIT_PERMISSIONS) != 0) attributes.add("permissions");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      if ((initBits & INIT_BIT_HTML_URL) != 0) attributes.add("htmlUrl");
      return "Cannot build RepositoryInvitation, some of required attributes are not set " + attributes;
    }
  }
}
