package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepositoryCreateStatus}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepositoryCreateStatus.builder()}.
 */
@Generated(from = "RepositoryCreateStatus", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepositoryCreateStatus
    implements RepositoryCreateStatus {
  private final @Nullable String state;
  private final @Nullable URI targetUrl;
  private final @Nullable String description;
  private final @Nullable String context;

  private ImmutableRepositoryCreateStatus(
      @Nullable String state,
      @Nullable URI targetUrl,
      @Nullable String description,
      @Nullable String context) {
    this.state = state;
    this.targetUrl = targetUrl;
    this.description = description;
    this.context = context;
  }

  /**
   *The state of the status. Can be one of pending, success, error, or failure. 
   */
  @JsonProperty
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   *The target URL to associate with this status. 
   */
  @JsonProperty
  @Override
  public @Nullable URI targetUrl() {
    return targetUrl;
  }

  /**
   *A short description of the status. Must be less than 1024 bytes. 
   */
  @JsonProperty
  @Override
  public @Nullable String description() {
    return description;
  }

  /**
   * A string label to differentiate this status from the status of other systems. Default:
   * "default"
   */
  @JsonProperty
  @Override
  public @Nullable String context() {
    return context;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryCreateStatus#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryCreateStatus withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableRepositoryCreateStatus(value, this.targetUrl, this.description, this.context);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryCreateStatus#targetUrl() targetUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryCreateStatus withTargetUrl(@Nullable URI value) {
    if (this.targetUrl == value) return this;
    return new ImmutableRepositoryCreateStatus(this.state, value, this.description, this.context);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryCreateStatus#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryCreateStatus withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableRepositoryCreateStatus(this.state, this.targetUrl, value, this.context);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryCreateStatus#context() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepositoryCreateStatus withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return new ImmutableRepositoryCreateStatus(this.state, this.targetUrl, this.description, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepositoryCreateStatus} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepositoryCreateStatus
        && equalTo((ImmutableRepositoryCreateStatus) another);
  }

  private boolean equalTo(ImmutableRepositoryCreateStatus another) {
    return Objects.equals(state, another.state)
        && Objects.equals(targetUrl, another.targetUrl)
        && Objects.equals(description, another.description)
        && Objects.equals(context, another.context);
  }

  /**
   * Computes a hash code from attributes: {@code state}, {@code targetUrl}, {@code description}, {@code context}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(targetUrl);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(context);
    return h;
  }

  /**
   * Prints the immutable value {@code RepositoryCreateStatus} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RepositoryCreateStatus{"
        + "state=" + state
        + ", targetUrl=" + targetUrl
        + ", description=" + description
        + ", context=" + context
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RepositoryCreateStatus", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RepositoryCreateStatus {
    @Nullable String state;
    @Nullable URI targetUrl;
    @Nullable String description;
    @Nullable String context;
    @JsonProperty
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty
    public void setTargetUrl(@Nullable URI targetUrl) {
      this.targetUrl = targetUrl;
    }
    @JsonProperty
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty
    public void setContext(@Nullable String context) {
      this.context = context;
    }
    @Override
    public String state() { throw new UnsupportedOperationException(); }
    @Override
    public URI targetUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
    @Override
    public String context() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRepositoryCreateStatus fromJson(Json json) {
    ImmutableRepositoryCreateStatus.Builder builder = ImmutableRepositoryCreateStatus.builder();
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.targetUrl != null) {
      builder.targetUrl(json.targetUrl);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.context != null) {
      builder.context(json.context);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RepositoryCreateStatus} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepositoryCreateStatus instance
   */
  public static ImmutableRepositoryCreateStatus copyOf(RepositoryCreateStatus instance) {
    if (instance instanceof ImmutableRepositoryCreateStatus) {
      return (ImmutableRepositoryCreateStatus) instance;
    }
    return ImmutableRepositoryCreateStatus.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepositoryCreateStatus ImmutableRepositoryCreateStatus}.
   * <pre>
   * ImmutableRepositoryCreateStatus.builder()
   *    .state(String | null) // nullable {@link RepositoryCreateStatus#state() state}
   *    .targetUrl(java.net.URI | null) // nullable {@link RepositoryCreateStatus#targetUrl() targetUrl}
   *    .description(String | null) // nullable {@link RepositoryCreateStatus#description() description}
   *    .context(String | null) // nullable {@link RepositoryCreateStatus#context() context}
   *    .build();
   * </pre>
   * @return A new ImmutableRepositoryCreateStatus builder
   */
  public static ImmutableRepositoryCreateStatus.Builder builder() {
    return new ImmutableRepositoryCreateStatus.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepositoryCreateStatus ImmutableRepositoryCreateStatus}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepositoryCreateStatus", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String state;
    private @Nullable URI targetUrl;
    private @Nullable String description;
    private @Nullable String context;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RepositoryCreateStatus} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepositoryCreateStatus instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String stateValue = instance.state();
      if (stateValue != null) {
        state(stateValue);
      }
      @Nullable URI targetUrlValue = instance.targetUrl();
      if (targetUrlValue != null) {
        targetUrl(targetUrlValue);
      }
      @Nullable String descriptionValue = instance.description();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable String contextValue = instance.context();
      if (contextValue != null) {
        context(contextValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryCreateStatus#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryCreateStatus#targetUrl() targetUrl} attribute.
     * @param targetUrl The value for targetUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder targetUrl(@Nullable URI targetUrl) {
      this.targetUrl = targetUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryCreateStatus#description() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryCreateStatus#context() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder context(@Nullable String context) {
      this.context = context;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepositoryCreateStatus ImmutableRepositoryCreateStatus}.
     * @return An immutable instance of RepositoryCreateStatus
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepositoryCreateStatus build() {
      return new ImmutableRepositoryCreateStatus(state, targetUrl, description, context);
    }
  }
}
