package com.spotify.github.v3.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Search}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearch.builder()}.
 */
@Generated(from = "Search", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSearch implements Search {
  private final @Nullable Integer totalCount;
  private final @Nullable Boolean incompleteResults;

  private ImmutableSearch(
      @Nullable Integer totalCount,
      @Nullable Boolean incompleteResults) {
    this.totalCount = totalCount;
    this.incompleteResults = incompleteResults;
  }

  /**
   *Total count of search hits 
   */
  @JsonProperty
  @Override
  public @Nullable Integer totalCount() {
    return totalCount;
  }

  /**
   *Are returned results incomplete 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean incompleteResults() {
    return incompleteResults;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Search#totalCount() totalCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearch withTotalCount(@Nullable Integer value) {
    if (Objects.equals(this.totalCount, value)) return this;
    return new ImmutableSearch(value, this.incompleteResults);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Search#incompleteResults() incompleteResults} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for incompleteResults (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearch withIncompleteResults(@Nullable Boolean value) {
    if (Objects.equals(this.incompleteResults, value)) return this;
    return new ImmutableSearch(this.totalCount, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearch} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearch
        && equalTo((ImmutableSearch) another);
  }

  private boolean equalTo(ImmutableSearch another) {
    return Objects.equals(totalCount, another.totalCount)
        && Objects.equals(incompleteResults, another.incompleteResults);
  }

  /**
   * Computes a hash code from attributes: {@code totalCount}, {@code incompleteResults}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(totalCount);
    h += (h << 5) + Objects.hashCode(incompleteResults);
    return h;
  }

  /**
   * Prints the immutable value {@code Search} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Search{"
        + "totalCount=" + totalCount
        + ", incompleteResults=" + incompleteResults
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Search", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Search {
    @Nullable Integer totalCount;
    @Nullable Boolean incompleteResults;
    @JsonProperty
    public void setTotalCount(@Nullable Integer totalCount) {
      this.totalCount = totalCount;
    }
    @JsonProperty
    public void setIncompleteResults(@Nullable Boolean incompleteResults) {
      this.incompleteResults = incompleteResults;
    }
    @Override
    public Integer totalCount() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean incompleteResults() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearch fromJson(Json json) {
    ImmutableSearch.Builder builder = ImmutableSearch.builder();
    if (json.totalCount != null) {
      builder.totalCount(json.totalCount);
    }
    if (json.incompleteResults != null) {
      builder.incompleteResults(json.incompleteResults);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Search} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Search instance
   */
  public static ImmutableSearch copyOf(Search instance) {
    if (instance instanceof ImmutableSearch) {
      return (ImmutableSearch) instance;
    }
    return ImmutableSearch.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearch ImmutableSearch}.
   * <pre>
   * ImmutableSearch.builder()
   *    .totalCount(Integer | null) // nullable {@link Search#totalCount() totalCount}
   *    .incompleteResults(Boolean | null) // nullable {@link Search#incompleteResults() incompleteResults}
   *    .build();
   * </pre>
   * @return A new ImmutableSearch builder
   */
  public static ImmutableSearch.Builder builder() {
    return new ImmutableSearch.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearch ImmutableSearch}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Search", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer totalCount;
    private @Nullable Boolean incompleteResults;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Search} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Search instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer totalCountValue = instance.totalCount();
      if (totalCountValue != null) {
        totalCount(totalCountValue);
      }
      @Nullable Boolean incompleteResultsValue = instance.incompleteResults();
      if (incompleteResultsValue != null) {
        incompleteResults(incompleteResultsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Search#totalCount() totalCount} attribute.
     * @param totalCount The value for totalCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder totalCount(@Nullable Integer totalCount) {
      this.totalCount = totalCount;
      return this;
    }

    /**
     * Initializes the value for the {@link Search#incompleteResults() incompleteResults} attribute.
     * @param incompleteResults The value for incompleteResults (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder incompleteResults(@Nullable Boolean incompleteResults) {
      this.incompleteResults = incompleteResults;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearch ImmutableSearch}.
     * @return An immutable instance of Search
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearch build() {
      return new ImmutableSearch(totalCount, incompleteResults);
    }
  }
}
