/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.db.command.html.AbstractHtmlElement;
import com.sqlapp.data.db.command.html.MenuDefinition;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Consumer;

public class Menu
extends AbstractHtmlElement {
    private String name;
    private String url;
    private boolean active = false;
    private MenuDefinition menuDefinition = null;
    private String relativePath = null;

    public void addChild(Consumer<Menu> c) {
        Menu menu = new Menu();
        menu.setParent(this);
        this.add(menu);
        c.accept(menu);
    }

    public void addChild(Menu menu) {
        menu.setParent(this);
        this.add(menu);
    }

    public void setActive(String name) {
        for (Menu e : this.getChildren(Menu.class)) {
            if (!CommonUtils.eq((Object)e.getId(), (Object)name)) continue;
            e.setActive(true);
            return;
        }
    }

    public void setActive(MenuDefinition menuDef) {
        String name = menuDef.toString();
        for (Menu e : this.getChildren(Menu.class)) {
            if (!CommonUtils.eq((Object)e.getId(), (Object)name)) continue;
            e.setActive(true);
        }
    }

    public void setActive(boolean active) {
        if (active && this.getParent() != null) {
            for (Menu e : this.getParent().getChildren(Menu.class)) {
                if (e == this) continue;
                e.active = false;
            }
        }
        this.active = active;
    }

    public void setActiveRecursive(boolean active) {
        this.active = active;
        for (Menu e : this.getChildren(Menu.class)) {
            e.setActiveRecursive(active);
        }
    }

    public void setRelativePathRecursive(String relativePath) {
        this.relativePath = relativePath;
        for (Menu e : this.getChildren(Menu.class)) {
            e.setRelativePathRecursive(relativePath);
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        builder.add("name", this.name);
        builder.add("url", this.url);
        builder.add("active", Boolean.valueOf(this.active));
        builder.add("menuDefinition", (Object)this.menuDefinition);
    }

    public String getUrl() {
        if (this.relativePath != null) {
            return this.relativePath + this.url;
        }
        return this.url;
    }

    @Override
    public Menu clone() {
        Menu clone = (Menu)super.clone();
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public MenuDefinition getMenuDefinition() {
        return this.menuDefinition;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMenuDefinition(MenuDefinition menuDefinition) {
        this.menuDefinition = menuDefinition;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Menu)) {
            return false;
        }
        Menu other = (Menu)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        MenuDefinition this$menuDefinition = this.getMenuDefinition();
        MenuDefinition other$menuDefinition = other.getMenuDefinition();
        if (this$menuDefinition == null ? other$menuDefinition != null : !((Object)((Object)this$menuDefinition)).equals((Object)other$menuDefinition)) {
            return false;
        }
        String this$relativePath = this.getRelativePath();
        String other$relativePath = other.getRelativePath();
        return !(this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Menu;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isActive() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        MenuDefinition $menuDefinition = this.getMenuDefinition();
        result = result * 59 + ($menuDefinition == null ? 43 : ((Object)((Object)$menuDefinition)).hashCode());
        String $relativePath = this.getRelativePath();
        result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
        return result;
    }
}

