/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.data.db.command.generator.GeneratorSettingWorkbook;
import com.sqlapp.data.db.command.generator.MultiTableFoundException;
import com.sqlapp.data.db.command.generator.TableNotFoundException;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.util.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.List;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;

public class OutputGenerateDataTemplateCommand
extends AbstractDataSourceCommand {
    private String schemaName;
    private String tableName;
    private SqlType sqlType = SqlType.INSERT_ROW;
    private File outputDirectory = new File("./");

    @Override
    protected void doRun() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            Dialect dialect = this.getDialect(connection);
            CatalogReader catalogReader = dialect.getCatalogReader();
            TableReader tableReader = catalogReader.getSchemaReader().getTableReader();
            tableReader.setSchemaName(this.getSchemaName());
            tableReader.setObjectName(this.getTableName());
            List tableList = tableReader.getAllFull(connection);
            if (tableList.isEmpty()) {
                throw new TableNotFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName());
            }
            if (tableList.isEmpty()) {
                throw new MultiTableFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", tableSize=" + tableList.size());
            }
            File dir = this.getOutputDirectory();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            for (Table table : tableList) {
                String path = FileUtils.combinePath((Object[])new Object[]{this.getOutputDirectory().getAbsoluteFile(), table.getName() + ".xlsx"});
                File file = new File(path);
                Workbook wb = WorkbookFileType.EXCEL2007.createWorkbook();
                try {
                    GeneratorSettingWorkbook.Table.writeSheet(table, wb);
                    GeneratorSettingWorkbook.Column.writeSheet(table, wb);
                    GeneratorSettingWorkbook.QueryDefinition.writeSheet(table, wb);
                    try (FileOutputStream os = new FileOutputStream(file);
                         BufferedOutputStream bs = new BufferedOutputStream(os);){
                        wb.write((OutputStream)bs);
                        bs.flush();
                    }
                }
                finally {
                    if (wb == null) continue;
                    wb.close();
                }
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Generated
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    @Generated
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

