/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.version;

import com.sqlapp.data.db.command.version.DbVersionFileHandler;
import com.sqlapp.data.db.command.version.DbVersionHandler;
import com.sqlapp.data.db.command.version.VersionUpCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.schemas.DbConcurrencyException;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class VersionRepairCommand
extends VersionUpCommand {
    @Override
    protected List<Row> getVersionRows(Table table, List<DbVersionFileHandler.SqlFile> sqlFiles, DbVersionHandler dbVersionHandler) {
        Row row = dbVersionHandler.getRowsForVersionRepair(table);
        if (row == null) {
            return Collections.emptyList();
        }
        List rows = CommonUtils.list();
        rows.add(row);
        return rows;
    }

    @Override
    protected void executeSql(Connection connection, SqlConverter sqlConverter, Long id, Map<Long, DbVersionFileHandler.SqlFile> sqlFileMap) {
    }

    @Override
    protected boolean preCheck(Connection connection, Dialect dialect, Table table, Long id, Row row, DbVersionHandler dbVersionHandler) throws SQLException {
        if (!dbVersionHandler.exists(dialect, connection, table, id)) {
            throw new DbConcurrencyException("row=" + row);
        }
        return true;
    }

    @Override
    protected boolean startVersion(Connection connection, Dialect dialect, Table table, Row row, Long seriesNumber, DbVersionHandler dbVersionHandler) throws SQLException {
        return true;
    }

    @Override
    protected void finalizeVersion(Connection connection, Dialect dialect, Table table, Row row, Long id, DbVersionHandler dbVersionHandler) throws SQLException {
        dbVersionHandler.deleteVersion(connection, dialect, table, row);
    }

    @Override
    protected void errorVersion(Connection connection, Dialect dialect, Table table, Row row, Long id, DbVersionHandler dbVersionHandler) throws SQLException {
    }

    @Override
    protected List<SqlSplitter.SplitResult> getSqls(DbVersionFileHandler.SqlFile sqlFile) {
        return sqlFile.getDownSqls();
    }

    @Override
    public File getSetupSqlDirectory() {
        return null;
    }

    @Override
    public File getFinalizeSqlDirectory() {
        return null;
    }
}

