/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.generator.ColumnDataGeneratorSetting;
import com.sqlapp.data.db.command.generator.QueryDefinitionDataGeneratorSetting;
import com.sqlapp.data.db.command.generator.TableDataGeneratorSetting;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.rowiterator.ExcelUtils;
import com.sqlapp.util.CommonUtils;
import java.time.LocalDate;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GeneratorSettingWorkbook {
    Table{

        @Override
        public void writeSheet(Table table, Workbook wb) {
            String sheetName = this.name();
            int i = 0;
            GeneratorSettingWorkbook.setColumnData2Sheet(sheetName, "Table Name", i++, table.getName(), wb);
            GeneratorSettingWorkbook.setColumnData2Sheet(sheetName, "Number of Rows", i++, (Object)100, wb);
            Sheet sheet = wb.getSheet(sheetName);
            sheet.setDisplayGridlines(false);
        }

        @Override
        public void setObjectValue(Table table, TableDataGeneratorSetting setting) {
            setting.setName(table.getName());
            setting.setNumberOfRows(100L);
        }

        @Override
        public void readFromSheet(Workbook wb, TableDataGeneratorSetting setting) {
            String sheetName = this.name();
            Sheet sheet = ExcelUtils.getSheet((Workbook)wb, (String)sheetName);
            int i = 0;
            int j = 1;
            Row row = sheet.getRow(i++);
            Cell cell = ExcelUtils.getOrCreateCell((Row)row, (int)j);
            setting.setName((String)ExcelUtils.getCellValue((Cell)cell, String.class));
            row = sheet.getRow(i++);
            cell = ExcelUtils.getOrCreateCell((Row)row, (int)j);
            setting.setNumberOfRows((Long)ExcelUtils.getCellValue((Cell)cell, Long.class));
        }
    }
    ,
    Column{

        @Override
        public void writeSheet(Table table, Workbook wb) {
            String sheetName = this.name();
            int i = 0;
            GeneratorSettingWorkbook.setColumnData2Sheet(table, sheetName, COLUMN_NAME, null, i++, wb, c -> c.getName());
            GeneratorSettingWorkbook.setColumnData2Sheet(table, sheetName, DATA_TYPE, null, i++, wb, c -> c.getDataType());
            GeneratorSettingWorkbook.setColumnData2Sheet(table, sheetName, GENERATION_GROUP, null, i++, wb, c -> "");
            GeneratorSettingWorkbook.setColumnData2Sheet(table, sheetName, INSERT_EXCLUDE, null, i++, wb, c -> c.isIdentity() || c.getSequenceName() != null);
            GeneratorSettingWorkbook.setColumnData2Sheet(table, sheetName, INSERT_SQL_EXPRESSION, null, i++, wb, c -> "");
            GeneratorSettingWorkbook.setColumnData2Sheet(table, sheetName, START_VALUE, null, i++, wb, c -> GeneratorSettingWorkbook.getColumnStartValue(c));
            GeneratorSettingWorkbook.setColumnData2Sheet(table, sheetName, MAX_VALUE, AVAILABLE_VAR + "\n====\n" + START_VALUE + " : _start.[" + COLUMN_NAME + "]", i++, wb, c -> GeneratorSettingWorkbook.getColumnMaxValue(c));
            GeneratorSettingWorkbook.setColumnData2Sheet(table, sheetName, NEXT_VALUE, AVAILABLE_VAR + "\n====\n_index\n" + START_VALUE + " : _start.[" + COLUMN_NAME + "]\n" + MAX_VALUE + " : _max.[" + COLUMN_NAME + "]\n" + PREVIOUS_VALUE + " : _previous.[" + COLUMN_NAME + "]", i++, wb, c -> GeneratorSettingWorkbook.getColumnNextValue(c));
            GeneratorSettingWorkbook.setColumnData2Sheet(table, sheetName, VALUES, null, i++, wb, c -> null);
            Sheet sheet = wb.getSheet(sheetName);
            sheet.setDisplayGridlines(false);
        }

        @Override
        public void setObjectValue(Table table, TableDataGeneratorSetting setting) {
            int i = 0;
            for (Column column : table.getColumns()) {
                ColumnDataGeneratorSetting colSetting = new ColumnDataGeneratorSetting();
                colSetting.setName(column.getName());
                colSetting.setDataType(column.getDataType());
                colSetting.setInsertExclude(column.isIdentity() || column.getSequenceName() != null);
                Object val = GeneratorSettingWorkbook.getColumnStartValue(column);
                colSetting.setStartValue(val != null ? "" + val : null);
                val = GeneratorSettingWorkbook.getColumnMaxValue(column);
                colSetting.setMaxValue(val != null ? "" + val : null);
                colSetting.setNextValue(GeneratorSettingWorkbook.getColumnNextValue(column));
                setting.addColumn(colSetting, i++);
            }
        }

        @Override
        public void readFromSheet(Workbook wb, TableDataGeneratorSetting setting) {
            String sheetName = this.name();
            Sheet sheet = ExcelUtils.getSheet((Workbook)wb, (String)sheetName);
            int i = 0;
            Row row = sheet.getRow(i++);
            for (int j = 1; j < row.getLastCellNum(); ++j) {
                ColumnDataGeneratorSetting def = new ColumnDataGeneratorSetting();
                Cell cell = ExcelUtils.getOrCreateCell((Row)row, (int)j);
                def.setColString(ExcelUtils.convertNumToColString((Cell)cell));
                def.setName((String)ExcelUtils.getCellValue((Cell)cell, String.class));
                setting.addColumn(def, j);
            }
            GeneratorSettingWorkbook.setColumnSetting(sheet.getRow(i++), setting, DataType.class, (c, val) -> c.setDataType((DataType)val));
            GeneratorSettingWorkbook.setColumnSetting(sheet.getRow(i++), setting, String.class, (c, val) -> c.setGenerationGroup((String)val));
            GeneratorSettingWorkbook.setColumnSetting(sheet.getRow(i++), setting, Boolean.class, (c, val) -> c.setInsertExclude((boolean)val));
            GeneratorSettingWorkbook.setColumnSetting(sheet.getRow(i++), setting, String.class, (c, val) -> c.setInsertSqlExpression((String)val));
            GeneratorSettingWorkbook.setColumnSetting(sheet.getRow(i++), setting, String.class, (c, val) -> c.setStartValue((String)val));
            GeneratorSettingWorkbook.setColumnSetting(sheet.getRow(i++), setting, String.class, (c, val) -> c.setMaxValue((String)val));
            GeneratorSettingWorkbook.setColumnSetting(sheet.getRow(i++), setting, String.class, (c, val) -> c.setNextValue((String)val));
            while ((row = sheet.getRow(i++)) != null) {
                GeneratorSettingWorkbook.setColumnSetting(row, setting, (c, val) -> {
                    if (!CommonUtils.isEmpty((Object)val)) {
                        Object obj = Converters.getDefault().convertObject(val, c.getDataType().getDefaultClass());
                        if (c.getValues() == null) {
                            c.setValues(CommonUtils.list());
                        }
                        c.getValues().add(obj);
                    }
                });
            }
        }
    }
    ,
    QueryDefinition{

        @Override
        public void writeSheet(Table table, Workbook wb) {
            String sheetName = this.name();
            int i = 0;
            GeneratorSettingWorkbook.setColumnData2Sheet(sheetName, "Generation Group", null, i++, wb);
            GeneratorSettingWorkbook.setColumnData2Sheet(sheetName, "SELECT\u3000SQL", null, i++, wb);
            Sheet sheet = wb.getSheet(sheetName);
            sheet.setDisplayGridlines(false);
        }

        @Override
        public void setObjectValue(Table table, TableDataGeneratorSetting setting) {
            QueryDefinitionDataGeneratorSetting query = new QueryDefinitionDataGeneratorSetting();
            query.setGenerationGroup("Group1");
            query.setSelectSql("SELECT 1 AS abc");
            setting.addQueryDefinition(query, 0);
        }

        @Override
        public void readFromSheet(Workbook wb, TableDataGeneratorSetting setting) {
            Row row;
            String sheetName = this.name();
            Sheet sheet = ExcelUtils.getSheet((Workbook)wb, (String)sheetName);
            int i = 0;
            if ((row = sheet.getRow(i++)) == null) {
                return;
            }
            int lastCellNum = row.getLastCellNum();
            for (int j = 1; j < lastCellNum; ++j) {
                Cell cell = row.getCell(j);
                QueryDefinitionDataGeneratorSetting def = new QueryDefinitionDataGeneratorSetting();
                def.setColString(ExcelUtils.convertNumToColString((Cell)cell));
                def.setGenerationGroup((String)ExcelUtils.getCellValue((Cell)cell, String.class));
                row = sheet.getRow(i++);
                if (row == null) {
                    return;
                }
                cell = row.getCell(j);
                String val = (String)ExcelUtils.getCellValue((Cell)cell);
                def.setSelectSql(val);
                setting.addQueryDefinition(def, j);
            }
        }
    };

    private static String COLUMN_NAME;
    private static String DATA_TYPE;
    private static String GENERATION_GROUP;
    private static String INSERT_EXCLUDE;
    private static String INSERT_SQL_EXPRESSION;
    private static String START_VALUE;
    private static String PREVIOUS_VALUE;
    private static String MAX_VALUE;
    private static String NEXT_VALUE;
    private static String VALUES;
    private static String AVAILABLE_VAR;

    public void writeSheet(Table table, Workbook wb) {
    }

    public void readFromSheet(Workbook wb, TableDataGeneratorSetting setting) {
    }

    public void setObjectValue(Table table, TableDataGeneratorSetting setting) {
    }

    public static TableDataGeneratorSetting readWorkbook(Workbook wb) {
        TableDataGeneratorSetting setting = new TableDataGeneratorSetting();
        for (GeneratorSettingWorkbook enm : GeneratorSettingWorkbook.values()) {
            enm.readFromSheet(wb, setting);
        }
        setting.check();
        return setting;
    }

    private static Object getColumnStartValue(Column column) {
        if (column.getDataType() == DataType.BOOLEAN) {
            return "true";
        }
        if (column.getDataType() == DataType.DOUBLE) {
            return "1.0d";
        }
        if (column.getDataType() == DataType.FLOAT) {
            return "1.0f";
        }
        if (column.getDataType().isNumeric()) {
            return Converters.getNewBooleanTrueInstance().convertObject((Object)1, column.getDataType().getDefaultClass());
        }
        if (column.getDataType() == DataType.TIMESTAMP || column.getDataType() == DataType.DATETIME) {
            LocalDate dt = LocalDate.now();
            return "LocalDateTime.of(" + dt.getYear() + "," + dt.getMonthValue() + ",1,0,0,0)";
        }
        if (column.getDataType() == DataType.TIME) {
            return "LocalTime.of(0,0,0)";
        }
        if (column.getDataType() == DataType.DATE) {
            LocalDate dt = LocalDate.now();
            return "LocalDate.of(" + dt.getYear() + "," + dt.getMonthValue() + ",1)";
        }
        if (column.getDataType().isCharacter()) {
            return GeneratorSettingWorkbook.getDefaultCharacterExpression(column);
        }
        if (column.getDataType() == DataType.UUID) {
            return GeneratorSettingWorkbook.getDefaultUUIDExpression(column);
        }
        return null;
    }

    private static String getDefaultCharacterExpression(Column column) {
        if (column.getLength() == null) {
            return "nextAlphaNumeric(10)";
        }
        return "nextAlphaNumeric( " + column.getLength() + " )";
    }

    private static String getDefaultUUIDExpression(Column column) {
        return "java.util.UUID.randomUUID()";
    }

    private static <T> void setColumnSetting(Row row, TableDataGeneratorSetting setting, Class<T> clazz, BiConsumer<ColumnDataGeneratorSetting, T> cons) {
        for (int j = 1; j < row.getLastCellNum(); ++j) {
            ColumnDataGeneratorSetting col = setting.getColumnIndexs().get(j);
            if (col == null) continue;
            Cell cell = ExcelUtils.getOrCreateCell((Row)row, (int)j);
            Object val = ExcelUtils.getCellValue((Cell)cell, clazz);
            cons.accept(col, (ColumnDataGeneratorSetting)val);
        }
    }

    private static void setColumnSetting(Row row, TableDataGeneratorSetting setting, BiConsumer<ColumnDataGeneratorSetting, Object> cons) {
        for (int j = 1; j < row.getLastCellNum(); ++j) {
            Object val;
            Cell cell;
            ColumnDataGeneratorSetting col = setting.getColumnIndexs().get(j);
            if (col == null || (cell = row.getCell(j)) == null || (val = ExcelUtils.getCellValue((Cell)cell)) == null) continue;
            cons.accept(col, val);
        }
    }

    private static Object getColumnMaxValue(Column column) {
        if (column.getDataType() == DataType.BOOLEAN) {
            return null;
        }
        if (column.getDataType() == DataType.NUMERIC || column.getDataType() == DataType.DECIMAL) {
            return GeneratorSettingWorkbook.calculateDecimalMaxValue(column);
        }
        if (column.getDataType().isNumeric()) {
            if (column.getDataType().getMaxValue() != null) {
                return column.getDataType().getMaxValue();
            }
            return null;
        }
        if (column.getDataType() == DataType.TIMESTAMP || column.getDataType() == DataType.DATETIME) {
            return "addMonths(_start." + column.getName() + ",1)";
        }
        if (column.getDataType() == DataType.TIME) {
            return null;
        }
        if (column.getDataType() == DataType.DATE) {
            return "addMonths(_start." + column.getName() + ",1)";
        }
        return null;
    }

    private static long calculateDecimalMaxValue(Column column) {
        long len;
        Long length = column.getLength();
        Integer scale = column.getScale();
        if (length != null) {
            len = scale == null ? length : length - (long)scale.intValue();
        } else {
            return (long)Math.pow(10.0, 8.0);
        }
        return (long)Math.pow(10.0, len);
    }

    private static String getColumnNextValue(Column column) {
        if (column.getDataType() == DataType.BOOLEAN) {
            return "!_previous." + column.getName();
        }
        if (column.getDataType() == DataType.DOUBLE) {
            return "nextDouble(0.0d, 1000.0d)";
        }
        if (column.getDataType() == DataType.FLOAT) {
            return "nextDouble(0.0f, 1000.0f)";
        }
        if (column.getDataType().isNumeric()) {
            return "_previous." + column.getName() + " + 1";
        }
        if (column.getDataType() == DataType.TIMESTAMP || column.getDataType() == DataType.DATETIME) {
            return "addMilliSeconds(_previous." + column.getName() + ",1)";
        }
        if (column.getDataType() == DataType.TIME) {
            return "addSeconds(_previous." + column.getName() + ",1)";
        }
        if (column.getDataType() == DataType.DATE) {
            return "addDays(_previous." + column.getName() + ",1)";
        }
        if (column.getDataType().isCharacter()) {
            return GeneratorSettingWorkbook.getDefaultCharacterExpression(column);
        }
        if (column.getDataType() == DataType.UUID) {
            return GeneratorSettingWorkbook.getDefaultUUIDExpression(column);
        }
        return null;
    }

    private static void setColumnData2Sheet(String sheetName, String header, String cellComment, int rowNo, Workbook wb) {
        int j = 0;
        Sheet sheet = ExcelUtils.getOrCreateSheet((Workbook)wb, (String)sheetName);
        Row row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rowNo);
        Cell cell = ExcelUtils.getOrCreateCell((Row)row, (int)j++);
        CellStyle cellStyle = ExcelUtils.createCellStyle((Workbook)wb, (BorderStyle)BorderStyle.HAIR, (IndexedColors)IndexedColors.AQUA);
        cellStyle.setFont(GeneratorSettingWorkbook.getFont(wb));
        cell.setCellStyle(cellStyle);
        ExcelUtils.setCell((Workbook)wb, (Cell)cell, (Object)header);
        sheet.autoSizeColumn(cell.getColumnIndex());
        cellStyle.setWrapText(true);
        ExcelUtils.setCell((Workbook)wb, (Cell)cell, (Object)header);
        if (cellComment != null) {
            ExcelUtils.setComment((Cell)cell, (String)cellComment);
        }
    }

    private static void setColumnData2Sheet(String sheetName, String header, int rowNo, Object value, Workbook wb) {
        Sheet sheet = ExcelUtils.getOrCreateSheet((Workbook)wb, (String)sheetName);
        Row row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rowNo);
        int j = 0;
        Cell cell = ExcelUtils.getOrCreateCell((Row)row, (int)j++);
        CellStyle cellStyle = ExcelUtils.createCellStyle((Workbook)wb, (BorderStyle)BorderStyle.HAIR, (IndexedColors)IndexedColors.AQUA);
        cellStyle.setFont(GeneratorSettingWorkbook.getFont(wb));
        cell.setCellStyle(cellStyle);
        ExcelUtils.setCell((Workbook)wb, (Cell)cell, (Object)header);
        sheet.autoSizeColumn(cell.getColumnIndex());
        cellStyle.setWrapText(true);
        cell = ExcelUtils.getOrCreateCell((Row)row, (int)j++);
        cell.setCellStyle(cellStyle);
        ExcelUtils.setCell((Workbook)wb, (Cell)cell, (Object)value);
    }

    private static void setColumnData2Sheet(Table table, String sheetName, String header, String cellComment, int rowNo, Workbook wb, Function<Column, Object> func) {
        GeneratorSettingWorkbook.setColumnData2Sheet(sheetName, header, cellComment, rowNo, wb);
        Sheet sheet = ExcelUtils.getOrCreateSheet((Workbook)wb, (String)sheetName);
        Row row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rowNo);
        int j = 1;
        CellStyle cellStyle = ExcelUtils.createCellStyle((Workbook)wb, null, (IndexedColors)IndexedColors.AQUA);
        cellStyle.setFont(GeneratorSettingWorkbook.getFont(wb));
        for (Column column : table.getColumns()) {
            Cell cell = ExcelUtils.getOrCreateCell((Row)row, (int)j++);
            cell.setCellComment(null);
            cell.setCellStyle(cellStyle);
            cellStyle.setWrapText(true);
            ExcelUtils.setCell((Workbook)wb, (Cell)cell, (Object)func.apply(column));
            sheet.autoSizeColumn(cell.getColumnIndex());
        }
    }

    private static Font getFont(Workbook wb) {
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)16);
        font.setTypeOffset((short)1);
        return font;
    }

    static {
        COLUMN_NAME = "Column Name";
        DATA_TYPE = "Data Type";
        GENERATION_GROUP = "Generation Group";
        INSERT_EXCLUDE = "Insert Exclude";
        INSERT_SQL_EXPRESSION = "Insert SQL Expression";
        START_VALUE = "Start Value";
        PREVIOUS_VALUE = "Previous Value";
        MAX_VALUE = "Max Value";
        NEXT_VALUE = "Next Value";
        VALUES = "Values";
        AVAILABLE_VAR = "Available Variables";
    }
}

