/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.data.db.command.generator.GeneratorSettingFileType;
import com.sqlapp.data.db.command.generator.GeneratorSettingWorkbook;
import com.sqlapp.data.db.command.generator.MultiTableFoundException;
import com.sqlapp.data.db.command.generator.TableNotFoundException;
import com.sqlapp.data.db.command.generator.factory.TableGeneratorSettingFactory;
import com.sqlapp.data.db.command.generator.setting.TableGeneratorSetting;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.JsonConverter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Workbook;

public class OutputGeneratorSettingCommand
extends AbstractDataSourceCommand {
    private String schemaName;
    private String tableName;
    private SqlType sqlType = SqlType.INSERT;
    private File outputDirectory = new File("./");
    private TableOptions tableOptions = new TableOptions();
    private GeneratorSettingFileType fileType = GeneratorSettingFileType.EXCEL2007;
    private TableGeneratorSettingFactory generatorSettingFactory = new TableGeneratorSettingFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            Dialect dialect = this.getDialect(connection);
            CatalogReader catalogReader = dialect.getCatalogReader();
            TableReader tableReader = catalogReader.getSchemaReader().getTableReader();
            tableReader.setSchemaName(this.getSchemaName());
            tableReader.setObjectName(this.getTableName());
            List tableList = tableReader.getAllFull(connection);
            if (tableList.isEmpty()) {
                throw new TableNotFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName());
            }
            if (tableList.isEmpty()) {
                throw new MultiTableFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", tableSize=" + tableList.size());
            }
            File dir = this.getOutputDirectory();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            for (Table table : tableList) {
                this.writeFile(table, dir, dialect);
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    private void writeFile(Table table, File dir, Dialect dialect) throws FileNotFoundException, IOException {
        TableGeneratorSetting setting = this.getGeneratorSettingFactory().createDefault(table, dialect, this.getTableOptions(), this.getSqlType());
        switch (this.getFileType()) {
            case JSON: 
            case YAML: {
                this.writeTextFile(setting, dir);
                break;
            }
            default: {
                this.writeFileWorkbook(setting, dir);
            }
        }
    }

    private void writeTextFile(TableGeneratorSetting setting, File dir) throws FileNotFoundException, IOException {
        JsonConverter jsonConverter = this.getFileType().getWorkbookFileType().createJsonConverter();
        jsonConverter.setIndentOutput(true);
        String text = jsonConverter.toJsonString((Object)setting);
        FileUtils.write((File)new File(dir, setting.getName() + "." + this.getFileType().getWorkbookFileType().getFileExtension()), (CharSequence)text, (Charset)Charset.forName("UTF-8"));
    }

    private void writeFileWorkbook(TableGeneratorSetting setting, File dir) throws FileNotFoundException, IOException {
        try (Workbook wb = this.getFileType().getWorkbookFileType().createWorkbook();){
            GeneratorSettingWorkbook.Table.writeSheet(setting, wb);
            GeneratorSettingWorkbook.Column.writeSheet(setting, wb);
            GeneratorSettingWorkbook.Query.writeSheet(setting, wb);
            File file = new File(dir, setting.getName() + ".xlsx");
            try (FileOutputStream os = new FileOutputStream(file);
                 BufferedOutputStream bs = new BufferedOutputStream(os);){
                wb.write((OutputStream)bs);
                bs.flush();
            }
        }
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Generated
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    @Generated
    public GeneratorSettingFileType getFileType() {
        return this.fileType;
    }

    @Generated
    public TableGeneratorSettingFactory getGeneratorSettingFactory() {
        return this.generatorSettingFactory;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    @Generated
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Generated
    public void setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }

    @Generated
    public void setFileType(GeneratorSettingFileType fileType) {
        this.fileType = fileType;
    }

    @Generated
    public void setGeneratorSettingFactory(TableGeneratorSettingFactory generatorSettingFactory) {
        this.generatorSettingFactory = generatorSettingFactory;
    }
}

