/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.export;

import com.sqlapp.data.db.command.properties.CsvEncodingProperty;
import com.sqlapp.data.db.command.properties.FilesProperty;
import com.sqlapp.data.db.command.properties.JsonConverterProperty;
import com.sqlapp.data.db.command.properties.PlaceholderProperty;
import com.sqlapp.data.db.command.properties.PropertyUtils;
import com.sqlapp.data.db.command.properties.UseSchemaNameDirectoryProperty;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.Synonym;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.CombinedRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.CsvRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.ExcelRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.JsonRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.data.schemas.rowiterator.XmlRowIteratorHandler;
import com.sqlapp.exceptions.InvalidValueException;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.JsonConverter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import lombok.Generated;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class TableFileReader
implements PlaceholderProperty,
FilesProperty,
CsvEncodingProperty,
JsonConverterProperty,
UseSchemaNameDirectoryProperty {
    private File directory = null;
    private File[] files = null;
    private boolean useSchemaNameDirectory = false;
    private String csvEncoding = Charset.defaultCharset().toString();
    private int csvSkipHeaderRowsSize = 1;
    private JsonConverter jsonConverter = this.createJsonConverter();
    private File fileDirectory = null;
    private Predicate<File> fileFilter = f -> true;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private boolean placeholders = false;
    private Map<String, Object> context = CommonUtils.linkedMap();

    public List<TableFilesPair> getTableFilesPairs(Catalog catalog) {
        List<TableFilesPair> tableFilesPairs;
        Set schemaNames = CommonUtils.lowerSet();
        if (this.getFiles() != null) {
            List tfs = CommonUtils.list();
            Map fileListMap = CommonUtils.map();
            for (File file : this.getFiles()) {
                if (!this.isTargetFile(file)) continue;
                String name = FileUtils.getFileNameWithoutExtension((File)file);
                List list = (List)fileListMap.get(name);
                if (list == null) {
                    list = CommonUtils.list();
                    fileListMap.put(name, list);
                }
                list.add(file);
            }
            catalog.getSchemas().forEach(s -> s.getTables().forEach(t -> {
                List list = (List)fileListMap.get(t.getName());
                if (!CommonUtils.isEmpty((Collection)list)) {
                    TableFilesPair tf = new TableFilesPair((Table)t, list);
                    tfs.add(tf);
                }
            }));
            return tfs;
        }
        if (this.isUseSchemaNameDirectory()) {
            tableFilesPairs = CommonUtils.list();
            File[] directories = this.getDirectory().listFiles(c -> c.isDirectory());
            if (directories != null) {
                for (File directory : directories) {
                    String name = directory.getName();
                    schemaNames.add(name);
                    Schema schema = (Schema)catalog.getSchemas().get(name);
                    if (schema == null) continue;
                    tableFilesPairs.addAll(this.getTableFilesPairs(directory, schema));
                }
            }
        } else {
            tableFilesPairs = this.getTableFilesPairs(this.getDirectory(), catalog.getSchemas());
        }
        return tableFilesPairs;
    }

    public void setFiles(List<TableFilesPair> tfs) throws EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException {
        for (TableFilesPair tf : tfs) {
            this.readFiles(tf.getTable(), tf.getFiles());
        }
    }

    private boolean isTargetFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        if (!this.getFileFilter().test(file)) {
            return false;
        }
        return WorkbookFileType.parse((File)file) != null;
    }

    private List<TableFilesPair> getTableFilesPairs(File directory, SchemaCollection schemas) {
        File[] files = null;
        if (directory != null && directory.exists()) {
            files = directory.listFiles();
        }
        List<TableFilesPair> result = this.getTableFilePairWithFile(name -> this.getTableFilesPair(schemas, (String)name), files);
        return result;
    }

    private TableFilesPair getTableFilesPair(SchemaCollection schemas, String name) {
        for (Schema schema : schemas) {
            TableFilesPair pair = this.getTableFilesPair(schema, name);
            if (pair == null) continue;
            return pair;
        }
        return null;
    }

    private TableFilesPair getTableFilesPair(Schema schema, String name) {
        Table table = (Table)schema.getTables().get(name);
        if (table != null) {
            TableFilesPair pair = new TableFilesPair(table);
            return pair;
        }
        Synonym synonym = (Synonym)schema.getSynonyms().get(name);
        if (synonym != null) {
            TableFilesPair pair = new TableFilesPair(synonym);
            return pair;
        }
        return null;
    }

    private List<TableFilesPair> getTableFilesPairs(File directory, Schema schema) {
        return this.getTableFilePairWithFile(name -> this.getTableFilesPair(schema, (String)name), directory.listFiles());
    }

    private List<TableFilesPair> getTableFilePairWithFile(Function<String, TableFilesPair> func, File ... files) {
        List result = CommonUtils.list();
        if (files == null) {
            return result;
        }
        List fs = Arrays.stream(files).filter(f -> this.isTargetFile((File)f)).collect(Collectors.toList());
        Map fileListMap = CommonUtils.map();
        for (File file : fs) {
            String name2 = FileUtils.getFileNameWithoutExtension((File)file);
            List list2 = (List)fileListMap.get(name2);
            if (list2 == null) {
                list2 = CommonUtils.list();
                fileListMap.put(name2, list2);
            }
            list2.add(file);
        }
        fileListMap.forEach((name, list) -> {
            TableFilesPair pair = (TableFilesPair)func.apply((String)name);
            if (pair != null) {
                pair.getFiles().addAll((Collection<File>)list);
                result.add(pair);
            }
        });
        return result;
    }

    private SqlConverter getSqlConverter() {
        SqlConverter sqlConverter = new SqlConverter();
        sqlConverter.getExpressionConverter().setFileDirectory(this.getFileDirectory());
        sqlConverter.getExpressionConverter().setPlaceholderPrefix(this.getPlaceholderPrefix());
        sqlConverter.getExpressionConverter().setPlaceholderSuffix(this.getPlaceholderSuffix());
        sqlConverter.getExpressionConverter().setPlaceholders(this.isPlaceholders());
        return sqlConverter;
    }

    private void readFiles(Table table, List<File> files) throws EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException {
        List handlers = files.stream().map(file -> {
            WorkbookFileType workbookFileType = WorkbookFileType.parse((File)file);
            if (workbookFileType.isTextFile()) {
                if (workbookFileType.isCsv()) {
                    return new CsvRowIteratorHandler(file, this.getCsvEncoding(), this.getCsvSkipHeaderRowsSize(), this.getRowValueConverter());
                }
                if (workbookFileType.isXml()) {
                    return new XmlRowIteratorHandler(file, this.getRowValueConverter());
                }
                return new JsonRowIteratorHandler(file, this.getJsonConverter(), this.getRowValueConverter());
            }
            return new ExcelRowIteratorHandler(file, this.getRowValueConverter());
        }).collect(Collectors.toList());
        if (!handlers.isEmpty()) {
            table.setRowIteratorHandler((RowIteratorHandler)new CombinedRowIteratorHandler(handlers));
        }
    }

    private RowValueConverter getRowValueConverter() {
        SqlConverter sqlConverter = this.getSqlConverter();
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        return (RowValueConverter & Serializable)(r, c, v) -> {
            Object val;
            try {
                val = sqlConverter.getExpressionConverter().convert(v, (Object)context);
            }
            catch (IOException e) {
                throw new InvalidValueException(r, c, v, (Throwable)e);
            }
            return val;
        };
    }

    @Override
    public void setFiles(File ... obj) {
        this.files = PropertyUtils.convertArray(obj);
    }

    @Generated
    public File getDirectory() {
        return this.directory;
    }

    @Override
    @Generated
    public File[] getFiles() {
        return this.files;
    }

    @Override
    @Generated
    public boolean isUseSchemaNameDirectory() {
        return this.useSchemaNameDirectory;
    }

    @Override
    @Generated
    public String getCsvEncoding() {
        return this.csvEncoding;
    }

    @Generated
    public int getCsvSkipHeaderRowsSize() {
        return this.csvSkipHeaderRowsSize;
    }

    @Override
    @Generated
    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    @Generated
    public File getFileDirectory() {
        return this.fileDirectory;
    }

    @Generated
    public Predicate<File> getFileFilter() {
        return this.fileFilter;
    }

    @Override
    @Generated
    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    @Override
    @Generated
    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    @Override
    @Generated
    public boolean isPlaceholders() {
        return this.placeholders;
    }

    @Generated
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Generated
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    @Override
    @Generated
    public void setUseSchemaNameDirectory(boolean useSchemaNameDirectory) {
        this.useSchemaNameDirectory = useSchemaNameDirectory;
    }

    @Override
    @Generated
    public void setCsvEncoding(String csvEncoding) {
        this.csvEncoding = csvEncoding;
    }

    @Generated
    public void setCsvSkipHeaderRowsSize(int csvSkipHeaderRowsSize) {
        this.csvSkipHeaderRowsSize = csvSkipHeaderRowsSize;
    }

    @Override
    @Generated
    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    @Generated
    public void setFileDirectory(File fileDirectory) {
        this.fileDirectory = fileDirectory;
    }

    @Generated
    public void setFileFilter(Predicate<File> fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    @Generated
    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    @Override
    @Generated
    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    @Override
    @Generated
    public void setPlaceholders(boolean placeholders) {
        this.placeholders = placeholders;
    }

    @Generated
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public static class TableFilesPair {
        private final Table table;
        private final Synonym synonym;
        private final List<File> files;
        private final String name;

        TableFilesPair(Table table, List<File> files) {
            this.table = table;
            this.synonym = null;
            this.name = table.getName();
            this.files = files;
        }

        TableFilesPair(Table table, File ... files) {
            this.table = table;
            this.synonym = null;
            this.name = table.getName();
            this.files = CommonUtils.list((Object[])files);
        }

        TableFilesPair(Table table) {
            this.table = table;
            this.synonym = null;
            this.name = table.getName();
            this.files = CommonUtils.list();
        }

        TableFilesPair(Synonym synonym) {
            this.synonym = synonym;
            this.table = synonym.rootSynonym().getTable();
            this.name = synonym.getName();
            this.files = CommonUtils.list();
        }

        public Synonym getSynonym() {
            return this.synonym;
        }

        public String getName() {
            return this.name;
        }

        public Table getTable() {
            return this.table;
        }

        public List<File> getFiles() {
            return this.files;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(this.table.getName());
            builder.append(", ");
            builder.append("files=");
            builder.append(this.files);
            builder.append("]");
            return builder.toString();
        }
    }
}

