/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.version;

import com.sqlapp.data.db.command.AbstractSqlCommand;
import com.sqlapp.data.db.command.version.DbVersionFileHandler;
import com.sqlapp.data.db.command.version.DbVersionHandler;
import com.sqlapp.data.db.command.version.Status;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.db.sql.ConnectionSqlExecutor;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractBaseDbObject;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DefaultSchemaEqualsHandler;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexCollection;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.thread.ThreadContext;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.OutputTextBuilder;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class VersionUpCommand
extends AbstractSqlCommand {
    private File sqlDirectory;
    private File downSqlDirectory;
    private File setupSqlDirectory = null;
    private File finalizeSqlDirectory = null;
    private String schemaChangeLogTableName = "changelog";
    private String idColumnName = "change_number";
    private String statusColumnName = "status";
    private String appliedByColumnName = "applied_by";
    private String appliedAtColumnName = "applied_at";
    private String descriptionColumnName = "description";
    private String seriesNumberColumnName = "series_number";
    private Long lastChangeToApply = Long.MAX_VALUE;
    private boolean showVersionOnly = false;
    private boolean withSeriesNumber = true;
    private String previousState = null;
    private String lastState = null;
    private Table previousTable = null;
    private Table table = null;
    private AtomicInteger executedSqlCount = new AtomicInteger(0);

    @Override
    protected void doRun() {
        DbVersionHandler dbVersionHandler = this.createDbVersionHandler();
        DbVersionFileHandler dbVersionFileHandler = new DbVersionFileHandler();
        dbVersionFileHandler.setUpSqlDirectory(this.getSqlDirectory());
        dbVersionFileHandler.setDownSqlDirectory(this.getDownSqlDirectory());
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            Dialect dialect = this.getDialect((Connection)connection);
            dbVersionFileHandler.setSqlSplitter(dialect.createSqlSplitter());
            dbVersionFileHandler.setEncoding(this.getEncoding());
            DialectTableHolder holder = this.logCurrentState((Connection)connection, dbVersionHandler, dbVersionFileHandler, true);
            this.previousTable = holder.table;
            this.previousState = this.lastState;
            if (!this.isShowVersionOnly()) {
                if (!holder.rows.isEmpty()) {
                    this.info((Object)"");
                    this.executeChangeVersion((Connection)connection, holder.dialect, holder.table, holder.rows, holder.sqlFiles, dbVersionHandler);
                    holder = this.logCurrentState((Connection)connection, dbVersionHandler, dbVersionFileHandler, false);
                    this.table = holder.table;
                } else {
                    this.executeEmptyVersion(holder.dialect, holder.table, holder.rows, holder.sqlFiles, dbVersionHandler);
                    holder = this.logCurrentState((Connection)connection, dbVersionHandler, dbVersionFileHandler, false);
                    this.table = holder.table;
                }
            }
        }));
    }

    private DbVersionHandler createDbVersionHandler() {
        DbVersionHandler dbVersionHandler = new DbVersionHandler();
        dbVersionHandler.setIdColumnName(this.getIdColumnName());
        dbVersionHandler.setAppliedAtColumnName(this.getAppliedAtColumnName());
        dbVersionHandler.setAppliedByColumnName(this.getAppliedByColumnName());
        dbVersionHandler.setStatusColumnName(this.getStatusColumnName());
        dbVersionHandler.setDescriptionColumnName(this.getDescriptionColumnName());
        dbVersionHandler.setSeriesNumberColumnName(this.getSeriesNumberColumnName());
        dbVersionHandler.setWithSeriesNumber(this.withSeriesNumber);
        return dbVersionHandler;
    }

    protected void executeEmptyVersion(Dialect dialect, Table table, List<Row> rows, List<DbVersionFileHandler.SqlFile> sqlFiles, DbVersionHandler dbVersionHandler) {
        this.info((Object)"No sql file for apply.");
    }

    private List<SqlSplitter.SplitResult> read(Dialect dialect, File directory) {
        File[] children;
        if (directory == null) {
            return Collections.emptyList();
        }
        List files = CommonUtils.list();
        List result = CommonUtils.list();
        SqlSplitter splitter = dialect.createSqlSplitter();
        if (directory.exists() && (children = directory.listFiles()) != null) {
            for (File file2 : children) {
                if (!file2.getAbsolutePath().endsWith(".sql")) {
                    return null;
                }
                files.add(file2);
            }
        }
        Collections.sort(files);
        files.forEach(file -> {
            String text = FileUtils.readText((File)file, (String)this.getEncoding());
            List splits = splitter.parse(text);
            result.addAll(splits);
        });
        return result;
    }

    protected DialectTableHolder logCurrentState(Connection connection, DbVersionHandler dbVersionHandler, DbVersionFileHandler dbVersionFileHandler, boolean target) throws SQLException {
        DialectTableHolder holder = new DialectTableHolder();
        holder.sqlFiles = dbVersionFileHandler.read();
        holder.dialect = DialectResolver.getInstance().getDialect(connection);
        holder.table = dbVersionHandler.createVersionTableDefinition(this.schemaChangeLogTableName);
        this.checkTable(connection, holder.dialect, holder.table, dbVersionHandler);
        dbVersionHandler.load(connection, holder.dialect, holder.table);
        dbVersionHandler.mergeSqlFiles(holder.sqlFiles, holder.table);
        if (target) {
            holder.rows = this.getVersionRows(holder.table, holder.sqlFiles, dbVersionHandler);
        } else {
            dbVersionHandler.markCurrentVersion(holder.table);
        }
        this.lastState = this.outputCurrent(holder.table, dbVersionHandler);
        return holder;
    }

    protected void checkTable(Connection connection, Dialect dialect, Table table, DbVersionHandler dbVersionHandler) throws SQLException {
        Table currentTable = dbVersionHandler.getTable(connection, dialect, table);
        if (currentTable == null) {
            boolean bool = dbVersionHandler.createTable(connection, dialect, table);
            if (bool) {
                this.info((Object)("New change log table [" + this.getName(table) + "] was created."));
                return;
            }
        } else {
            DefaultSchemaEqualsHandler equalsHandler = new DefaultSchemaEqualsHandler();
            equalsHandler.setReferenceEqualsPredicate((object1, object2) -> {
                if (object1 instanceof IndexCollection || object2 instanceof IndexCollection) {
                    return true;
                }
                if (object1 instanceof Index || object2 instanceof Index) {
                    return true;
                }
                return object1 == object2;
            });
            equalsHandler.setValueEqualsPredicate((propertyName, eq, object1, object2, value1, value2) -> {
                if (object1 instanceof UniqueConstraint || object2 instanceof UniqueConstraint) {
                    return true;
                }
                if (value1 instanceof Index || value2 instanceof Index) {
                    return true;
                }
                if (SchemaProperties.CATALOG_NAME.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.SCHEMA_NAME.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.DATA_TYPE.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.DATA_TYPE_NAME.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.LENGTH.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.OCTET_LENGTH.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.SPECIFICS.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.STATISTICS.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.CREATED_AT.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.LAST_ALTERED_AT.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.COLLATION.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.CHARACTER_SET.getLabel().equals(propertyName)) {
                    return true;
                }
                if (SchemaProperties.CHARACTER_SEMANTICS.getLabel().equals(propertyName)) {
                    return true;
                }
                return eq;
            });
            DbObjectDifference diff = currentTable.diff((AbstractBaseDbObject)table, (EqualsHandler)equalsHandler);
            System.out.println(table);
            System.out.println(table.getPrimaryKeyConstraint());
            System.out.println(table.getIndexes());
            ConnectionSqlExecutor executor = new ConnectionSqlExecutor(connection);
            System.out.println(diff);
            SqlFactoryRegistry sqlFactoryRegistry = dialect.createSqlFactoryRegistry();
            List sqlList = sqlFactoryRegistry.createSql(diff);
            if (!sqlList.isEmpty()) {
                List lockTableSqlList = dialect.createSqlFactoryRegistry().createSql((DbCommonObject)table, SqlType.LOCK);
                executor.execute((Collection)lockTableSqlList);
                executor.execute((Collection)sqlList);
                try (Statement statement = connection.createStatement();){
                    Object name = dialect.quote(currentTable.getName());
                    if (currentTable.getSchemaName() != null) {
                        name = dialect.quote(currentTable.getSchemaName()) + "." + (String)name;
                    }
                    statement.execute("UPDATE " + (String)name + " SET " + dialect.quote(this.getStatusColumnName()) + "='" + Status.Completed + "' WHERE " + dialect.quote(this.getStatusColumnName()) + " IS NULL");
                    if (this.isWithSeriesNumber()) {
                        statement.execute("UPDATE " + (String)name + " SET " + dialect.quote(this.getSeriesNumberColumnName()) + "=" + dialect.quote(this.getIdColumnName()) + " WHERE " + dialect.quote(this.getSeriesNumberColumnName()) + " IS NULL");
                    }
                }
            }
        }
    }

    protected String outputCurrent(Table table, DbVersionHandler dbVersionHandler) {
        OutputTextBuilder builder = this.createOutputTextBuilder();
        builder.append((Object)"Database status.");
        builder.lineBreak();
        dbVersionHandler.append(table, builder);
        String value = builder.toString();
        this.info((Object)value);
        return value;
    }

    protected List<Row> getVersionRows(Table table, List<DbVersionFileHandler.SqlFile> sqlFiles, DbVersionHandler dbVersionHandler) {
        this.info((Object)("lastChangeToApply=" + this.getLastChangeToApply()));
        List<Row> rows = dbVersionHandler.getRowsForVersionUp(table, this.getLastChangeToApply());
        return rows;
    }

    protected void executeChangeVersion(Connection connection, Dialect dialect, Table table, List<Row> rows, List<DbVersionFileHandler.SqlFile> sqlFiles, DbVersionHandler dbVersionHandler) throws SQLException {
        Map sqlFileMap = CommonUtils.map();
        for (DbVersionFileHandler.SqlFile sqlFile : sqlFiles) {
            sqlFileMap.put(sqlFile.getVersionNumber(), sqlFile);
        }
        Long seriesNumber = null;
        Long id = null;
        Row currentRow = null;
        try {
            SqlConverter sqlConverter = this.getSqlConverter();
            connection.setAutoCommit(false);
            List<SqlSplitter.SplitResult> setupSqls = this.read(dialect, this.getSetupSqlDirectory());
            if (!CommonUtils.isEmpty(setupSqls)) {
                this.info((Object)"*********** execute setup sql. ***********");
            }
            this.executeSql(connection, sqlConverter, new ParametersContext(), setupSqls);
            List ddlAutoCommitOffSqlList = dialect.createSqlFactoryRegistry().createSql(SqlType.DDL_AUTOCOMMIT_OFF);
            List lockTableSqlList = dialect.createSqlFactoryRegistry().createSql((DbCommonObject)table, SqlType.LOCK);
            ConnectionSqlExecutor executor = new ConnectionSqlExecutor(connection);
            if (!CommonUtils.isEmpty(rows)) {
                this.info((Object)"*********** execute version sql. ***********");
            }
            for (Row row : rows) {
                id = dbVersionHandler.getId(row);
                if (id == null) continue;
                if (!this.preCheck(connection, dialect, table, id, row, dbVersionHandler)) {
                    return;
                }
                connection.setAutoCommit(false);
                executor.execute((Collection)ddlAutoCommitOffSqlList);
                executor.execute((Collection)lockTableSqlList);
                if (!this.startVersion(connection, dialect, table, row, seriesNumber != null ? seriesNumber : id, dbVersionHandler)) {
                    return;
                }
                if (seriesNumber == null) {
                    seriesNumber = id;
                }
                currentRow = row;
                this.executeSql(connection, sqlConverter, id, sqlFileMap);
                this.finalizeVersion(connection, dialect, table, row, id, dbVersionHandler);
                this.commit(connection);
                currentRow = null;
            }
            List<SqlSplitter.SplitResult> finalizeSqls = this.read(dialect, this.getFinalizeSqlDirectory());
            if (!CommonUtils.isEmpty(finalizeSqls)) {
                this.info((Object)"*********** execute finalize sql. ***********");
            }
            this.executeSql(connection, sqlConverter, new ParametersContext(), finalizeSqls);
            this.commit(connection);
        }
        catch (RuntimeException e) {
            String sql = ThreadContext.getSql();
            logger.error("sql=[" + sql + "]", (Throwable)e);
            if (connection != null) {
                this.rollback(connection);
                if (currentRow != null && id != null) {
                    if (this.executedSqlCount.get() > 0) {
                        try {
                            connection.setAutoCommit(false);
                            this.errorVersion(connection, dialect, table, currentRow, id, dbVersionHandler);
                            this.commit(connection);
                        }
                        catch (SQLException e1) {
                            logger.error("set error " + currentRow + " status failed.", (Throwable)e);
                        }
                    } else {
                        try {
                            connection.setAutoCommit(false);
                            this.deleteVersion(connection, dialect, table, currentRow, dbVersionHandler);
                            this.commit(connection);
                        }
                        catch (SQLException e1) {
                            logger.error(this.getSchemaChangeLogTableName() + " recovery failed.", (Throwable)e);
                        }
                    }
                }
            }
            throw e;
        }
    }

    protected void executeSql(Connection connection, SqlConverter sqlConverter, Long id, Map<Long, DbVersionFileHandler.SqlFile> sqlFileMap) throws SQLException {
        DbVersionFileHandler.SqlFile sqlFile = sqlFileMap.get(id);
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        List<SqlSplitter.SplitResult> sqls = this.getSqls(sqlFile);
        this.executedSqlCount.set(0);
        if (!CommonUtils.isEmpty(sqls)) {
            for (SqlSplitter.SplitResult splitResult : sqls) {
                this.executeSql(connection, sqlConverter, context, splitResult);
                this.executedSqlCount.incrementAndGet();
            }
        }
    }

    protected void executeSql(Connection connection, SqlConverter sqlConverter, ParametersContext context, List<SqlSplitter.SplitResult> splitResults) throws SQLException {
        for (SqlSplitter.SplitResult splitResult : splitResults) {
            this.executeSql(connection, sqlConverter, context, splitResult);
        }
    }

    protected void executeSql(Connection connection, SqlConverter sqlConverter, ParametersContext context, SqlSplitter.SplitResult splitResult) throws SQLException {
        SqlNode sqlNode = sqlConverter.parseSql(context, splitResult.getText());
        JdbcHandler jdbcHandler = new JdbcHandler(sqlNode);
        jdbcHandler.execute(connection, context);
    }

    protected List<SqlSplitter.SplitResult> getSqls(DbVersionFileHandler.SqlFile sqlFile) {
        return sqlFile.getUpSqls();
    }

    protected boolean preCheck(Connection connection, Dialect dialect, Table table, Long id, Row row, DbVersionHandler dbVersionHandler) throws SQLException {
        return !dbVersionHandler.exists(dialect, connection, table, id);
    }

    protected boolean startVersion(Connection connection, Dialect dialect, Table table, Row row, Long seriesNumber, DbVersionHandler dbVersionHandler) throws SQLException {
        try {
            dbVersionHandler.insertVersion(connection, dialect, table, row, seriesNumber, Status.Started);
            return true;
        }
        catch (SQLIntegrityConstraintViolationException e) {
            return false;
        }
    }

    protected void finalizeVersion(Connection connection, Dialect dialect, Table table, Row row, Long id, DbVersionHandler dbVersionHandler) throws SQLException {
        dbVersionHandler.updateVersion(connection, dialect, table, row, id, Status.Started, Status.Completed);
    }

    protected void errorVersion(Connection connection, Dialect dialect, Table table, Row row, Long id, DbVersionHandler dbVersionHandler) throws SQLException {
        dbVersionHandler.updateVersion(connection, dialect, table, row, id, Status.Started, Status.Errored);
    }

    protected void deleteVersion(Connection connection, Dialect dialect, Table table, Row row, DbVersionHandler dbVersionHandler) throws SQLException {
        dbVersionHandler.deleteVersion(connection, dialect, table, row);
    }

    protected void deleteVersion(Connection connection, Table table, long id) throws SQLException {
        Dialect dialect = DialectResolver.getInstance().getDialect(connection);
        DbVersionHandler dbVersionHandler = this.createDbVersionHandler();
        dbVersionHandler.deleteVersion(connection, dialect, table, id);
    }

    protected String getName(Table table) {
        if (CommonUtils.isEmpty((CharSequence)table.getSchemaName())) {
            return table.getName();
        }
        return table.getSchemaName() + "." + table.getName();
    }

    @Generated
    public File getSqlDirectory() {
        return this.sqlDirectory;
    }

    @Generated
    public File getDownSqlDirectory() {
        return this.downSqlDirectory;
    }

    @Generated
    public File getSetupSqlDirectory() {
        return this.setupSqlDirectory;
    }

    @Generated
    public File getFinalizeSqlDirectory() {
        return this.finalizeSqlDirectory;
    }

    @Generated
    public String getSchemaChangeLogTableName() {
        return this.schemaChangeLogTableName;
    }

    @Generated
    public String getIdColumnName() {
        return this.idColumnName;
    }

    @Generated
    public String getStatusColumnName() {
        return this.statusColumnName;
    }

    @Generated
    public String getAppliedByColumnName() {
        return this.appliedByColumnName;
    }

    @Generated
    public String getAppliedAtColumnName() {
        return this.appliedAtColumnName;
    }

    @Generated
    public String getDescriptionColumnName() {
        return this.descriptionColumnName;
    }

    @Generated
    public String getSeriesNumberColumnName() {
        return this.seriesNumberColumnName;
    }

    @Generated
    public Long getLastChangeToApply() {
        return this.lastChangeToApply;
    }

    @Generated
    public boolean isShowVersionOnly() {
        return this.showVersionOnly;
    }

    @Generated
    public boolean isWithSeriesNumber() {
        return this.withSeriesNumber;
    }

    @Generated
    public String getPreviousState() {
        return this.previousState;
    }

    @Generated
    public String getLastState() {
        return this.lastState;
    }

    @Generated
    public Table getPreviousTable() {
        return this.previousTable;
    }

    @Generated
    public Table getTable() {
        return this.table;
    }

    @Generated
    public AtomicInteger getExecutedSqlCount() {
        return this.executedSqlCount;
    }

    @Generated
    public void setSqlDirectory(File sqlDirectory) {
        this.sqlDirectory = sqlDirectory;
    }

    @Generated
    public void setDownSqlDirectory(File downSqlDirectory) {
        this.downSqlDirectory = downSqlDirectory;
    }

    @Generated
    public void setSetupSqlDirectory(File setupSqlDirectory) {
        this.setupSqlDirectory = setupSqlDirectory;
    }

    @Generated
    public void setFinalizeSqlDirectory(File finalizeSqlDirectory) {
        this.finalizeSqlDirectory = finalizeSqlDirectory;
    }

    @Generated
    public void setSchemaChangeLogTableName(String schemaChangeLogTableName) {
        this.schemaChangeLogTableName = schemaChangeLogTableName;
    }

    @Generated
    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName;
    }

    @Generated
    public void setStatusColumnName(String statusColumnName) {
        this.statusColumnName = statusColumnName;
    }

    @Generated
    public void setAppliedByColumnName(String appliedByColumnName) {
        this.appliedByColumnName = appliedByColumnName;
    }

    @Generated
    public void setAppliedAtColumnName(String appliedAtColumnName) {
        this.appliedAtColumnName = appliedAtColumnName;
    }

    @Generated
    public void setDescriptionColumnName(String descriptionColumnName) {
        this.descriptionColumnName = descriptionColumnName;
    }

    @Generated
    public void setSeriesNumberColumnName(String seriesNumberColumnName) {
        this.seriesNumberColumnName = seriesNumberColumnName;
    }

    @Generated
    public void setLastChangeToApply(Long lastChangeToApply) {
        this.lastChangeToApply = lastChangeToApply;
    }

    @Generated
    public void setShowVersionOnly(boolean showVersionOnly) {
        this.showVersionOnly = showVersionOnly;
    }

    @Generated
    public void setWithSeriesNumber(boolean withSeriesNumber) {
        this.withSeriesNumber = withSeriesNumber;
    }

    @Generated
    public void setPreviousState(String previousState) {
        this.previousState = previousState;
    }

    @Generated
    public void setLastState(String lastState) {
        this.lastState = lastState;
    }

    @Generated
    public void setPreviousTable(Table previousTable) {
        this.previousTable = previousTable;
    }

    @Generated
    public void setTable(Table table) {
        this.table = table;
    }

    @Generated
    public void setExecutedSqlCount(AtomicInteger executedSqlCount) {
        this.executedSqlCount = executedSqlCount;
    }

    static class DialectTableHolder {
        public Dialect dialect = null;
        public Table table = null;
        public List<Row> rows = null;
        public List<DbVersionFileHandler.SqlFile> sqlFiles = null;

        DialectTableHolder() {
        }
    }
}

