/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.converter.TimestampConverter;
import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.CommandDefaultUtils;
import com.sqlapp.data.db.command.properties.DataSourceProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.jdbc.ReleaseConnectionHandler;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.jdbc.function.SQLConsumer;
import com.sqlapp.util.OutputTextBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;

public abstract class AbstractDataSourceCommand
extends AbstractCommand
implements DataSourceProperty {
    private DataSource dataSource;
    private boolean closeDataSource = true;
    private final Converters converters = this.newConverters();
    private ReleaseConnectionHandler releaseConnectionAndCloseDataSourceHandler = CommandDefaultUtils.getReleaseConnectionAndCloseDataSourceHandler();
    private ReleaseConnectionHandler releaseConnectionHandler = CommandDefaultUtils.getReleaseConnectionHandler();
    private SQLConsumer<Connection> commitHandler = CommandDefaultUtils.getCommitHandler();
    private SQLConsumer<Connection> lastCommitHandler = CommandDefaultUtils.getLastCommitHandler();
    private SQLConsumer<Connection> rollbackHandler = CommandDefaultUtils.getRollbackHandler();

    protected Converters newConverters() {
        Converters converters = new Converters();
        TimestampConverter converter = (TimestampConverter)converters.getConverter(Timestamp.class);
        converter.getZonedDateTimeConverter().setFormat("uuuu-MM-dd HH:mm:ss");
        return converters;
    }

    protected OutputTextBuilder createOutputTextBuilder() {
        OutputTextBuilder builder = new OutputTextBuilder();
        builder.setConverters(this.converters);
        return builder;
    }

    protected void execute(DataSource dataSource, ExceptionConsumer<Connection> cons) {
        if (this.isCloseDataSource()) {
            this.executeTranInternal(dataSource, cons, this.releaseConnectionAndCloseDataSourceHandler);
        } else {
            this.executeTranInternal(dataSource, cons, this.releaseConnectionHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTranInternal(DataSource dataSource, ExceptionConsumer<Connection> cons, ReleaseConnectionHandler releaseConnectionHandler) {
        Connection connection;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.execute(() -> {
                if (this.releaseConnectionAndCloseDataSourceHandler != null) {
                    this.releaseConnectionAndCloseDataSourceHandler.accept((Object)dataSource, null);
                }
            });
            throw new RuntimeException(e);
        }
        try {
            connection.setAutoCommit(false);
            cons.accept((Object)connection);
            this.commit(connection, this.lastCommitHandler);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.rollback(connection);
            this.getExceptionHandler().handle((Throwable)e);
        }
        finally {
            this.execute(() -> {
                if (releaseConnectionHandler != null) {
                    releaseConnectionHandler.accept((Object)dataSource, (Object)connection);
                }
            });
        }
    }

    protected void commit(Connection connection) {
        this.commit(connection, this.commitHandler);
    }

    private void commit(Connection connection, SQLConsumer<Connection> commitHandler) {
        this.execute(() -> {
            if (commitHandler != null) {
                commitHandler.accept((Object)connection);
                this.debug((Object)"commit");
            }
        });
    }

    protected void rollback(Connection connection) {
        this.execute(() -> {
            if (this.rollbackHandler != null) {
                this.rollbackHandler.accept((Object)connection);
                this.info((Object)"rollback");
            }
        });
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Dialect getDialect(Connection connection) {
        return DialectResolver.getInstance().getDialect(connection);
    }

    protected String getCurrentCatalogName(Connection connection) throws SQLException {
        return connection.getCatalog();
    }

    protected String getCurrentSchemaName(Connection connection) throws SQLException {
        return connection.getSchema();
    }

    public void setReleaseConnectionAndCloseDataSourceHandler(ReleaseConnectionHandler releaseConnectionAndCloseDataSourceHandler) {
        this.releaseConnectionAndCloseDataSourceHandler = releaseConnectionAndCloseDataSourceHandler;
    }

    public void setReleaseConnectionHandler(ReleaseConnectionHandler releaseConnectionHandler) {
        this.releaseConnectionHandler = releaseConnectionHandler;
    }

    public void setCommitHandler(SQLConsumer<Connection> commitHandler) {
        this.commitHandler = commitHandler;
    }

    public void setLastCommitHandler(SQLConsumer<Connection> lastCommitHandler) {
        this.lastCommitHandler = lastCommitHandler;
    }

    public void setRollbackHandler(SQLConsumer<Connection> rollbackHandler) {
        this.rollbackHandler = rollbackHandler;
    }

    public boolean isCloseDataSource() {
        return this.closeDataSource;
    }

    public void setCloseDataSource(boolean closeDataSource) {
        this.closeDataSource = closeDataSource;
    }
}

