/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.db.command.AbstractTableCommand;
import com.sqlapp.data.db.command.generator.GeneratorSettingFileType;
import com.sqlapp.data.db.command.generator.GeneratorSettingWorkbook;
import com.sqlapp.data.db.command.generator.TableNotFoundException;
import com.sqlapp.data.db.command.generator.factory.TableGeneratorSettingFactory;
import com.sqlapp.data.db.command.generator.setting.TableGeneratorSetting;
import com.sqlapp.data.db.command.properties.OutputDirectoryProperty;
import com.sqlapp.data.db.command.properties.SqlTypeProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.util.JsonConverter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Workbook;

public class GenerateGeneratorSettingCommand
extends AbstractTableCommand
implements SqlTypeProperty,
OutputDirectoryProperty {
    private SqlType sqlType = SqlType.INSERT;
    private File outputDirectory = new File("./");
    private GeneratorSettingFileType fileType = GeneratorSettingFileType.EXCEL2007;
    private TableGeneratorSettingFactory generatorSettingFactory = new TableGeneratorSettingFactory();

    @Override
    protected void doRun() {
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            Dialect dialect = this.getDialect((Connection)connection);
            List<Table> tables = this.getTables((Connection)connection, dialect);
            if (tables.isEmpty()) {
                throw new TableNotFoundException("includeSchemas=" + Arrays.toString(this.getIncludeSchemas()) + ", excludeSchemas=" + Arrays.toString(this.getExcludeSchemas()) + ", includeTables=" + Arrays.toString(this.getIncludeTables()) + ", excludeTables=" + Arrays.toString(this.getExcludeTables()));
            }
            File dir = this.getOutputDirectory();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            for (Table table : tables) {
                this.writeFile(table, dir, dialect);
            }
        }));
    }

    private void writeFile(Table table, File dir, Dialect dialect) throws FileNotFoundException, IOException {
        TableGeneratorSetting setting = this.getGeneratorSettingFactory().createDefault(table, dialect, this.getTableOptions(), this.getSqlType());
        switch (this.getFileType()) {
            case JSON: 
            case YAML: {
                this.writeTextFile(setting, dir);
                break;
            }
            default: {
                this.writeFileWorkbook(setting, dir);
            }
        }
    }

    private void writeTextFile(TableGeneratorSetting setting, File dir) throws FileNotFoundException, IOException {
        JsonConverter jsonConverter = this.getFileType().getWorkbookFileType().createJsonConverter();
        jsonConverter.setIndentOutput(true);
        String text = jsonConverter.toJsonString((Object)setting);
        FileUtils.write((File)new File(dir, setting.getName() + "." + this.getFileType().getWorkbookFileType().getFileExtension()), (CharSequence)text, (Charset)Charset.forName("UTF-8"));
    }

    private void writeFileWorkbook(TableGeneratorSetting setting, File dir) throws FileNotFoundException, IOException {
        try (Workbook wb = this.getFileType().getWorkbookFileType().createWorkbook();){
            GeneratorSettingWorkbook.Table.writeSheet(setting, wb);
            GeneratorSettingWorkbook.Column.writeSheet(setting, wb);
            GeneratorSettingWorkbook.Query.writeSheet(setting, wb);
            File file = new File(dir, setting.getName() + ".xlsx");
            try (FileOutputStream os = new FileOutputStream(file);
                 BufferedOutputStream bs = new BufferedOutputStream(os);){
                wb.write((OutputStream)bs);
                bs.flush();
            }
        }
    }

    @Override
    @Generated
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Override
    @Generated
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public GeneratorSettingFileType getFileType() {
        return this.fileType;
    }

    @Generated
    public TableGeneratorSettingFactory getGeneratorSettingFactory() {
        return this.generatorSettingFactory;
    }

    @Override
    @Generated
    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    @Override
    @Generated
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Generated
    public void setFileType(GeneratorSettingFileType fileType) {
        this.fileType = fileType;
    }

    @Generated
    public void setGeneratorSettingFactory(TableGeneratorSettingFactory generatorSettingFactory) {
        this.generatorSettingFactory = generatorSettingFactory;
    }
}

