/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator.factory;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.generator.factory.ColumnDefaultCharacterExpression;
import com.sqlapp.data.db.command.generator.factory.ColumnDefaultJsonExpression;
import com.sqlapp.data.db.command.generator.factory.ColumnUUIDExpression;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.function.ColumnFunction;
import java.time.LocalDate;
import lombok.Generated;

public class ColumnMinValue
implements ColumnFunction<String> {
    private static final long serialVersionUID = -2049712084354162318L;
    private ColumnFunction<String> charExpression = new ColumnDefaultCharacterExpression();
    private ColumnFunction<String> jsonExpression = new ColumnDefaultJsonExpression();
    private ColumnFunction<String> uuidExpression = new ColumnUUIDExpression();

    public String apply(Column column) {
        if (column.getDataType() == DataType.BOOLEAN) {
            return "true";
        }
        if (column.getDataType() == DataType.DOUBLE) {
            return "1.0d";
        }
        if (column.getDataType() == DataType.FLOAT) {
            return "1.0f";
        }
        if (column.getDataType().isNumeric()) {
            return "" + Converters.getNewBooleanTrueInstance().convertObject((Object)1, column.getDataType().getDefaultClass());
        }
        if (column.getDataType() == DataType.TIMESTAMP || column.getDataType() == DataType.DATETIME) {
            LocalDate dt = LocalDate.now();
            return "LocalDateTime.of(" + dt.getYear() + "," + dt.getMonthValue() + ",1,0,0,0)";
        }
        if (column.getDataType() == DataType.TIME) {
            return "LocalTime.of(0,0,0)";
        }
        if (column.getDataType() == DataType.DATE) {
            LocalDate dt = LocalDate.now();
            return "LocalDate.of(" + dt.getYear() + "," + dt.getMonthValue() + ",1)";
        }
        if (column.getDataType().isJson()) {
            return (String)this.getJsonExpression().apply((Object)column);
        }
        if (column.getDataType().isCharacter()) {
            return (String)this.getCharExpression().apply((Object)column);
        }
        if (column.getDataType() == DataType.UUID) {
            return (String)this.getUuidExpression().apply((Object)column);
        }
        return null;
    }

    @Generated
    public ColumnFunction<String> getCharExpression() {
        return this.charExpression;
    }

    @Generated
    public ColumnFunction<String> getJsonExpression() {
        return this.jsonExpression;
    }

    @Generated
    public ColumnFunction<String> getUuidExpression() {
        return this.uuidExpression;
    }

    @Generated
    public void setCharExpression(ColumnFunction<String> charExpression) {
        this.charExpression = charExpression;
    }

    @Generated
    public void setJsonExpression(ColumnFunction<String> jsonExpression) {
        this.jsonExpression = jsonExpression;
    }

    @Generated
    public void setUuidExpression(ColumnFunction<String> uuidExpression) {
        this.uuidExpression = uuidExpression;
    }
}

