/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator.factory;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.generator.GeneratorSettingFileType;
import com.sqlapp.data.db.command.generator.GeneratorSettingWorkbook;
import com.sqlapp.data.db.command.generator.factory.ColumnMaxValue;
import com.sqlapp.data.db.command.generator.factory.ColumnMinValue;
import com.sqlapp.data.db.command.generator.factory.ColumnNextValue;
import com.sqlapp.data.db.command.generator.factory.ColumnStartValue;
import com.sqlapp.data.db.command.generator.setting.ColumnGeneratorSetting;
import com.sqlapp.data.db.command.generator.setting.QueryGeneratorSetting;
import com.sqlapp.data.db.command.generator.setting.TableGeneratorSetting;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.ColumnFunction;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.JsonConverter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;

public class TableGeneratorSettingFactory {
    private ColumnFunction<String> columnMinValue = new ColumnMinValue();
    private ColumnFunction<String> columnNextValue = new ColumnNextValue();
    private ColumnFunction<String> columnMaxValue = new ColumnMaxValue();
    private BiFunction<Column, Dialect, String> columnStartValue = new ColumnStartValue();
    private boolean withSchemaName = false;

    public TableGeneratorSetting createDefault(Table table, Dialect dialect, TableOptions tableOptions, SqlType sqlType) {
        TableGeneratorSetting setting = new TableGeneratorSetting();
        this.setTableDefaultValues(table, dialect, setting);
        String sql = this.createInsertSql(table, dialect, tableOptions, sqlType);
        setting.setInsertSql(sql);
        this.setColumnDefaultValues(table, dialect, setting);
        this.setQueryDefaultValue(table, dialect, setting);
        return setting;
    }

    public TableGeneratorSetting createDefault(Table table, Dialect dialect) {
        return this.createDefault(table, dialect, null, SqlType.INSERT);
    }

    public TableGeneratorSetting fromFile(File file) {
        if (!file.exists() || file.isDirectory()) {
            return null;
        }
        GeneratorSettingFileType enm = GeneratorSettingFileType.parse(file);
        if (enm == null) {
            return null;
        }
        WorkbookFileType workbookFileType = enm.getWorkbookFileType();
        if (workbookFileType.isWorkbook()) {
            TableGeneratorSetting tableGeneratorSetting;
            block14: {
                Workbook wb = workbookFileType.createWorkBook(file, true);
                try {
                    TableGeneratorSetting setting = GeneratorSettingWorkbook.readWorkbook(wb);
                    setting.setParentDirectory(file.getParentFile());
                    tableGeneratorSetting = setting;
                    if (wb == null) break block14;
                }
                catch (Throwable setting) {
                    try {
                        if (wb != null) {
                            try {
                                wb.close();
                            }
                            catch (Throwable throwable) {
                                setting.addSuppressed(throwable);
                            }
                        }
                        throw setting;
                    }
                    catch (IOException | EncryptedDocumentException | InvalidFormatException e) {
                        throw new RuntimeException(e);
                    }
                }
                wb.close();
            }
            return tableGeneratorSetting;
        }
        if (workbookFileType.isJson() || workbookFileType.isYaml()) {
            try {
                String text = FileUtils.readFileToString((File)file, (Charset)Charset.forName("UTF8"));
                JsonConverter jsonConverter = workbookFileType.createJsonConverter();
                TableGeneratorSetting setting = (TableGeneratorSetting)jsonConverter.fromJsonString(text, TableGeneratorSetting.class);
                setting.setParentDirectory(file.getParentFile());
                return setting;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected void setTableDefaultValues(Table table, Dialect dialect, TableGeneratorSetting setting) {
        setting.setName(table.getName());
        setting.setNumberOfRows(100L);
        setting.setStartValueSql(this.getStartValueQuerySql(table, dialect));
        AbstractSqlBuilder<?> sqlBuilder = this.createSqlBuilder(dialect);
        String selectCountSql = sqlBuilder.select().count()._add("(*)").from().name((AbstractSchemaObject)table).toString();
        boolean hasIdentity = table.getColumns().stream().filter(c -> c.isIdentity()).findAny().isPresent();
        if (hasIdentity) {
            List ops = dialect.createSqlFactoryRegistry().createSql((DbCommonObject)table, SqlType.IDENTITY_ON);
            if (ops.isEmpty()) {
                setting.setSetupSql(selectCountSql);
                setting.setFinalizeSql(selectCountSql);
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append(selectCountSql);
                builder.append(";\n");
                builder.append("--");
                builder.append(((SqlOperation)ops.get(0)).toString());
                builder.append(";");
                setting.setSetupSql(builder.toString());
                ops = dialect.createSqlFactoryRegistry().createSql((DbCommonObject)table, SqlType.IDENTITY_OFF);
                builder = new StringBuilder();
                builder.append(selectCountSql);
                builder.append(";\n");
                builder.append("--");
                builder.append(((SqlOperation)ops.get(0)).toString());
                builder.append(";");
                setting.setFinalizeSql(builder.toString());
            }
        } else {
            setting.setSetupSql(selectCountSql);
            setting.setFinalizeSql(selectCountSql);
        }
    }

    public String createInsertSql(Table table, Dialect dialect, TableOptions tableOptions, SqlType sqlType) {
        SqlFactoryRegistry sqlFactoryRegistry = dialect.createSqlFactoryRegistry();
        if (tableOptions != null) {
            sqlFactoryRegistry.getOption().setTableOptions(tableOptions.clone());
        }
        sqlFactoryRegistry.getOption().setDecorateSchemaName(false);
        SqlFactory factory = sqlFactoryRegistry.getSqlFactory((DbCommonObject)table, sqlType);
        List operations = factory.createSql((DbCommonObject)table);
        String sql = dialect.toTextFromSqlOperation((Collection)operations);
        return sql;
    }

    protected void setColumnDefaultValues(Table table, Dialect dialect, TableGeneratorSetting setting) {
        for (Column column : table.getColumns()) {
            ColumnGeneratorSetting colSetting = new ColumnGeneratorSetting();
            colSetting.setName(column.getName());
            colSetting.setDataType(column.getDataType());
            Object val = this.getColumnMinValue().apply((Object)column);
            colSetting.setMinValue(val != null ? "" + val : null);
            val = this.getColumnMaxValue().apply((Object)column);
            colSetting.setMaxValue(val != null ? "" + val : null);
            colSetting.setNextValue((String)this.getColumnNextValue().apply((Object)column));
            if (!CommonUtils.isEmpty((Collection)column.getValues())) {
                List vals = CommonUtils.list();
                vals.addAll(column.getValues());
                colSetting.setValues(vals);
            }
            setting.addColumn(colSetting);
        }
    }

    protected void setQueryDefaultValue(Table table, Dialect dialect, TableGeneratorSetting setting) {
        QueryGeneratorSetting query = new QueryGeneratorSetting();
        query.setGenerationGroup("Group1");
        query.setSelectSql(this.getSampleQuerySql(table, dialect));
        setting.addQueryDefinition(query);
    }

    protected String getSampleQuerySql(Table table, Dialect dialect) {
        int i = 0;
        AbstractSqlBuilder sqlBuilder = dialect.createSqlBuilder();
        sqlBuilder.select();
        sqlBuilder.appendIndent(1);
        for (Column column : table.getColumns()) {
            Object val = column.getDataType().getDefaultValue();
            if (val == null) continue;
            sqlBuilder.lineBreak();
            sqlBuilder.comma(i > 0);
            if ("".equals(val)) {
                sqlBuilder._add("''");
            } else if (column.getDataType().isNumeric()) {
                sqlBuilder._add(Converters.getDefault().convertString(val));
            } else {
                sqlBuilder._add("'" + Converters.getDefault().convertString(val) + "'");
            }
            sqlBuilder.as().space();
            sqlBuilder.name(column.getName());
            ++i;
        }
        sqlBuilder.appendIndent(-1);
        if (dialect.getSelectDummyTableName() != null) {
            sqlBuilder.lineBreak();
            sqlBuilder._fromSysDummy();
        }
        return sqlBuilder.toString();
    }

    protected AbstractSqlBuilder<?> createSqlBuilder(Dialect dialect) {
        AbstractSqlBuilder sqlBuilder = dialect.createSqlBuilder();
        sqlBuilder.setWithSchemaName(this.withSchemaName);
        return sqlBuilder;
    }

    protected String getStartValueQuerySql(Table table, Dialect dialect) {
        int i = 0;
        AbstractSqlBuilder<?> sqlBuilder = this.createSqlBuilder(dialect);
        sqlBuilder.select();
        sqlBuilder.appendIndent(1);
        for (Column column : table.getColumns()) {
            String exp = this.columnStartValue.apply(column, dialect);
            if (exp == null) continue;
            sqlBuilder.lineBreak();
            sqlBuilder.comma(i > 0);
            sqlBuilder._add(exp);
            ++i;
        }
        if (i == 0) {
            return null;
        }
        sqlBuilder.appendIndent(-1);
        sqlBuilder.lineBreak();
        sqlBuilder.from();
        sqlBuilder.name((AbstractSchemaObject)table);
        return sqlBuilder.toString();
    }

    @Generated
    public ColumnFunction<String> getColumnMinValue() {
        return this.columnMinValue;
    }

    @Generated
    public ColumnFunction<String> getColumnNextValue() {
        return this.columnNextValue;
    }

    @Generated
    public ColumnFunction<String> getColumnMaxValue() {
        return this.columnMaxValue;
    }

    @Generated
    public BiFunction<Column, Dialect, String> getColumnStartValue() {
        return this.columnStartValue;
    }

    @Generated
    public boolean isWithSchemaName() {
        return this.withSchemaName;
    }

    @Generated
    public void setColumnMinValue(ColumnFunction<String> columnMinValue) {
        this.columnMinValue = columnMinValue;
    }

    @Generated
    public void setColumnNextValue(ColumnFunction<String> columnNextValue) {
        this.columnNextValue = columnNextValue;
    }

    @Generated
    public void setColumnMaxValue(ColumnFunction<String> columnMaxValue) {
        this.columnMaxValue = columnMaxValue;
    }

    @Generated
    public void setColumnStartValue(BiFunction<Column, Dialect, String> columnStartValue) {
        this.columnStartValue = columnStartValue;
    }

    @Generated
    public void setWithSchemaName(boolean withSchemaName) {
        this.withSchemaName = withSchemaName;
    }
}

