/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.html.CustomParserContextFactory;
import com.sqlapp.data.db.command.html.HighlightMethod;
import com.sqlapp.data.db.command.html.HtmlUtils;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import java.util.Date;
import java.util.Set;
import org.mvel2.ParserContext;

public class RenderOptions {
    private String cdnScheme = "https:";
    private String tableClass = "outline-header border box-header outline";
    private ParserContext parserContext = new CustomParserContextFactory().getParserContext();
    private HighlightMethod highlightMethod = HighlightMethod.Prism;
    private String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private String checkIconValue = "<span class=\"icon icon-16 icon-check-sign\"/>";
    private String cssFrameworkPath = "//cdnjs.cloudflare.com/ajax/libs/cascade-framework/1.5.0/css/build-full.min.css";
    private boolean withJquery = true;
    private boolean withRows = true;
    private String[] hideColumns = new String[]{SchemaProperties.REMARKS.getLabel(), SchemaProperties.DISPLAY_REMARKS.getLabel(), SchemaProperties.SPECIFICS.getLabel(), SchemaProperties.STATISTICS.getLabel(), SchemaProperties.CREATED_AT.getLabel(), SchemaProperties.LAST_ALTERED_AT.getLabel()};
    private Set<String> hideColumnsSet = null;

    public String formatDateTime(Object obj) {
        if (obj == null) {
            return "";
        }
        return DateUtils.format((Date)((Date)obj), (String)this.dateTimeFormat);
    }

    public String checkIcon(Object obj) {
        if (obj == null) {
            return "";
        }
        Boolean bool = (Boolean)Converters.getDefault().convertObject(obj, Boolean.class);
        if (bool != null && bool.booleanValue()) {
            return this.checkIconValue;
        }
        return "";
    }

    public String tableHeaderColAttr(String ... args) {
        return this.tableBodyColAttr(args);
    }

    public String tableBodyColAttr(String ... args) {
        StringBuilder builder = new StringBuilder();
        StringBuilder childBuilder = new StringBuilder();
        for (String arg : args) {
            childBuilder.append("_col_" + this.convertName(arg) + "_");
            childBuilder.append(' ');
        }
        builder.append(HtmlUtils.attr("class", childBuilder.substring(0, childBuilder.length() - 1)));
        if (this.isHideTarget(args)) {
            builder.append(" ");
            builder.append(HtmlUtils.attr("style", "display: none;"));
        }
        return builder.toString();
    }

    private boolean isHideTarget(String ... args) {
        for (String arg : args) {
            if (!this.getHideColumnsSet().contains(arg)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getHideColumnsSet() {
        if (this.hideColumnsSet == null) {
            this.hideColumnsSet = CommonUtils.lowerSet();
            for (String arg : this.hideColumns) {
                this.hideColumnsSet.add(arg);
            }
        }
        return this.hideColumnsSet;
    }

    private String convertName(String name) {
        if ("#".equals(name)) {
            return "sharp";
        }
        return name.replace(" ", "");
    }

    public String getLanguage(Object obj) {
        return this.getHighlightMethod().getLanguage(obj);
    }

    public String[] getHighlightJs() {
        return this.getHighlightMethod().getJs();
    }

    public String[] getHighlightCss() {
        return this.getHighlightMethod().getCss();
    }

    public String getHighlightPreClass() {
        return this.getHighlightMethod().getPreClass();
    }

    public String loadInitScript() {
        return this.getHighlightMethod().loadInitScript();
    }

    public String menuIcon(String name) {
        if ("Relationships".equalsIgnoreCase(name)) {
            return "<span class=\"icon icon64 icon-sitemap\"/>";
        }
        if ("settings".equalsIgnoreCase(name)) {
            return "<span class=\"icon icon64 icon-cogs\"/>";
        }
        if ("General".equalsIgnoreCase(name)) {
            return "<span class=\"icon icon64 icon-list\"/>";
        }
        return "<span class=\"icon icon64 icon-table\"/>";
    }

    public String getCdnScheme() {
        return this.cdnScheme;
    }

    public String getTableClass() {
        return this.tableClass;
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public HighlightMethod getHighlightMethod() {
        return this.highlightMethod;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public String getCheckIconValue() {
        return this.checkIconValue;
    }

    public String getCssFrameworkPath() {
        return this.cssFrameworkPath;
    }

    public boolean isWithJquery() {
        return this.withJquery;
    }

    public boolean isWithRows() {
        return this.withRows;
    }

    public String[] getHideColumns() {
        return this.hideColumns;
    }

    public void setCdnScheme(String cdnScheme) {
        if (cdnScheme != null) {
            this.cdnScheme = cdnScheme;
        }
    }

    public void setTableClass(String tableClass) {
        if (tableClass != null) {
            this.tableClass = tableClass;
        }
    }

    public void setParserContext(ParserContext parserContext) {
        if (parserContext != null) {
            this.parserContext = parserContext;
        }
    }

    public void setHighlightMethod(HighlightMethod highlightMethod) {
        if (highlightMethod != null) {
            this.highlightMethod = highlightMethod;
        }
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        if (dateTimeFormat != null) {
            this.dateTimeFormat = dateTimeFormat;
        }
    }

    public void setCheckIconValue(String checkIconValue) {
        if (checkIconValue != null) {
            this.checkIconValue = checkIconValue;
        }
    }

    public void setCssFrameworkPath(String cssFrameworkPath) {
        if (cssFrameworkPath != null) {
            this.cssFrameworkPath = cssFrameworkPath;
        }
    }

    public void setWithJquery(boolean withJquery) {
        this.withJquery = withJquery;
    }

    public void setWithRows(boolean withRows) {
        this.withRows = withRows;
    }

    public void setHideColumns(String ... hideColumns) {
        if (hideColumns != null) {
            this.hideColumns = hideColumns;
        }
    }
}

