/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.data.db.command.OutputFormatType;
import com.sqlapp.data.db.command.generator.MultiTableFoundException;
import com.sqlapp.data.db.command.generator.TableNotFoundException;
import com.sqlapp.data.db.command.generator.factory.TableGeneratorSettingFactory;
import com.sqlapp.data.db.command.generator.setting.ColumnGeneratorSetting;
import com.sqlapp.data.db.command.generator.setting.TableGeneratorSetting;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.sql.JdbcBatchUpdateHandler;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.eval.CachedEvaluator;
import com.sqlapp.util.eval.mvel.CachedMvelEvaluator;
import com.sqlapp.util.eval.mvel.ParserContextFactory;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.mvel2.ParserContext;

public class GenerateDataInsertCommand
extends AbstractDataSourceCommand {
    private String schemaName;
    private String tableName;
    private File settingDirectory = new File("./");
    private long queryCommitInterval = Long.MAX_VALUE;
    private CachedEvaluator evaluator = new CachedMvelEvaluator();
    private TableOptions tableOptions = new TableOptions();
    private TableGeneratorSettingFactory generatorSettingFactory = new TableGeneratorSettingFactory();
    private static final String LOG_SEPARATOR_START = "<<====== ";
    private static final String LOG_SEPARATOR_END = " ======>>";
    private static final String MESSAGE_SEPARATOR_START = "<- ";
    private static final String MESSAGE_SEPARATOR_END = " ->";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        Map<String, TableGeneratorSetting> tableSettings;
        if (this.evaluator == null) {
            CachedMvelEvaluator ceval = new CachedMvelEvaluator();
            ParserContext mvelParserContext = ParserContextFactory.getInstance().getParserContext();
            ceval.setParserContext(mvelParserContext);
            this.evaluator = ceval;
        }
        try {
            tableSettings = this.readSetting();
        }
        catch (IOException | EncryptedDocumentException | InvalidFormatException e) {
            throw new RuntimeException(e);
        }
        if (tableSettings.isEmpty()) {
            this.info((Object)("File not found. settingDirectory" + this.settingDirectory.getAbsolutePath()));
            return;
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
            Dialect dialect = this.getDialect(connection);
            CatalogReader catalogReader = dialect.getCatalogReader();
            TableReader tableReader = catalogReader.getSchemaReader().getTableReader();
            tableReader.setSchemaName(this.getSchemaName());
            tableReader.setObjectName(this.getTableName());
            List tableList = tableReader.getAllFull(connection);
            if (tableList.isEmpty()) {
                throw new TableNotFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName());
            }
            if (tableList.isEmpty()) {
                throw new MultiTableFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", tableSize=" + tableList.size());
            }
            for (Table table : tableList) {
                TableGeneratorSetting tableSetting = tableSettings.get(table.getName());
                if (tableSetting == null) continue;
                connection.setAutoCommit(false);
                tableSetting.loadData(connection);
                tableSetting.setEvaluator(this.evaluator);
                tableSetting.calculateInitialObejectValues();
                this.applyFromFileByRow(connection, dialect, table, tableSetting);
                tableSettings.remove(table.getName());
                connection.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    private void setSelectStartValueSql(Dialect dialect, Connection connection, TableGeneratorSetting tableSetting) throws SQLException {
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        SqlSplitter sqlSplitter = dialect.createSqlSplitter();
        List sqls = sqlSplitter.parse(tableSetting.getStartValueSql());
        for (SqlSplitter.SplitResult splitResult : sqls) {
            if (!splitResult.getTextType().isComment()) {
                this.debug((Object)splitResult.getText());
            }
            Statement statement = connection.createStatement(1003, 1007);
            try {
                ResultSet resultSet = statement.executeQuery(splitResult.getText());
                try {
                    Table table = new Table();
                    table.readData(resultSet);
                    for (int i = 0; i < table.getColumns().size(); ++i) {
                        Object val;
                        ColumnGeneratorSetting colSet = tableSetting.getColumns().get(((Column)table.getColumns().get(i)).getName());
                        if (colSet == null || (val = resultSet.getObject(i + 1)) == null) continue;
                        Object valForType = colSet.getMaxValueObject() != null ? colSet.getMaxValueObject() : colSet.getStartValueObject();
                        Object valConverted = valForType != null ? Converters.getDefault().convertObject(val, valForType.getClass()) : val;
                        colSet.setStartValueObject(valConverted);
                    }
                }
                finally {
                    if (resultSet == null) continue;
                    resultSet.close();
                }
            }
            finally {
                if (statement == null) continue;
                statement.close();
            }
        }
    }

    protected void applyFromFileByRow(Connection connection, Dialect dialect, Table table, TableGeneratorSetting tableSetting) throws Exception {
        List splitResults;
        long start = System.currentTimeMillis();
        long total = tableSetting.getNumberOfRows();
        LocalDateTime startLocalTime = LocalDateTime.now();
        int batchSize = (Integer)this.getTableOptions().getDmlBatchSize().apply((Object)table);
        this.info(LOG_SEPARATOR_START, table.getName(), " insert start. numberOfRows=[" + total + "]. batchSize=[", batchSize, "]. start=[", startLocalTime, "].", LOG_SEPARATOR_END);
        this.setSelectStartValueSql(dialect, connection, tableSetting);
        if (!CommonUtils.isBlank((CharSequence)tableSetting.getSetupSql())) {
            this.executeSql(connection, dialect, table, "start", tableSetting.getSetupSql());
        }
        SqlSplitter splitter = dialect.createSqlSplitter();
        if (CommonUtils.isBlank((CharSequence)tableSetting.getInsertSql())) {
            String insertSql = this.getGeneratorSettingFactory().createInsertSql(table, dialect, this.getTableOptions(), SqlType.INSERT);
            splitResults = splitter.parse(insertSql);
        } else {
            splitResults = splitter.parse(tableSetting.getInsertSql());
        }
        long queryCount = 0L;
        List batchRows = CommonUtils.list((int)batchSize);
        SqlConverter sqlConverter = this.getSqlConverter();
        try {
            int batchRowSize;
            List handlers = splitResults.stream().map(c -> {
                ParametersContext context = new ParametersContext();
                context.putAll(this.getContext());
                if (c.getTextType().isComment() || CommonUtils.isBlank((CharSequence)c.getText())) {
                    return null;
                }
                SqlNode sqlNode = sqlConverter.parseSql(context, c.getText());
                this.debug((Object)sqlNode);
                JdbcBatchUpdateHandler jdbcHandler = new JdbcBatchUpdateHandler(sqlNode);
                jdbcHandler.setDialect(dialect);
                return jdbcHandler;
            }).filter(c -> c != null).collect(Collectors.toList());
            long oneper = total / 100L;
            long pointTime1 = System.currentTimeMillis();
            for (long i = 0L; i < total; ++i) {
                Map<String, Object> vals = tableSetting.generateValue(i);
                ParametersContext context = this.convertDataType(vals, table);
                context.putAll(this.getContext());
                batchRows.add(context);
                batchRowSize = batchRows.size();
                if ((i + 1L) % oneper == 0L) {
                    long pointTime2 = System.currentTimeMillis();
                    this.info(String.format("%3s", (i + 1L) / oneper), "% insert completed.[", String.format("%3s", i + 1L), "/", total, "]. [", pointTime2 - pointTime1, " ms]");
                    pointTime1 = pointTime2;
                }
                if (batchRowSize < batchSize) continue;
                long pointTime3 = System.currentTimeMillis();
                for (JdbcBatchUpdateHandler jdbcHandler : handlers) {
                    jdbcHandler.execute(connection, (Object)batchRows);
                    long pointTime4 = System.currentTimeMillis();
                    this.debug("execute query batch size=[", batchRowSize, "]. [", pointTime4 - pointTime3, " ms]");
                    queryCount = this.commit(connection, queryCount);
                    pointTime1 = pointTime4;
                }
                batchRows.clear();
            }
            batchRowSize = batchRows.size();
            if (batchRowSize > 0) {
                for (JdbcBatchUpdateHandler jdbcHandler : handlers) {
                    jdbcHandler.execute(connection, (Object)batchRows);
                }
                this.debug("execute query batch size=", batchRowSize);
                this.commit(connection);
                batchRows.clear();
            }
        }
        catch (Exception e) {
            connection.rollback();
            throw e;
        }
        finally {
            table.setRowIteratorHandler(null);
        }
        if (!CommonUtils.isBlank((CharSequence)tableSetting.getFinalizeSql())) {
            this.executeSql(connection, dialect, table, "end", tableSetting.getSetupSql());
        }
        long end = System.currentTimeMillis();
        LocalDateTime endLocalTime = LocalDateTime.now();
        this.info(LOG_SEPARATOR_START, table.getName(), " insert completed. numberOfRows=[", total, "]. start=[", startLocalTime, "]. end=[", endLocalTime, "]. [", end - start, " ms].", LOG_SEPARATOR_END);
    }

    private void executeSql(Connection connection, Dialect dialect, Table table, String type, String sql) {
        SqlSplitter sqlSplitter = dialect.createSqlSplitter();
        SqlConverter sqlConverter = this.getSqlConverter();
        long start = System.currentTimeMillis();
        LocalDateTime startLocalTime = LocalDateTime.now();
        this.info(MESSAGE_SEPARATOR_START, table.getName(), " " + type + " SQL start. start=[", startLocalTime, "].", MESSAGE_SEPARATOR_END);
        try {
            this.executeSql(sqlSplitter, sqlConverter, dialect, connection, sql);
            LocalDateTime endLocalTime = LocalDateTime.now();
            long end = System.currentTimeMillis();
            this.info(MESSAGE_SEPARATOR_START, table.getName(), " " + type + " SQL completed. end=[", endLocalTime, "]. [", end - start, " ms].", MESSAGE_SEPARATOR_END);
        }
        catch (RuntimeException e) {
            LocalDateTime endLocalTime = LocalDateTime.now();
            long end = System.currentTimeMillis();
            this.error(e, MESSAGE_SEPARATOR_START, table.getName(), " " + type + " SQL errored. end=[", endLocalTime, "]. [", end - start, " ms].", MESSAGE_SEPARATOR_END);
            throw e;
        }
    }

    private void executeSql(SqlSplitter sqlSplitter, SqlConverter sqlConverter, Dialect dialect, Connection connection, String sql) {
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        List sqls = sqlSplitter.parse(sql);
        for (SqlSplitter.SplitResult splitResult : sqls) {
            if (splitResult.getTextType().isComment()) continue;
            this.debug((Object)splitResult.getText());
            this.executeSql(sqlConverter, dialect, connection, splitResult);
        }
    }

    private void executeSql(SqlConverter sqlConverter, Dialect dialect, Connection connection, SqlSplitter.SplitResult splitResult) {
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        SqlNode sqlNode = sqlConverter.parseSql(context, splitResult.getText());
        OutputFormatType outputFormatType = OutputFormatType.TSV;
        Table table = new Table();
        table.setDialect(dialect);
        JdbcHandler jdbcHandler = dialect.createJdbcHandler(sqlNode, rs -> {
            StringBuilder builder;
            boolean first = false;
            if (table.getColumns().size() == 0) {
                table.readMetaData((ResultSet)rs);
                builder = new StringBuilder();
                for (Column column : table.getColumns()) {
                    builder.append(column.getName());
                    builder.append(outputFormatType.getSeparator());
                }
                this.info((Object)builder.substring(0, builder.length() - 1));
                first = true;
            }
            builder = new StringBuilder();
            int size = table.getColumns().size();
            for (int i = 1; i <= size; ++i) {
                Object obj = rs.getObject(i);
                Column column = (Column)table.getColumns().get(i - 1);
                String text = dialect.getValueForDisplay(column, obj);
                builder.append(text);
                builder.append(outputFormatType.getSeparator());
            }
            String text = builder.substring(0, builder.length() - 1);
            if (first) {
                this.info((Object)this.getCharText("-", 10));
            }
            this.info((Object)text);
        });
        jdbcHandler.execute(connection, context);
    }

    private String getCharText(String text, int len) {
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            builder.append(text);
        }
        return builder.toString();
    }

    private ParametersContext convertDataType(Map<String, Object> map, Table table) {
        ParametersContext context = new ParametersContext();
        context.putAll(map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Column column = (Column)table.getColumns().get(entry.getKey());
            if (column == null) continue;
            Object val = Converters.getDefault().convertObject(entry.getValue(), column.getDataType().getDefaultClass());
            context.put(entry.getKey(), val);
        }
        return context;
    }

    private Map<String, TableGeneratorSetting> readSetting() throws EncryptedDocumentException, InvalidFormatException, IOException {
        if (this.getSettingDirectory() == null) {
            return Collections.emptyMap();
        }
        File[] files = this.getSettingDirectory().listFiles();
        if (files == null) {
            return Collections.emptyMap();
        }
        Map ret = CommonUtils.caseInsensitiveMap();
        for (File file : files) {
            TableGeneratorSetting setting = this.getGeneratorSettingFactory().fromFile(file);
            if (setting == null) continue;
            ret.put(setting.getName(), setting);
        }
        return ret;
    }

    private long commit(Connection connection, long queryCount) throws SQLException {
        if (queryCount + 1L >= this.getQueryCommitInterval()) {
            this.commit(connection);
            return 0L;
        }
        return queryCount + 1L;
    }

    private void commit(Connection connection) throws SQLException {
        connection.commit();
        this.debug((Object)"commit");
    }

    protected SqlConverter getSqlConverter() {
        SqlConverter sqlConverter = new SqlConverter();
        return sqlConverter;
    }

    public void setDmlBatchSize(int batchSize) {
        this.getTableOptions().setDmlBatchSize(batchSize);
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public File getSettingDirectory() {
        return this.settingDirectory;
    }

    @Generated
    public long getQueryCommitInterval() {
        return this.queryCommitInterval;
    }

    @Generated
    public CachedEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Generated
    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    @Generated
    public TableGeneratorSettingFactory getGeneratorSettingFactory() {
        return this.generatorSettingFactory;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setSettingDirectory(File settingDirectory) {
        this.settingDirectory = settingDirectory;
    }

    @Generated
    public void setQueryCommitInterval(long queryCommitInterval) {
        this.queryCommitInterval = queryCommitInterval;
    }

    @Generated
    public void setEvaluator(CachedEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Generated
    public void setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }

    @Generated
    public void setGeneratorSettingFactory(TableGeneratorSettingFactory generatorSettingFactory) {
        this.generatorSettingFactory = generatorSettingFactory;
    }
}

