/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator.setting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.generator.setting.ColumnGeneratorSetting;
import com.sqlapp.data.db.command.generator.setting.QueryGeneratorSetting;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.exceptions.ExpressionExecutionException;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.eval.CachedEvaluator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class TableGeneratorSetting {
    private String name;
    private long numberOfRows;
    private String startValueSql;
    private String setupSql;
    private String insertSql;
    private String finalizeSql;
    private Map<String, ColumnGeneratorSetting> columns = CommonUtils.caseInsensitiveLinkedMap();
    private Map<String, QueryGeneratorSetting> querys = new LinkedHashMap<String, QueryGeneratorSetting>();
    @JsonIgnore
    private CachedEvaluator evaluator;
    @JsonIgnore
    public static final String START_KEY = "_start";
    @JsonIgnore
    public static final String MAX_KEY = "_max";
    @JsonIgnore
    public static final String INDEX_KEY = "_index";
    @JsonIgnore
    public static final String PREVIOUS_KEY = "_previous";
    @JsonIgnore
    private final ParametersContext startValues = new ParametersContext();
    @JsonIgnore
    private final ParametersContext maxValues = new ParametersContext();
    @JsonIgnore
    private Map<String, Object> previousValues = Collections.emptyMap();

    public void addColumn(ColumnGeneratorSetting col) {
        this.columns.put(col.getName(), col);
    }

    public void addQueryDefinition(QueryGeneratorSetting obj) {
        this.querys.put(obj.getGenerationGroup(), obj);
    }

    public void check() {
        this.columns.entrySet().forEach(entry -> {
            String genGroup = ((ColumnGeneratorSetting)entry.getValue()).getGenerationGroup();
            if (!CommonUtils.isEmpty((CharSequence)genGroup)) {
                QueryGeneratorSetting queryDef = this.querys.get(genGroup);
                ((ColumnGeneratorSetting)entry.getValue()).setQueryGeneratorSetting(queryDef);
            }
        });
    }

    public synchronized void calculateInitialObejectValues() {
        int i = 0;
        for (Map.Entry<String, ColumnGeneratorSetting> entry : this.columns.entrySet()) {
            ColumnGeneratorSetting colSetting = entry.getValue();
            String expression = colSetting.getStartValue();
            ++i;
            if (CommonUtils.isEmpty((CharSequence)expression)) continue;
            try {
                Object value = this.evaluator.getEvalExecutor(expression).eval(Collections.emptyMap());
                colSetting.setStartValueObject(value);
                this.startValues.put(colSetting.getName(), value);
            }
            catch (RuntimeException e) {
                throw new ExpressionExecutionException("Column Start Value expression is invalid. column=[F" + i + "]", (Throwable)e);
            }
        }
        this.startValues.remove((Object)"_countSql");
        Map map = CommonUtils.map();
        map.put(START_KEY, this.startValues);
        i = 0;
        for (Map.Entry<String, ColumnGeneratorSetting> entry : this.columns.entrySet()) {
            ColumnGeneratorSetting colSetting = entry.getValue();
            String expression = colSetting.getMaxValue();
            ++i;
            if (CommonUtils.isEmpty((CharSequence)expression)) continue;
            try {
                Object value = this.evaluator.getEvalExecutor(expression).eval((Object)map);
                colSetting.setMaxValueObject(value);
                this.maxValues.put(colSetting.getName(), value);
            }
            catch (RuntimeException e) {
                throw new ExpressionExecutionException("Column Max Value expression is invalid. column=[G" + i + "]", (Throwable)e);
            }
        }
        this.maxValues.remove((Object)"_countSql");
    }

    public synchronized void selectStartValues(Connection con) {
    }

    public Map<String, Object> generateValue(long index) {
        Map map = CommonUtils.linkedMap();
        map.put(INDEX_KEY, index);
        this.previousValues.remove(PREVIOUS_KEY);
        this.previousValues.remove(START_KEY);
        this.previousValues.remove(MAX_KEY);
        map.put(PREVIOUS_KEY, this.previousValues);
        map.put(START_KEY, this.startValues);
        map.put(MAX_KEY, this.maxValues);
        int intIndex = (int)(index % Integer.MAX_VALUE);
        int i = 0;
        for (Map.Entry<String, ColumnGeneratorSetting> entry : this.columns.entrySet()) {
            Object value;
            ++i;
            ColumnGeneratorSetting colSetting = entry.getValue();
            if (colSetting.getQueryGeneratorSetting() != null) {
                Map<String, Object> queryValueMap = colSetting.getQueryGeneratorSetting().getValueMap(intIndex);
                map.put(colSetting.getName(), queryValueMap.get(colSetting.getName()));
                continue;
            }
            Optional<Object> op = colSetting.getValue(intIndex);
            if (op.isPresent()) {
                map.put(colSetting.getName(), op.get());
                continue;
            }
            if (index == 0L || CommonUtils.isEmpty((CharSequence)colSetting.getNextValue())) {
                map.put(colSetting.getName(), colSetting.getStartValueObject());
                continue;
            }
            String expression = colSetting.getNextValue();
            try {
                value = this.evaluator.getEvalExecutor(expression).eval((Object)map);
            }
            catch (RuntimeException e) {
                throw new ExpressionExecutionException("Column expression is invalid. column=[H" + i + "]", (Throwable)e);
            }
            if (colSetting.getMaxValueObject() != null) {
                int comp = this.compare(colSetting.getMaxValueObject(), value);
                if (comp > 0) {
                    map.put(colSetting.getName(), value);
                    continue;
                }
                map.put(colSetting.getName(), colSetting.getStartValueObject());
                continue;
            }
            map.put(colSetting.getName(), value);
        }
        this.previousValues = map;
        return map;
    }

    private int compare(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass().equals(o2.getClass()) && o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        Object o2conv = Converters.getDefault().convertObject(o2, o1.getClass());
        return ((Comparable)o1).compareTo(o2conv);
    }

    public void loadData(Connection conn) throws SQLException {
        for (Map.Entry<String, QueryGeneratorSetting> entry : this.querys.entrySet()) {
            entry.getValue().loadData(conn);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    @Generated
    public String getStartValueSql() {
        return this.startValueSql;
    }

    @Generated
    public String getSetupSql() {
        return this.setupSql;
    }

    @Generated
    public String getInsertSql() {
        return this.insertSql;
    }

    @Generated
    public String getFinalizeSql() {
        return this.finalizeSql;
    }

    @Generated
    public Map<String, ColumnGeneratorSetting> getColumns() {
        return this.columns;
    }

    @Generated
    public Map<String, QueryGeneratorSetting> getQuerys() {
        return this.querys;
    }

    @Generated
    public CachedEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Generated
    public ParametersContext getStartValues() {
        return this.startValues;
    }

    @Generated
    public ParametersContext getMaxValues() {
        return this.maxValues;
    }

    @Generated
    public Map<String, Object> getPreviousValues() {
        return this.previousValues;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setNumberOfRows(long numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    @Generated
    public void setStartValueSql(String startValueSql) {
        this.startValueSql = startValueSql;
    }

    @Generated
    public void setSetupSql(String setupSql) {
        this.setupSql = setupSql;
    }

    @Generated
    public void setInsertSql(String insertSql) {
        this.insertSql = insertSql;
    }

    @Generated
    public void setFinalizeSql(String finalizeSql) {
        this.finalizeSql = finalizeSql;
    }

    @Generated
    public void setColumns(Map<String, ColumnGeneratorSetting> columns) {
        this.columns = columns;
    }

    @Generated
    public void setQuerys(Map<String, QueryGeneratorSetting> querys) {
        this.querys = querys;
    }

    @JsonIgnore
    @Generated
    public void setEvaluator(CachedEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @JsonIgnore
    @Generated
    public void setPreviousValues(Map<String, Object> previousValues) {
        this.previousValues = previousValues;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableGeneratorSetting)) {
            return false;
        }
        TableGeneratorSetting other = (TableGeneratorSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumberOfRows() != other.getNumberOfRows()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$startValueSql = this.getStartValueSql();
        String other$startValueSql = other.getStartValueSql();
        if (this$startValueSql == null ? other$startValueSql != null : !this$startValueSql.equals(other$startValueSql)) {
            return false;
        }
        String this$setupSql = this.getSetupSql();
        String other$setupSql = other.getSetupSql();
        if (this$setupSql == null ? other$setupSql != null : !this$setupSql.equals(other$setupSql)) {
            return false;
        }
        String this$insertSql = this.getInsertSql();
        String other$insertSql = other.getInsertSql();
        if (this$insertSql == null ? other$insertSql != null : !this$insertSql.equals(other$insertSql)) {
            return false;
        }
        String this$finalizeSql = this.getFinalizeSql();
        String other$finalizeSql = other.getFinalizeSql();
        if (this$finalizeSql == null ? other$finalizeSql != null : !this$finalizeSql.equals(other$finalizeSql)) {
            return false;
        }
        Map<String, ColumnGeneratorSetting> this$columns = this.getColumns();
        Map<String, ColumnGeneratorSetting> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, QueryGeneratorSetting> this$querys = this.getQuerys();
        Map<String, QueryGeneratorSetting> other$querys = other.getQuerys();
        if (this$querys == null ? other$querys != null : !((Object)this$querys).equals(other$querys)) {
            return false;
        }
        ParametersContext this$startValues = this.getStartValues();
        ParametersContext other$startValues = other.getStartValues();
        if (this$startValues == null ? other$startValues != null : !this$startValues.equals(other$startValues)) {
            return false;
        }
        ParametersContext this$maxValues = this.getMaxValues();
        ParametersContext other$maxValues = other.getMaxValues();
        if (this$maxValues == null ? other$maxValues != null : !this$maxValues.equals(other$maxValues)) {
            return false;
        }
        Map<String, Object> this$previousValues = this.getPreviousValues();
        Map<String, Object> other$previousValues = other.getPreviousValues();
        return !(this$previousValues == null ? other$previousValues != null : !((Object)this$previousValues).equals(other$previousValues));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableGeneratorSetting;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $numberOfRows = this.getNumberOfRows();
        result = result * 59 + (int)($numberOfRows >>> 32 ^ $numberOfRows);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $startValueSql = this.getStartValueSql();
        result = result * 59 + ($startValueSql == null ? 43 : $startValueSql.hashCode());
        String $setupSql = this.getSetupSql();
        result = result * 59 + ($setupSql == null ? 43 : $setupSql.hashCode());
        String $insertSql = this.getInsertSql();
        result = result * 59 + ($insertSql == null ? 43 : $insertSql.hashCode());
        String $finalizeSql = this.getFinalizeSql();
        result = result * 59 + ($finalizeSql == null ? 43 : $finalizeSql.hashCode());
        Map<String, ColumnGeneratorSetting> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, QueryGeneratorSetting> $querys = this.getQuerys();
        result = result * 59 + ($querys == null ? 43 : ((Object)$querys).hashCode());
        ParametersContext $startValues = this.getStartValues();
        result = result * 59 + ($startValues == null ? 43 : $startValues.hashCode());
        ParametersContext $maxValues = this.getMaxValues();
        result = result * 59 + ($maxValues == null ? 43 : $maxValues.hashCode());
        Map<String, Object> $previousValues = this.getPreviousValues();
        result = result * 59 + ($previousValues == null ? 43 : ((Object)$previousValues).hashCode());
        return result;
    }
}

