/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.converter.TimestampConverter;
import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.jdbc.ConnectionHandler;
import com.sqlapp.jdbc.DataSourceConnectionHandler;
import com.sqlapp.util.OutputTextBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;

public abstract class AbstractDataSourceCommand
extends AbstractCommand {
    private DataSource dataSource;
    private Dialect dialect;
    private ConnectionHandler connectionHandler = null;
    private final Converters converters = this.newConverters();

    protected Converters newConverters() {
        Converters converters = new Converters();
        TimestampConverter converter = (TimestampConverter)converters.getConverter(Timestamp.class);
        converter.getZonedDateTimeConverter().setFormat("uuuu-MM-dd HH:mm:ss");
        return converters;
    }

    protected Connection getConnection() {
        try {
            Connection connection = this.getConnectionHandler().getConnection();
            return connection;
        }
        catch (SQLException e) {
            return (Connection)this.getExceptionHandler().handle((Throwable)e);
        }
    }

    protected void releaseConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            this.getConnectionHandler().releaseConnection(connection);
        }
        catch (SQLException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    protected void rollback(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.rollback();
            this.info((Object)"rollback");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected OutputTextBuilder createOutputTextBuilder() {
        OutputTextBuilder builder = new OutputTextBuilder();
        builder.setConverters(this.converters);
        return builder;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Dialect getDialect(Connection connection) {
        this.dialect = DialectResolver.getInstance().getDialect(connection);
        return this.dialect;
    }

    protected String getCurrentCatalogName(Connection connection) throws SQLException {
        return connection.getCatalog();
    }

    protected String getCurrentSchemaName(Connection connection) throws SQLException {
        return connection.getSchema();
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public ConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            this.connectionHandler = new DataSourceConnectionHandler(this.dataSource);
        }
        return this.connectionHandler;
    }

    public void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }
}

