/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.ConsoleOutputLevel;
import com.sqlapp.data.db.command.ConvertHandler;
import com.sqlapp.data.db.command.SimpleConvertHandler;
import com.sqlapp.jdbc.function.ExceptionRunnable;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ExceptionHandler;
import com.sqlapp.util.Java8DateUtils;
import com.sqlapp.util.JsonConverter;
import com.sqlapp.util.ToRuntimeExceptionHandler;
import com.sqlapp.util.YamlConverter;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCommand
implements Runnable {
    protected static final Logger logger = LogManager.getLogger(AbstractCommand.class);
    private ExceptionHandler exceptionHandler = new ToRuntimeExceptionHandler();
    private ConvertHandler convertHandler = new SimpleConvertHandler();
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private Map<String, Object> context = CommonUtils.linkedMap();
    private Converters converters = Converters.getDefault();
    private ConsoleOutputLevel consoleOutputLevel = ConsoleOutputLevel.INFO;

    protected JsonConverter createJsonConverter() {
        JsonConverter jsonConverter = new JsonConverter();
        jsonConverter.setIndentOutput(true);
        return jsonConverter;
    }

    protected YamlConverter createYamlConverter() {
        YamlConverter jsonConverter = new YamlConverter();
        jsonConverter.setIndentOutput(true);
        return jsonConverter;
    }

    protected void execute(ExceptionRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.exceptionHandler.handle((Throwable)e);
        }
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void run() {
        this.initialize();
        this.doRun();
    }

    protected void initialize() {
        this.initializeContext();
    }

    protected void initializeContext() {
        this.context.putAll(System.getenv());
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.context.put(this.converters.convertString(k), this.converters.convertString(v))));
    }

    protected abstract void doRun();

    private PrintStream getOut() {
        return this.out;
    }

    protected void debug(Object obj) {
        if (this.getConsoleOutputLevel().compareTo(ConsoleOutputLevel.DEBUG) >= 0) {
            this.println(obj);
        }
    }

    protected void info(Object obj) {
        if (this.getConsoleOutputLevel().compareTo(ConsoleOutputLevel.INFO) >= 0) {
            this.println(obj);
        }
    }

    protected void debug(Object ... args) {
        if (this.getConsoleOutputLevel().compareTo(ConsoleOutputLevel.DEBUG) >= 0) {
            this.println(args);
        }
    }

    protected void info(Object ... args) {
        if (this.getConsoleOutputLevel().compareTo(ConsoleOutputLevel.INFO) >= 0) {
            this.println(args);
        }
    }

    protected void error(Object ... args) {
        if (this.getConsoleOutputLevel().compareTo(ConsoleOutputLevel.ERROR) >= 0) {
            this.printError(args);
        }
    }

    protected void error(Throwable t, Object ... args) {
        if (this.getConsoleOutputLevel().compareTo(ConsoleOutputLevel.ERROR) >= 0) {
            t.printStackTrace(this.getErr());
            this.printError(args);
        }
    }

    private void println(Object obj) {
        if (obj != null) {
            this.getOut().println(obj.toString());
        }
    }

    private void printError(Object obj) {
        if (obj != null) {
            this.getErr().println(obj.toString());
        }
    }

    private void println(Object ... args) {
        StringBuilder builder = new StringBuilder();
        for (Object arg : args) {
            if (arg instanceof LocalDateTime) {
                builder.append(Java8DateUtils.format((Temporal)((LocalDateTime)arg), (String)"yyyy-MM-dd HH:mm:ss"));
                continue;
            }
            builder.append(arg);
        }
        this.println((Object)builder.toString());
    }

    private void printError(Object ... args) {
        StringBuilder builder = new StringBuilder();
        for (Object arg : args) {
            if (arg instanceof LocalDateTime) {
                builder.append(Java8DateUtils.format((Temporal)((LocalDateTime)arg), (String)"yyyy-MM-dd HH:mm:ss"));
                continue;
            }
            builder.append(arg);
        }
        this.printError((Object)builder.toString());
    }

    protected PrintStream getErr() {
        return this.err;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ConsoleOutputLevel getConsoleOutputLevel() {
        return this.consoleOutputLevel;
    }

    public void setConsoleOutputLevel(ConsoleOutputLevel consoleOutputLevel) {
        this.consoleOutputLevel = consoleOutputLevel;
    }

    public ConvertHandler getConvertHandler() {
        return this.convertHandler;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setConvertHandler(ConvertHandler convertHandler) {
        this.convertHandler = convertHandler;
    }
}

