/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSchemaDataSourceCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.ObjectNameReaderPredicate;
import com.sqlapp.data.db.metadata.ReadDbObjectPredicate;
import com.sqlapp.data.db.metadata.SchemaReader;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class AbstractTableCommand
extends AbstractSchemaDataSourceCommand {
    private String[] includeSchemas = null;
    private String[] excludeSchemas = null;
    private String[] includeTables = null;
    private String[] excludeTables = null;
    private boolean onlyCurrentCatalog = true;
    private boolean onlyCurrentSchema = false;

    protected SchemaReader getSchemaReader(Connection connection, Dialect dialect) throws SQLException {
        CatalogReader catalogReader = dialect.getCatalogReader();
        SchemaReader schemaReader = catalogReader.getSchemaReader();
        if (this.isOnlyCurrentCatalog()) {
            String catalogName = this.getCurrentCatalogName(connection);
            schemaReader.setCatalogName(catalogName);
        }
        if (this.isOnlyCurrentSchema()) {
            String schemaName = this.getCurrentSchemaName(connection);
            schemaReader.setSchemaName(schemaName);
        }
        schemaReader.setReadDbObjectPredicate(this.getMetadataReaderFilter());
        return schemaReader;
    }

    protected ReadDbObjectPredicate getMetadataReaderFilter() {
        ObjectNameReaderPredicate readerFilter = new ObjectNameReaderPredicate(this.getIncludeSchemas(), this.getExcludeSchemas(), this.getIncludeTables(), this.getExcludeTables());
        return readerFilter;
    }

    public String[] getIncludeSchemas() {
        return this.includeSchemas;
    }

    public void setIncludeSchemas(String ... includeSchemas) {
        this.includeSchemas = includeSchemas;
    }

    public String[] getExcludeSchemas() {
        return this.excludeSchemas;
    }

    public void setExcludeSchemas(String ... excludeSchemas) {
        this.excludeSchemas = excludeSchemas;
    }

    public String[] getIncludeTables() {
        return this.includeTables;
    }

    public void setIncludeTables(String ... includeTables) {
        this.includeTables = includeTables;
    }

    public String[] getExcludeTables() {
        return this.excludeTables;
    }

    public void setExcludeTables(String ... excludeTables) {
        this.excludeTables = excludeTables;
    }

    public boolean isOnlyCurrentCatalog() {
        return this.onlyCurrentCatalog;
    }

    public void setOnlyCurrentCatalog(boolean onlyCurrentCatalog) {
        this.onlyCurrentCatalog = onlyCurrentCatalog;
    }

    public boolean isOnlyCurrentSchema() {
        return this.onlyCurrentSchema;
    }

    public void setOnlyCurrentSchema(boolean onlyCurrentSchema) {
        this.onlyCurrentSchema = onlyCurrentSchema;
    }
}

