/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSchemaDataSourceCommand;
import com.sqlapp.data.db.command.properties.ObjectTargetProperty;
import com.sqlapp.data.db.command.properties.OnlyCurrentCatalogProperty;
import com.sqlapp.data.db.command.properties.OnlyCurrentSchemaProperty;
import com.sqlapp.data.db.command.properties.SchemaTargetProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.ObjectNameReaderPredicate;
import com.sqlapp.data.db.metadata.ReadDbObjectPredicate;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.sql.ConnectionSqlExecutor;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class DropObjectsCommand
extends AbstractSchemaDataSourceCommand
implements SchemaTargetProperty,
ObjectTargetProperty,
OnlyCurrentCatalogProperty,
OnlyCurrentSchemaProperty {
    private String[] includeSchemas = null;
    private String[] excludeSchemas = null;
    private String[] includeObjects = null;
    private String[] excludeObjects = null;
    private boolean onlyCurrentCatalog = true;
    private boolean onlyCurrentSchema = false;
    private boolean dropObjects = false;
    private boolean dropTables = false;
    private String preDropTableSql;
    private String afterDropTableSql;

    protected SchemaReader getSchemaReader(Connection connection, Dialect dialect) throws SQLException {
        CatalogReader catalogReader = dialect.getCatalogReader();
        SchemaReader schemaReader = catalogReader.getSchemaReader();
        if (this.isOnlyCurrentCatalog()) {
            String catalogName = this.getCurrentCatalogName(connection);
            schemaReader.setCatalogName(catalogName);
        }
        if (this.isOnlyCurrentSchema()) {
            String schemaName = this.getCurrentSchemaName(connection);
            schemaReader.setSchemaName(schemaName);
        }
        schemaReader.setReadDbObjectPredicate(this.getMetadataReaderFilter());
        return schemaReader;
    }

    protected ReadDbObjectPredicate getMetadataReaderFilter() {
        ObjectNameReaderPredicate readerFilter = new ObjectNameReaderPredicate(this.getIncludeSchemas(), this.getExcludeSchemas(), this.getIncludeObjects(), this.getExcludeObjects());
        return readerFilter;
    }

    @Override
    protected void doRun() {
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            Dialect dialect = this.getDialect((Connection)connection);
            SqlFactoryRegistry sqlFactoryRegistry = dialect.createSqlFactoryRegistry();
            SchemaReader schemaReader = this.getSchemaReader((Connection)connection, dialect);
            List schemas = schemaReader.getAll(connection);
            for (Schema schema : schemas) {
                if (this.isDropObjects()) {
                    schemaReader.load(connection, schema);
                    this.dropObjects((Connection)connection, schemaReader, schema, sqlFactoryRegistry);
                }
                if (!this.isDropTables()) continue;
                if (!this.isDropObjects()) {
                    TableReader tableReader = schemaReader.getTableReader();
                    tableReader.setCatalogName(schema.getCatalogName());
                    tableReader.setSchemaName(schema.getName());
                    tableReader.loadFull(connection, schema);
                }
                this.dropTables((Connection)connection, schemaReader, schema, sqlFactoryRegistry);
            }
        }));
    }

    protected void dropObjects(Connection connection, SchemaReader schemaReader, Schema schema, SqlFactoryRegistry sqlFactoryRegistry) throws SQLException {
        this.loadDetail(connection, schemaReader, schema);
        ConnectionSqlExecutor operationExecutor = new ConnectionSqlExecutor(connection);
        for (Map.Entry entry : schema.getChildObjectCollectionMap().entrySet()) {
            if (SchemaObjectProperties.TABLES.getLabel().equals(entry.getKey())) continue;
            DbObjectCollection collection = (DbObjectCollection)entry.getValue();
            for (DbObject object : collection) {
                SqlFactory sqlFactory = sqlFactoryRegistry.getSqlFactory((DbCommonObject)object, SqlType.DROP);
                List operations = sqlFactory.createSql((DbCommonObject)object);
                operationExecutor.execute((Collection)operations);
            }
        }
    }

    protected void loadDetail(Connection connection, SchemaReader schemaReader, Schema schema) throws SQLException {
        schemaReader.load(connection, schema);
    }

    protected void dropTables(Connection connection, SchemaReader schemaReader, Schema schema, SqlFactoryRegistry sqlFactoryRegistry) throws SQLException {
        ConnectionSqlExecutor sqlExecutor = new ConnectionSqlExecutor(connection);
        if (!CommonUtils.isEmpty((CharSequence)this.getPreDropTableSql())) {
            try (Statement statement = connection.createStatement();){
                statement.executeQuery(this.getPreDropTableSql());
            }
        }
        SqlFactory sqlFactory = sqlFactoryRegistry.getSqlFactory((DbCommonObject)new Table(), SqlType.DROP);
        List operations = sqlFactory.createSql((Collection)schema.getTables());
        sqlExecutor.execute((Collection)operations);
        if (!CommonUtils.isEmpty((CharSequence)this.getAfterDropTableSql())) {
            try (Statement statement = connection.createStatement();){
                statement.executeQuery(this.getAfterDropTableSql());
            }
        }
    }

    @Override
    public void setIncludeSchemas(String ... includeSchemas) {
        this.includeSchemas = includeSchemas;
    }

    @Override
    public void setExcludeSchemas(String ... excludeSchemas) {
        this.excludeSchemas = excludeSchemas;
    }

    @Override
    public void setIncludeObjects(String ... includeObject) {
        this.includeObjects = includeObject;
    }

    @Override
    public void setExcludeObjects(String ... excludeObjects) {
        this.excludeObjects = excludeObjects;
    }

    @Override
    @Generated
    public String[] getIncludeSchemas() {
        return this.includeSchemas;
    }

    @Override
    @Generated
    public String[] getExcludeSchemas() {
        return this.excludeSchemas;
    }

    @Override
    @Generated
    public String[] getIncludeObjects() {
        return this.includeObjects;
    }

    @Override
    @Generated
    public String[] getExcludeObjects() {
        return this.excludeObjects;
    }

    @Override
    @Generated
    public boolean isOnlyCurrentCatalog() {
        return this.onlyCurrentCatalog;
    }

    @Override
    @Generated
    public boolean isOnlyCurrentSchema() {
        return this.onlyCurrentSchema;
    }

    @Generated
    public boolean isDropObjects() {
        return this.dropObjects;
    }

    @Generated
    public boolean isDropTables() {
        return this.dropTables;
    }

    @Generated
    public String getPreDropTableSql() {
        return this.preDropTableSql;
    }

    @Generated
    public String getAfterDropTableSql() {
        return this.afterDropTableSql;
    }

    @Override
    @Generated
    public void setOnlyCurrentCatalog(boolean onlyCurrentCatalog) {
        this.onlyCurrentCatalog = onlyCurrentCatalog;
    }

    @Override
    @Generated
    public void setOnlyCurrentSchema(boolean onlyCurrentSchema) {
        this.onlyCurrentSchema = onlyCurrentSchema;
    }

    @Generated
    public void setDropObjects(boolean dropObjects) {
        this.dropObjects = dropObjects;
    }

    @Generated
    public void setDropTables(boolean dropTables) {
        this.dropTables = dropTables;
    }

    @Generated
    public void setPreDropTableSql(String preDropTableSql) {
        this.preDropTableSql = preDropTableSql;
    }

    @Generated
    public void setAfterDropTableSql(String afterDropTableSql) {
        this.afterDropTableSql = afterDropTableSql;
    }
}

