/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.properties.EqualsHandlerProperty;
import com.sqlapp.data.db.command.properties.SchemaOptionProperty;
import com.sqlapp.data.db.command.properties.SqlFactoryRegistryProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.DefaultSchemaEqualsHandler;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.State;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import lombok.Generated;

public class GenerateDiffSqlCommand
extends AbstractCommand
implements SchemaOptionProperty,
EqualsHandlerProperty,
SqlFactoryRegistryProperty {
    private DbCommonObject<?> original;
    private DbCommonObject<?> target;
    private EqualsHandler equalsHandler = new DefaultSchemaEqualsHandler();
    private SqlFactoryRegistry sqlFactoryRegistry;
    private List<SqlOperation> sqlOperations = CommonUtils.list();
    private Options schemaOptions = new Options();

    @Override
    protected void doRun() {
        this.sqlOperations = CommonUtils.list();
        if (this.getTarget() instanceof DbObject) {
            DbObject original = (DbObject)this.getOriginal();
            DbObject target = (DbObject)this.getTarget();
            DbObjectDifference difference = original.diff(target, this.getEqualsHandler());
            SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry((DbCommonObject<?>)target);
            if (this.getSchemaOptions() != null) {
                sqlFactoryRegistry.setOption(this.getSchemaOptions());
            }
            SqlFactory<?> sqlFactory = this.getOperationFactory(sqlFactoryRegistry, difference);
            this.sqlOperations.addAll(sqlFactory.createDiffSql(difference));
        } else {
            SqlFactory<?> sqlFactory;
            DbObjectCollection original = (DbObjectCollection)this.getOriginal();
            DbObjectCollection target = (DbObjectCollection)this.getTarget();
            DbObjectDifferenceCollection differences = original.diff(target, this.getEqualsHandler());
            SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry((DbCommonObject<?>)target);
            if (this.getSchemaOptions() != null) {
                sqlFactoryRegistry.setOption(this.getSchemaOptions());
            }
            for (DbObjectDifference difference : differences.getList(new State[]{State.Deleted})) {
                sqlFactory = this.getOperationFactory(sqlFactoryRegistry, difference);
                this.sqlOperations.addAll(sqlFactory.createDiffSql(difference));
            }
            for (DbObjectDifference difference : differences.getList(new State[]{State.Added, State.Modified})) {
                sqlFactory = this.getOperationFactory(sqlFactoryRegistry, difference);
                this.sqlOperations.addAll(sqlFactory.createDiffSql(difference));
            }
        }
    }

    private SqlFactoryRegistry getSqlFactoryRegistry(DbCommonObject<?> target) {
        SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry();
        if (sqlFactoryRegistry == null) {
            Dialect dialect = SchemaUtils.getDialect(target);
            return dialect.createSqlFactoryRegistry();
        }
        return sqlFactoryRegistry;
    }

    private SqlFactory<?> getOperationFactory(SqlFactoryRegistry sqlFactoryRegistry, DbObjectDifference difference) {
        return sqlFactoryRegistry.getSqlFactory(difference);
    }

    public void swap() {
        DbCommonObject<?> original = this.original;
        DbCommonObject<?> target = this.target;
        this.original = target;
        this.target = original;
    }

    @Generated
    public DbCommonObject<?> getOriginal() {
        return this.original;
    }

    @Generated
    public DbCommonObject<?> getTarget() {
        return this.target;
    }

    @Override
    @Generated
    public EqualsHandler getEqualsHandler() {
        return this.equalsHandler;
    }

    @Override
    @Generated
    public SqlFactoryRegistry getSqlFactoryRegistry() {
        return this.sqlFactoryRegistry;
    }

    @Generated
    public List<SqlOperation> getSqlOperations() {
        return this.sqlOperations;
    }

    @Override
    @Generated
    public Options getSchemaOptions() {
        return this.schemaOptions;
    }

    @Generated
    public void setOriginal(DbCommonObject<?> original) {
        this.original = original;
    }

    @Generated
    public void setTarget(DbCommonObject<?> target) {
        this.target = target;
    }

    @Override
    @Generated
    public void setEqualsHandler(EqualsHandler equalsHandler) {
        this.equalsHandler = equalsHandler;
    }

    @Override
    @Generated
    public void setSqlFactoryRegistry(SqlFactoryRegistry sqlFactoryRegistry) {
        this.sqlFactoryRegistry = sqlFactoryRegistry;
    }

    @Generated
    public void setSqlOperations(List<SqlOperation> sqlOperations) {
        this.sqlOperations = sqlOperations;
    }

    @Override
    @Generated
    public void setSchemaOptions(Options schemaOptions) {
        this.schemaOptions = schemaOptions;
    }
}

