/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.html.DuplicatePropertyFilesException;
import com.sqlapp.data.db.command.html.HtmlUtils;
import com.sqlapp.data.db.command.html.MenuDefinition;
import com.sqlapp.data.db.command.properties.CsvEncodingProperty;
import com.sqlapp.data.db.command.properties.TargetFileProperty;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.data.schemas.rowiterator.ExcelUtils;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.exceptions.CommandException;
import com.sqlapp.exceptions.InvalidFileTypeException;
import com.sqlapp.exceptions.InvalidPropertyException;
import com.sqlapp.util.AbstractIterator;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.JsonConverter;
import com.sqlapp.util.file.TextFileReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractSchemaFileCommand
extends AbstractCommand
implements CsvEncodingProperty,
TargetFileProperty {
    private File targetFile;
    private File dictionaryFileDirectory = new File("./");
    private String dictionaryFileType = "xml";
    private String csvEncoding = Charset.defaultCharset().toString();
    private JsonConverter jsonConverter = new JsonConverter();
    private String[] keywords = new String[]{SchemaProperties.DISPLAY_NAME.getLabel(), SchemaProperties.DISPLAY_REMARKS.getLabel()};
    private Map<String, Integer> keywordsMap = CommonUtils.map();
    private Catalog catalog = null;

    public String[] getKeywords() {
        return this.keywords;
    }

    protected AbstractSchemaFileCommand() {
        this.jsonConverter.setIndentOutput(true);
        for (int i = 0; i < this.getKeywords().length; ++i) {
            this.keywordsMap.put(this.keywords[i], i);
        }
    }

    @Override
    protected void doRun() {
        block10: {
            Catalog obj = null;
            if (this.getCatalog() == null) {
                try {
                    obj = SchemaUtils.readXml((File)this.targetFile);
                }
                catch (FileNotFoundException e) {
                    throw new CommandException("targetFile=" + this.targetFile, (Throwable)e);
                }
                catch (IOException e) {
                    throw new CommandException("targetFile=" + this.targetFile, (Throwable)e);
                }
            } else {
                obj = this.getCatalog();
            }
            try {
                if (obj instanceof Schema) {
                    this.create(((Schema)obj).toCatalog());
                    break block10;
                }
                if (obj instanceof SchemaCollection) {
                    this.create(((SchemaCollection)obj).toCatalog());
                    break block10;
                }
                if (obj instanceof Catalog) {
                    this.create(obj);
                    break block10;
                }
                throw new IllegalArgumentException("targetFile type must be a Schema or SchemaCollection or Catalog");
            }
            catch (Exception e) {
                throw new CommandException("targetFile=" + this.targetFile, (Throwable)e);
            }
        }
    }

    protected abstract void create(Catalog var1) throws Exception;

    protected String getFullName(Object obj, boolean withSchemaName) {
        String fullName = null;
        fullName = withSchemaName ? HtmlUtils.objectFullName(obj) : HtmlUtils.objectFullNameWithoutSchemaName(obj);
        return fullName;
    }

    protected String getName(Object obj) {
        String name = ((NameProperty)obj).getName();
        return name;
    }

    protected File loadProperties(MenuDefinition menuDefinition, String type, Properties properties) throws Exception {
        String filename = menuDefinition.toString().toLowerCase();
        if (CommonUtils.isEmpty((Object)this.getDictionaryFileDirectory())) {
            return null;
        }
        Object[] files = this.getDictionaryFileDirectory().listFiles((d, name) -> name.startsWith(filename + "."));
        if (CommonUtils.isEmpty((Object)files)) {
            return null;
        }
        if (files.length > 1) {
            throw new DuplicatePropertyFilesException((File[])files);
        }
        File file = (File)CommonUtils.first((Object[])files);
        if (file.exists()) {
            try (FileInputStream is = new FileInputStream(file);){
                if (file.getAbsolutePath().endsWith(".properties")) {
                    properties.load(is);
                } else if (file.getAbsolutePath().endsWith(".xml")) {
                    properties.loadFromXML(is);
                } else {
                    this.readOtherFiles(file, is, properties);
                }
            }
            List<MenuDefinition> menuDefinitions = menuDefinition.getNest();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                int current = entry.getKey().toString().split("\\.").length;
                if (current <= menuDefinitions.size() + 2) continue;
                throw new InvalidPropertyException(entry.getKey().toString(), entry.getValue());
            }
        }
        return file;
    }

    private void readOtherFiles(File file, InputStream is, Properties properties) throws Exception {
        WorkbookFileType workbookFileType = WorkbookFileType.parse((File)file);
        if (workbookFileType.isTextFile() && workbookFileType.isCsv()) {
            this.readCsvFile(workbookFileType, file, is, properties);
        } else if (workbookFileType.isWorkbook()) {
            this.readWorkbookFile(workbookFileType, file, is, properties);
        } else if (workbookFileType.isJson()) {
            this.readJsonFile(workbookFileType, file, is, properties);
        } else {
            throw new InvalidFileTypeException(file);
        }
    }

    private void readWorkbookFile(WorkbookFileType workbookFileType, File file, InputStream is, Properties properties) throws UnsupportedEncodingException, IOException, EncryptedDocumentException, InvalidFormatException {
        Workbook workbook = WorkbookFileType.parse((File)file).createWorkBook(is);
        int numberOdSheets = workbook.getNumberOfSheets();
        for (int sheetNo = 0; sheetNo < numberOdSheets; ++sheetNo) {
            int i;
            Sheet sheet = workbook.getSheetAt(sheetNo);
            int rowIndex = sheet.getFirstRowNum();
            Row row = sheet.getRow(rowIndex);
            int lastRowNum = sheet.getLastRowNum();
            short lastCellNum = row.getLastCellNum();
            String[] headers = new String[lastCellNum + 1];
            MenuDefinition[] headerDefs = new MenuDefinition[headers.length];
            int keywordCount = 0;
            for (i = 0; i < headers.length; ++i) {
                String header = ExcelUtils.getStringCellValue((Cell)row.getCell(i));
                if (header == null) continue;
                MenuDefinition def = MenuDefinition.parse(header);
                if (def != null) {
                    headerDefs[i] = def;
                    headers[i] = def.toString();
                    continue;
                }
                headers[i] = this.getKeywords()[keywordCount++];
            }
            for (i = rowIndex + 1; i <= lastRowNum; ++i) {
                StringBuilder builder = new StringBuilder();
                row = sheet.getRow(i);
                for (int j = 0; j < headers.length; ++j) {
                    MenuDefinition headerDef;
                    String value = ExcelUtils.getStringCellValue((Cell)row.getCell(j));
                    if (value == null) {
                        value = "";
                    }
                    if ((headerDef = headerDefs[j]) != null) {
                        if (CommonUtils.isEmpty((CharSequence)value)) continue;
                        builder.append(value);
                        builder.append(".");
                        continue;
                    }
                    String header = headers[j];
                    if (header == null) continue;
                    properties.put(builder.toString() + header, value);
                }
            }
        }
    }

    private void readCsvFile(WorkbookFileType workbookFileType, File file, InputStream is, Properties properties) throws UnsupportedEncodingException, IOException {
        try (InputStreamReader reader = new InputStreamReader(is, this.getCsvEncoding());){
            BufferedReader br = new BufferedReader(reader);
            TextFileReader csvListReader = workbookFileType.createCsvListReader((Reader)br);
            String[] headers = csvListReader.read();
            MenuDefinition[] headerDefs = new MenuDefinition[headers.length];
            int keywordCount = 0;
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                if (header == null) continue;
                MenuDefinition def = MenuDefinition.parse(header);
                if (def != null) {
                    headerDefs[i] = def;
                    headers[i] = def.toString();
                    continue;
                }
                headers[i] = this.getKeywords()[keywordCount++];
            }
            Object[] list = csvListReader.read();
            while (list != null) {
                list = csvListReader.read();
                String text = (String)CommonUtils.first((Object[])list);
                if (CommonUtils.isEmpty((CharSequence)text) || text.startsWith("#")) continue;
                for (int i = 0; i < list.length; ++i) {
                    StringBuilder builder = new StringBuilder();
                    Object value = list[i];
                    if (value == null) {
                        value = "";
                    }
                    if (i >= headers.length) continue;
                    MenuDefinition headerDef = headerDefs[i];
                    if (headerDef != null) {
                        if (CommonUtils.isEmpty((CharSequence)value)) continue;
                        builder.append((String)value);
                        builder.append(".");
                        continue;
                    }
                    String header = headers[i];
                    if (header == null) continue;
                    properties.put(builder.toString() + header, value);
                }
            }
        }
    }

    private void readJsonFile(WorkbookFileType workbookFileType, File file, InputStream is, final Properties properties) throws Exception {
        Object obj = this.getJsonConverter().fromJsonString(is, Object.class);
        if (obj instanceof Collection || obj.getClass().isArray()) {
            AbstractIterator<Object> itr = new AbstractIterator<Object>(){

                protected void handle(Object obj, int index) throws Exception {
                    if (obj instanceof Map) {
                        Map<String, String> map = AbstractSchemaFileCommand.this.toStringMap((Map)obj);
                        properties.putAll(map);
                    }
                }
            };
            itr.execute(obj);
        } else {
            Map<String, String> map = this.toStringMap((Map)obj);
            properties.putAll(map);
        }
    }

    private Map<String, String> toStringMap(Map map) {
        Map result = CommonUtils.linkedMap();
        String path = null;
        map.forEach((k, v) -> this.toStringList(path, k.toString(), v, result));
        return result;
    }

    private void toStringList(String path, String key, Object value, Map<String, String> result) {
        String currentPath = this.createPath(path, key);
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            result.put(currentPath, value.toString());
            return;
        }
        if (value instanceof Map) {
            ((Map)value).forEach((k, v) -> this.toStringList(currentPath, k.toString(), v, result));
        }
    }

    private String createPath(String path, String key) {
        path = CommonUtils.isEmpty((CharSequence)path) ? key : (String)path + "." + key;
        return path;
    }

    protected void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    protected Map<String, Integer> getKeywordsMap() {
        return this.keywordsMap;
    }

    @Override
    @Generated
    public File getTargetFile() {
        return this.targetFile;
    }

    @Generated
    public File getDictionaryFileDirectory() {
        return this.dictionaryFileDirectory;
    }

    @Generated
    public String getDictionaryFileType() {
        return this.dictionaryFileType;
    }

    @Override
    @Generated
    public String getCsvEncoding() {
        return this.csvEncoding;
    }

    @Generated
    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    @Override
    @Generated
    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    @Generated
    public void setDictionaryFileDirectory(File dictionaryFileDirectory) {
        this.dictionaryFileDirectory = dictionaryFileDirectory;
    }

    @Generated
    public void setDictionaryFileType(String dictionaryFileType) {
        this.dictionaryFileType = dictionaryFileType;
    }

    @Override
    @Generated
    public void setCsvEncoding(String csvEncoding) {
        this.csvEncoding = csvEncoding;
    }

    @Generated
    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    @Generated
    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    @Generated
    public void setKeywordsMap(Map<String, Integer> keywordsMap) {
        this.keywordsMap = keywordsMap;
    }
}

