/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.properties.SchemaOptionProperty;
import com.sqlapp.data.db.command.properties.SqlFactoryRegistryProperty;
import com.sqlapp.data.db.command.properties.SqlTypeProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import lombok.Generated;

public class GenerateSimpleSqlCommand
extends AbstractCommand
implements SchemaOptionProperty,
SqlTypeProperty,
SqlFactoryRegistryProperty {
    private DbCommonObject<?> target;
    private SqlFactoryRegistry sqlFactoryRegistry;
    private final List<SqlOperation> sqlOperations = CommonUtils.list();
    private SqlType sqlType = SqlType.CREATE;
    private Options schemaOptions = new Options();

    @Override
    protected void doRun() {
        this.sqlOperations.clear();
        if (this.getTarget() instanceof DbObject) {
            DbObject target = (DbObject)this.getTarget();
            SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry((DbCommonObject<?>)target);
            if (this.getSchemaOptions() != null) {
                sqlFactoryRegistry.setOption(this.getSchemaOptions());
            }
            SqlFactory<? extends DbCommonObject<?>> sqlFactory = this.getSqlFactory(sqlFactoryRegistry, target);
            this.sqlOperations.addAll(sqlFactory.createSql((DbCommonObject)target));
        } else {
            DbObjectCollection targetCollection = (DbObjectCollection)this.getTarget();
            SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry((DbCommonObject<?>)targetCollection);
            if (this.getSchemaOptions() != null) {
                sqlFactoryRegistry.setOption(this.getSchemaOptions());
            }
            for (DbObject dbObject : targetCollection) {
                SqlFactory<? extends DbCommonObject<?>> sqlFactory = this.getSqlFactory(sqlFactoryRegistry, dbObject);
                this.sqlOperations.addAll(sqlFactory.createSql((DbCommonObject)dbObject));
            }
        }
    }

    private SqlFactoryRegistry getSqlFactoryRegistry(DbCommonObject<?> target) {
        SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry();
        if (sqlFactoryRegistry == null) {
            Dialect dialect = SchemaUtils.getDialect(target);
            return dialect.createSqlFactoryRegistry();
        }
        return sqlFactoryRegistry;
    }

    protected SqlFactory<? extends DbCommonObject<?>> getSqlFactory(SqlFactoryRegistry sqlFactoryRegistry, DbObject<?> target) {
        return sqlFactoryRegistry.getSqlFactory(target, this.getSqlType());
    }

    public DbCommonObject<?> getTarget() {
        return this.target;
    }

    public void setTarget(DbCommonObject<?> target) {
        this.target = target;
    }

    @Override
    @Generated
    public SqlFactoryRegistry getSqlFactoryRegistry() {
        return this.sqlFactoryRegistry;
    }

    @Generated
    public List<SqlOperation> getSqlOperations() {
        return this.sqlOperations;
    }

    @Override
    @Generated
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Override
    @Generated
    public Options getSchemaOptions() {
        return this.schemaOptions;
    }

    @Override
    @Generated
    public void setSqlFactoryRegistry(SqlFactoryRegistry sqlFactoryRegistry) {
        this.sqlFactoryRegistry = sqlFactoryRegistry;
    }

    @Override
    @Generated
    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    @Override
    @Generated
    public void setSchemaOptions(Options schemaOptions) {
        this.schemaOptions = schemaOptions;
    }
}

