/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.db.command.html.RenderOptions;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.eval.EvalExecutor;
import com.sqlapp.util.eval.mvel.CachedMvelEvaluator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;

public class Renderer {
    private CompiledTemplate compiledTemplate = null;
    private String template;
    private RenderOptions renderOptions = new RenderOptions();
    private static Pattern INCLUDE_PATTERN = Pattern.compile("[ \\t]*<!--\\s*include\\(\\s*(?<filename>[^)]*?)\\s*\\)(?<expression>.*?)?\\s*-->[ \\t]*", 8);
    private String templateResource = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compile() {
        Renderer renderer = this;
        synchronized (renderer) {
            this.compiledTemplate = TemplateCompiler.compileTemplate((String)this.convertInclude(this.template), (ParserContext)this.renderOptions.getParserContext());
        }
    }

    protected String convertInclude(String value) {
        String converted = value;
        converted = this.convertIncludeInternal(converted);
        Matcher matcher;
        while ((matcher = INCLUDE_PATTERN.matcher(converted)).find()) {
            converted = this.convertIncludeInternal(converted);
        }
        return converted;
    }

    protected String convertIncludeInternal(String value) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = INCLUDE_PATTERN.matcher(value);
        int pos = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String filename = matcher.group("filename");
            String text = this.readResource(filename);
            text = this.convertExpression(text, matcher.group("expression"));
            String sub = value.substring(pos, start);
            builder.append(sub);
            builder.append(text);
            pos = end;
        }
        if (builder.length() == 0) {
            return value;
        }
        if (pos < value.length()) {
            String sub = value.substring(pos);
            builder.append(sub);
        }
        return builder.toString();
    }

    private String convertExpression(String text, String expression) {
        if (CommonUtils.isEmpty((CharSequence)(expression = CommonUtils.trim((String)expression)))) {
            return text;
        }
        EvalExecutor evalExecutor = CachedMvelEvaluator.getInstance().getEvalExecutor("text" + expression);
        ParametersContext context = new ParametersContext();
        context.put("text", (Object)text);
        return (String)evalExecutor.eval(context);
    }

    public String render(ParametersContext context) {
        this.initializeContext(context);
        return this.execute(context);
    }

    protected void initializeContext(ParametersContext context) {
    }

    private String execute(ParametersContext context) {
        if (this.compiledTemplate == null) {
            this.compile();
        }
        if (!context.containsKeyInternal((Object)"renderOptions")) {
            context.put("renderOptions", (Object)this.renderOptions);
        }
        String text = (String)TemplateRuntime.execute((CompiledTemplate)this.compiledTemplate, (Map)context);
        return text;
    }

    public void setTemplate(File file) {
        this.template = FileUtils.readText((File)file, (String)"utf8");
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    protected String readResource(String filename) {
        InputStream is = FileUtils.getInputStream(this.getClass(), (String)filename);
        String text = FileUtils.readText((InputStream)is, (String)"utf8");
        return text;
    }

    public void setTemplateResource(String filename) {
        this.templateResource = filename;
        InputStream is = FileUtils.getInputStream(this.getClass(), (String)filename);
        if (is == null) {
            throw new RuntimeException(new FileNotFoundException("filename=" + filename));
        }
        String text = FileUtils.readText((InputStream)is, (String)"utf8");
        this.setTemplate(text);
    }

    public String getTemplateResource() {
        return this.templateResource;
    }

    protected CompiledTemplate getCompiledTemplate() {
        return this.compiledTemplate;
    }

    protected String getTemplate() {
        return this.template;
    }

    public void setRenderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
    }

    protected RenderOptions getRenderOptions() {
        return this.renderOptions;
    }
}

