/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.version;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.version.DbVersionFileHandler;
import com.sqlapp.data.db.command.version.SchemaVersionFailureException;
import com.sqlapp.data.db.command.version.Status;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.sql.ConnectionSqlExecutor;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbConcurrencyException;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.OutputTextBuilder;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DbVersionHandler {
    private Converters converters = Converters.getDefault();
    private String schemaChangeLogTableName = "changelog";
    private String idColumnName = "change_number";
    private String appliedByColumnName = "applied_by";
    private String appliedAtColumnName = "applied_at";
    private String statusColumnName = "status";
    private String descriptionColumnName = "description";
    private String seriesNumberColumnName = "series_number";
    private boolean withSeriesNumber = true;
    public static final String COL_VERSION_UP_SQL = "SQL(up)";
    public static final String COL_VERSION_DOWN_SQL = "SQL(down)";
    public static final String COL_MIGRATION = "migration";
    private static final String CURRENT_VERSION_TEXT = "<= current";
    private static final String VERSION_UP_TEXT = " \u2193";
    private static final String VERSION_DOWN_TEXT = " \u2191";
    private static final String VERSION_TARGET = "<= target";
    private static final String VERSION_CURRENT_TARGET = "<= (current=target)";
    private static final String INITIAL_APPLIED_AT_TEXT = "Initial";
    private static final String NOT_APPLIED_APPLIED_AT_TEXT = "Not applied";

    public String getIdColumnName() {
        return this.idColumnName;
    }

    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName;
    }

    public String getAppliedByColumnName() {
        return this.appliedByColumnName;
    }

    public void setAppliedByColumnName(String appliedByColumnName) {
        this.appliedByColumnName = appliedByColumnName;
    }

    public String getAppliedAtColumnName() {
        return this.appliedAtColumnName;
    }

    public void setAppliedAtColumnName(String appliedAtColumnName) {
        this.appliedAtColumnName = appliedAtColumnName;
    }

    public String getStatusColumnName() {
        return this.statusColumnName;
    }

    public void setStatusColumnName(String statusColumnName) {
        this.statusColumnName = statusColumnName;
    }

    public String getDescriptionColumnName() {
        return this.descriptionColumnName;
    }

    public void setDescriptionColumnName(String descriptionColumnName) {
        this.descriptionColumnName = descriptionColumnName;
    }

    public String getSeriesNumberColumnName() {
        return this.seriesNumberColumnName;
    }

    public void setSeriesNumberColumnName(String seriesNumberColumnName) {
        this.seriesNumberColumnName = seriesNumberColumnName;
    }

    public Table createVersionTableDefinition(String name) {
        Column column;
        String fullName = name != null ? name : this.getSchemaChangeLogTableName();
        Table table = new Table();
        String[] args = fullName.split("\\.");
        int pos = args.length - 1;
        table.setName(args[pos--]);
        if (pos >= 0) {
            table.setSchemaName(args[pos--]);
        }
        Column pkColumn = column = new Column(this.getIdColumnName()).setDataType(DataType.BIGINT);
        table.getColumns().add((AbstractNamedObject)column);
        column = (Column)new Column(this.getAppliedByColumnName()).setDataType(DataType.NVARCHAR).setLength(255L);
        table.getColumns().add((AbstractNamedObject)column);
        column = new Column(this.getAppliedAtColumnName()).setDataType(DataType.DATETIME);
        table.getColumns().add((AbstractNamedObject)column);
        column = (Column)new Column(this.getStatusColumnName()).setDataType(DataType.NVARCHAR).setLength(31L);
        table.getColumns().add((AbstractNamedObject)column);
        column = (Column)new Column(this.getDescriptionColumnName()).setDataType(DataType.NVARCHAR).setLength(1023L);
        table.getColumns().add((AbstractNamedObject)column);
        if (this.isWithSeriesNumber()) {
            column = new Column(this.getSeriesNumberColumnName()).setDataType(DataType.BIGINT);
            table.getColumns().add((AbstractNamedObject)column);
        }
        table.getConstraints().addPrimaryKeyConstraint(name + "_PK", new Column[]{pkColumn});
        return table;
    }

    public void mergeSqlFiles(List<DbVersionFileHandler.SqlFile> sqlFiles, Table table) {
        Column column = new Column(COL_VERSION_UP_SQL).setDataType(DataType.INT);
        table.getColumns().add((AbstractNamedObject)column);
        column = new Column(COL_VERSION_DOWN_SQL).setDataType(DataType.INT);
        table.getColumns().add((AbstractNamedObject)column);
        column = (Column)new Column(COL_MIGRATION).setDataType(DataType.NVARCHAR).setLength(20L);
        table.getColumns().add((AbstractNamedObject)column);
        for (DbVersionFileHandler.SqlFile sqlFile : sqlFiles) {
            Long versioNo = sqlFile.getVersionNumber();
            Row current = null;
            Long rowId = null;
            boolean match = false;
            int i = 0;
            for (i = 0; i < table.getRows().size(); ++i) {
                current = table.getRows().get(i);
                rowId = this.getId(current);
                if (this.compare(rowId, versioNo) == 0) {
                    current.put(COL_VERSION_UP_SQL, (Object)this.size(sqlFile.getUpSqls()));
                    current.put(COL_VERSION_DOWN_SQL, (Object)this.size(sqlFile.getDownSqls()));
                    match = true;
                    break;
                }
                if (this.compare(rowId, versioNo) > 0) break;
            }
            if (rowId != null && match) continue;
            Row newRow = table.newRow();
            newRow.put(this.getIdColumnName(), (Object)versioNo);
            newRow.put(this.getDescriptionColumnName(), (Object)this.getFileName(sqlFile.getUpSqlFile()));
            newRow.put(COL_VERSION_UP_SQL, (Object)this.size(sqlFile.getUpSqls()));
            newRow.put(COL_VERSION_DOWN_SQL, (Object)this.size(sqlFile.getDownSqls()));
            if (this.compare(rowId, versioNo) >= 0) {
                table.getRows().add(i - 1, newRow);
                continue;
            }
            table.getRows().add(newRow);
        }
    }

    private Integer size(Collection<?> c) {
        if (c == null) {
            return null;
        }
        return c.size();
    }

    protected Long getId(Row row) {
        if (row == null) {
            return null;
        }
        return (Long)this.converters.convertObject(row.get(this.getIdColumnName()), Long.class);
    }

    protected Date getAppliedAt(Row row) {
        if (row == null) {
            return null;
        }
        return (Date)this.converters.convertObject(row.get(this.getAppliedAtColumnName()), Date.class);
    }

    protected Status getStatus(Row row) {
        if (row == null) {
            return null;
        }
        return Status.parse((String)row.get(this.getStatusColumnName()));
    }

    protected Long getSeriesNumber(Row row) {
        if (row == null) {
            return null;
        }
        return (Long)this.converters.convertObject(row.get(this.getSeriesNumberColumnName()), Long.class);
    }

    protected String getDescription(Row row) {
        if (row == null) {
            return null;
        }
        return (String)this.converters.convertObject(row.get(this.getDescriptionColumnName()), String.class);
    }

    public void append(Table table, OutputTextBuilder builder) {
        Long lastApplied = this.getLastApplied(table);
        Long[] current = new Long[1];
        builder.append(table, (column, row) -> {
            Object object = row.get(column);
            if (object == null && this.getStatusColumnName().equalsIgnoreCase(column.getName())) {
                Long val = this.getId((Row)row);
                if (current[0] == null) {
                    current[0] = val;
                }
                if (val == null) {
                    return INITIAL_APPLIED_AT_TEXT;
                }
                if (this.compare(current[0], lastApplied) >= 0) {
                    return Status.Pending.toString();
                }
                current[0] = val;
                return NOT_APPLIED_APPLIED_AT_TEXT;
            }
            return object;
        });
    }

    private int compare(Long val1, Long val2) {
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return val1.compareTo(val2);
    }

    private String getFileName(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        Object[] paths = path.split("[/\\\\]");
        String val = (String)CommonUtils.last((Object[])paths);
        int index = val.indexOf("_");
        if (index >= 0) {
            val = val.substring(index + 1);
        }
        if ((index = val.lastIndexOf(46)) >= 0) {
            val = val.substring(0, index);
        }
        return val;
    }

    public Table createVersionTableDefinition() {
        return this.createVersionTableDefinition(this.getSchemaChangeLogTableName());
    }

    public Long getLastApplied(Table table) {
        if (table.getRows().isEmpty()) {
            return null;
        }
        Long ret = Long.MIN_VALUE;
        for (Row row : table.getRows()) {
            Long obj = this.getId(row);
            Status status = this.getStatus(row);
            if (status.isPending() || status.isStarted() || this.compare(obj, ret) <= 0) continue;
            ret = obj;
        }
        return ret;
    }

    public Row markCurrentVersion(Table table) {
        int size = table.getRows().size();
        Row row = null;
        for (int i = size - 1; i >= 0; --i) {
            row = table.getRows().get(i);
            Status status = this.getStatus(row);
            if (!status.isCompleted() && !status.isErrord() && !status.isStarted()) continue;
            row.put(COL_MIGRATION, (Object)CURRENT_VERSION_TEXT);
            return row;
        }
        row.put(COL_MIGRATION, (Object)CURRENT_VERSION_TEXT);
        return row;
    }

    public List<Row> getRowsForVersionUp(Table table, Long version) {
        if (table.getRows().isEmpty()) {
            return Collections.emptyList();
        }
        if (version == null) {
            Long last = this.getLastVersionForApply(table);
            version = last != null ? last : Long.valueOf(Long.MAX_VALUE);
        }
        List result = CommonUtils.list();
        Row current = this.markCurrentVersion(table);
        Row lastRow = null;
        if (current != null) {
            lastRow = current;
        }
        boolean findCurrent = false;
        for (Row row : table.getRows()) {
            Long id = this.getId(row);
            Status status = this.getStatus(row);
            this.checkError(id, status);
            if (row == current) {
                findCurrent = true;
            }
            if (this.compare(version, id) >= 0 && id != null && this.compare(id, this.getId(lastRow)) > 0) {
                lastRow = row;
            }
            if (status.isCompleted()) continue;
            if (this.compare(version, id) < 0) break;
            if (current != row && findCurrent) {
                row.put(COL_MIGRATION, (Object)VERSION_UP_TEXT);
            }
            result.add(row);
        }
        this.setTargetVersion(current, lastRow);
        return result;
    }

    private void setTargetVersion(Row current, Row row) {
        if (row != null) {
            if (current == row) {
                row.put(COL_MIGRATION, (Object)VERSION_CURRENT_TARGET);
                this.clearMigration(row.getTable());
            } else {
                String val = (String)row.get(COL_MIGRATION);
                if (CURRENT_VERSION_TEXT.equals(val)) {
                    row.put(COL_MIGRATION, (Object)VERSION_CURRENT_TARGET);
                    this.clearMigration(row.getTable());
                } else {
                    row.put(COL_MIGRATION, (Object)VERSION_TARGET);
                }
            }
        } else if (current != null) {
            current.put(COL_MIGRATION, (Object)VERSION_CURRENT_TARGET);
            this.clearMigration(current.getTable());
        }
    }

    private void clearMigration(Table table) {
        for (Row row : table.getRows()) {
            String val = (String)row.get(COL_MIGRATION);
            if (!VERSION_UP_TEXT.equals(val) && !VERSION_DOWN_TEXT.equals(val)) continue;
            row.put(COL_MIGRATION, null);
        }
    }

    private Long getLastVersionForApply(Table table) {
        if (table.getRows().isEmpty()) {
            return null;
        }
        int size = table.getRows().size();
        for (int i = size - 1; i >= 0; --i) {
            Row row = table.getRows().get(i);
            Long id = this.getId(row);
            Status status = this.getStatus(row);
            if (status.isPending()) continue;
            this.checkError(id, status);
            return id;
        }
        return null;
    }

    private Long getPreviousVersion(Table table) {
        if (table.getRows().isEmpty()) {
            return null;
        }
        int size = table.getRows().size();
        int cnt = 0;
        for (int i = size - 1; i >= 0; --i) {
            Row row = table.getRows().get(i);
            Long id = this.getId(row);
            Status status = this.getStatus(row);
            if (status.isPending()) continue;
            this.checkError(id, status);
            if (id == null) continue;
            if (cnt > 0) {
                return id;
            }
            ++cnt;
        }
        return null;
    }

    public List<Row> getRowsForVersionDown(Table table, Long version) {
        if (table.getRows().isEmpty()) {
            return Collections.emptyList();
        }
        if (version == null) {
            version = this.getPreviousVersion(table);
        }
        List result = CommonUtils.list();
        int size = table.getRows().size();
        Row targetRow = null;
        Row previoudRow = (Row)CommonUtils.first((List)table.getRows());
        boolean find = false;
        for (int i = 1; i < table.getRows().size(); ++i) {
            targetRow = table.getRows().get(i);
            Long id = this.getId(targetRow);
            if (version == null || this.compare(version, id) < 0) {
                targetRow = previoudRow;
                find = true;
                break;
            }
            previoudRow = targetRow;
        }
        if (!find) {
            targetRow = (Row)CommonUtils.first((List)table.getRows());
        }
        Row current = this.markCurrentVersion(table);
        for (int i = size - 1; i >= 0; --i) {
            Row row = table.getRows().get(i);
            Long id = this.getId(row);
            Status status = this.getStatus(row);
            if (status.isPending()) continue;
            this.checkError(id, status);
            if (version != null && this.compare(version, id) >= 0) break;
            if (current != row) {
                row.put(COL_MIGRATION, (Object)VERSION_DOWN_TEXT);
            }
            result.add(row);
        }
        this.setTargetVersion(current, targetRow);
        return result;
    }

    public Row getRowsForVersionRepair(Table table) {
        if (table.getRows().isEmpty()) {
            return null;
        }
        int size = table.getRows().size();
        Row targetRow = null;
        boolean find = false;
        if (!find) {
            targetRow = (Row)CommonUtils.first((List)table.getRows());
        }
        Row current = this.markCurrentVersion(table);
        for (int i = size - 1; i >= 0; --i) {
            Row row = table.getRows().get(i);
            Status status = this.getStatus(row);
            if (status.isCompleted()) {
                return null;
            }
            if (status.isPending()) continue;
            if (current != row) {
                row.put(COL_MIGRATION, (Object)VERSION_DOWN_TEXT);
            }
            this.setTargetVersion(current, targetRow);
            return row;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public boolean exists(Dialect dialect, Connection connection, Table table, Long id) throws SQLException {
        List sqlOperations = dialect.getSqlFactoryRegistry().createSql((DbCommonObject)table, SqlType.SELECT_BY_PK);
        SqlOperation sqlOperation = (SqlOperation)sqlOperations.get(0);
        String sql = sqlOperation.getSqlText();
        int transactionIsolation = connection.getTransactionIsolation();
        try {
            connection.setTransactionIsolation(1);
            ParametersContext context = new ParametersContext();
            try (Statement statement = connection.createStatement();){
                SqlConverter sqlConverter = new SqlConverter();
                SqlNode sqlNode = sqlConverter.parseSql(context, sql);
                context.put(this.getIdColumnName(), (Object)id);
                final boolean[] exists = new boolean[]{false};
                JdbcHandler jdbcHandler = new JdbcHandler(sqlNode){

                    protected void handleResultSet(ExResultSet resultSet) throws SQLException {
                        exists[0] = resultSet.next();
                    }
                };
                jdbcHandler.execute(connection, context);
                boolean bl = exists[0];
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.setTransactionIsolation(transactionIsolation);
        }
    }

    public List<Row> getRowsForVersionDownSeries(Table table) {
        if (table.getRows().isEmpty()) {
            return Collections.emptyList();
        }
        List result = CommonUtils.list();
        Row current = this.markCurrentVersion(table);
        Row targetRow = null;
        Long seriesNumber = this.getSeriesNumber(current);
        int size = table.getRows().size();
        for (int i = size - 1; i >= 0; --i) {
            Row row = table.getRows().get(i);
            Long id = this.getId(row);
            Status status = this.getStatus(row);
            Long currentSeriesNumber = this.getSeriesNumber(row);
            if (status.isPending()) continue;
            this.checkError(id, status);
            if (currentSeriesNumber == null) continue;
            if (CommonUtils.eq((Object)currentSeriesNumber, (Object)seriesNumber)) {
                if (current != row) {
                    row.put(COL_MIGRATION, (Object)VERSION_DOWN_TEXT);
                }
                result.add(row);
                continue;
            }
            targetRow = row;
            break;
        }
        this.setTargetVersion(current, targetRow);
        return result;
    }

    private void checkError(Long id, Status status) {
        if (status.isStarted()) {
            throw new DbConcurrencyException();
        }
        if (status.isErrord()) {
            throw new SchemaVersionFailureException(id);
        }
    }

    protected Table getTable(Connection connection, Dialect dialect, Table table) throws SQLException {
        TableReader tableReader = dialect.getCatalogReader().getSchemaReader().getTableReader();
        tableReader.setSchemaName(table.getSchemaName());
        tableReader.setObjectName(table.getName());
        List tables = tableReader.getAllFull(connection);
        return tables.isEmpty() ? null : (Table)tables.get(0);
    }

    public boolean createTable(Connection connection, Dialect dialect, Table table) throws SQLException {
        return this.operateTable(connection, dialect, table, SqlType.CREATE);
    }

    public boolean dropTable(Connection connection, Dialect dialect, Table table) throws SQLException {
        return this.operateTable(connection, dialect, table, SqlType.DROP);
    }

    private boolean operateTable(Connection connection, Dialect dialect, Table table, SqlType sqlType) throws SQLException {
        SqlFactory operationFacroty = dialect.getSqlFactoryRegistry().getSqlFactory((DbCommonObject)table, sqlType);
        List operations = operationFacroty.createSql((DbCommonObject)table);
        if (operations.isEmpty()) {
            return false;
        }
        ConnectionSqlExecutor exec = new ConnectionSqlExecutor(connection);
        exec.setAutoClose(false);
        exec.execute((Collection)operations);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Connection connection, Dialect dialect, Table table) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        table.setDialect(dialect);
        try {
            AbstractSqlBuilder builder = dialect.createSqlBuilder();
            builder.select().space()._add("*").space().from().space().name((AbstractSchemaObject)table);
            builder.lineBreak().order().by().space().name(this.getIdColumnName()).space().asc();
            stmt = connection.prepareStatement(builder.toString());
            rs = stmt.executeQuery();
            table.readData(rs);
            Row row = table.newRow();
            table.getRows().add(0, row);
        }
        catch (Throwable throwable) {
            DbUtils.close(rs);
            DbUtils.close(stmt);
            throw throwable;
        }
        DbUtils.close((ResultSet)rs);
        DbUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertVersion(Connection connection, Dialect dialect, Table table, Row row, Long seriesNumber, Status status) throws SQLException {
        int n;
        PreparedStatement stmt = null;
        try {
            AbstractSqlBuilder builder = dialect.createSqlBuilder();
            builder.insert().into().space().name((AbstractSchemaObject)table);
            builder.space()._add("(");
            builder.name(this.getIdColumnName());
            builder.comma().name(this.getAppliedByColumnName());
            builder.comma().name(this.getAppliedAtColumnName());
            builder.comma().name(this.getStatusColumnName());
            builder.comma().name(this.getDescriptionColumnName());
            if (this.isWithSeriesNumber()) {
                builder.comma().name(this.getSeriesNumberColumnName());
            }
            builder._add(")").values();
            builder.space()._add("(");
            if (this.isWithSeriesNumber()) {
                builder._add("?,?,?,?,?,?");
            } else {
                builder._add("?,?,?,?,?");
            }
            builder._add(")");
            stmt = connection.prepareStatement(builder.toString());
            int i = 1;
            stmt.setLong(i++, this.getId(row));
            stmt.setString(i++, connection.getMetaData().getUserName());
            stmt.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
            stmt.setString(i++, status.toString());
            stmt.setString(i++, this.getDescription(row));
            if (this.isWithSeriesNumber()) {
                stmt.setLong(i++, seriesNumber);
            }
            n = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtils.close(stmt);
            throw throwable;
        }
        DbUtils.close((PreparedStatement)stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateVersion(Connection connection, Dialect dialect, Table table, Row row, Long id, Status from, Status to) throws SQLException {
        int n;
        PreparedStatement stmt = null;
        try {
            AbstractSqlBuilder builder = dialect.createSqlBuilder();
            builder.update().name((AbstractSchemaObject)table);
            builder.set();
            builder.space().name(this.getStatusColumnName()).eq()._add("?");
            builder.lineBreak();
            builder.where().name(this.getIdColumnName()).eq()._add("?");
            builder.lineBreak();
            builder.and().name(this.getStatusColumnName()).eq()._add("?");
            stmt = connection.prepareStatement(builder.toString());
            int i = 1;
            stmt.setString(i++, to.toString());
            stmt.setLong(i++, id);
            stmt.setString(i++, from.toString());
            n = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtils.close(stmt);
            throw throwable;
        }
        DbUtils.close((PreparedStatement)stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteVersion(Connection connection, Dialect dialect, Table table, Row row) throws SQLException {
        int n;
        PreparedStatement stmt = null;
        try {
            AbstractSqlBuilder builder = dialect.createSqlBuilder();
            builder.delete().from().space().name((AbstractSchemaObject)table);
            builder.where().space().name(this.getIdColumnName()).eq()._add("?");
            stmt = connection.prepareStatement(builder.toString());
            int i = 1;
            stmt.setLong(i++, this.getId(row));
            n = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtils.close(stmt);
            throw throwable;
        }
        DbUtils.close((PreparedStatement)stmt);
        return n;
    }

    public String getSchemaChangeLogTableName() {
        return this.schemaChangeLogTableName;
    }

    public void setSchemaChangeLogTableName(String schemaChangeLogTableName) {
        this.schemaChangeLogTableName = schemaChangeLogTableName;
    }

    public boolean isWithSeriesNumber() {
        return this.withSeriesNumber;
    }

    public void setWithSeriesNumber(boolean withSeriesNumber) {
        this.withSeriesNumber = withSeriesNumber;
    }
}

