/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.exceptions.InvalidTextException;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VirtualForeignKeyLoader {
    private final String encoding = "utf8";
    private static Pattern COMMENT_PATTERN = Pattern.compile("\\s*#.*");

    public void load(Catalog catalog, File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.listFiles() == null) {
            return;
        }
        for (File child : file.listFiles()) {
            List texts = FileUtils.readTextList((File)child, (String)"utf8");
            this.loadInternal(catalog, texts);
        }
    }

    private void loadInternal(Catalog catalog, List<String> texts) {
        for (int i = 0; i < texts.size(); ++i) {
            String text = texts.get(i);
            if (this.isComment(text)) continue;
            TablePair pair = this.parse(text, i + 1);
            Table from = this.getTable(pair, pair.getFrom(), catalog);
            Table to = this.getTable(pair, pair.getTo(), catalog);
            Column[] columns = this.getColumns(pair, pair.getFrom(), from);
            Column[] pkColumns = this.getColumns(pair, pair.getTo(), to);
            ForeignKeyConstraint fk = new ForeignKeyConstraint("fk_" + from.getName() + "_virtual" + (from.getConstraints().getForeignKeyConstraints().size() + 1), columns, pkColumns);
            fk.setVirtual(true);
            from.getConstraints().add(fk);
        }
    }

    private Table getTable(TablePair pair, Table table, Catalog catalog) {
        if (!CommonUtils.isEmpty((CharSequence)table.getSchemaName())) {
            Schema schema = (Schema)catalog.getSchemas().get(pair.getFrom().getSchemaName());
            if (schema == null) {
                throw new InvalidTextException(pair.getLine(), pair.getLineNo(), table + "(Schema) does not found.");
            }
            Table from = schema.getTable(table.getName());
            if (from == null) {
                throw new InvalidTextException(pair.getLine(), pair.getLineNo(), table + " does not found.");
            }
            return from;
        }
        for (Schema schema : catalog.getSchemas()) {
            Table from = schema.getTable(table.getName());
            if (from == null) continue;
            return from;
        }
        throw new InvalidTextException(pair.getLine(), pair.getLineNo(), table + " does not found.");
    }

    private Column[] getColumns(TablePair pair, Table ref, Table table) {
        List columns = CommonUtils.list();
        if (ref.getColumns().isEmpty()) {
            for (Column column : table.getColumns()) {
                if (!column.isPrimaryKey()) continue;
                columns.add(column);
            }
        } else {
            for (Column col : ref.getColumns()) {
                Column column = (Column)table.getColumns().get(col.getName());
                if (column == null) {
                    throw new InvalidTextException(pair.getLine(), pair.getLineNo(), col + " does not found.");
                }
                columns.add(column);
            }
        }
        return columns.toArray(new Column[0]);
    }

    private boolean isComment(String text) {
        Matcher matcher = COMMENT_PATTERN.matcher(text);
        return matcher.matches();
    }

    private TablePair parse(String text, int lineNo) {
        String base = text;
        String[] texts = (text = text.trim()).split("\\s*->\\s*");
        if (texts.length == 0) {
            throw new InvalidTextException(base, lineNo, "No relations(->) found.");
        }
        if (texts.length != 2) {
            throw new InvalidTextException(base, lineNo, "Multiple relations(->) found. count=" + texts.length);
        }
        Table from = this.parseTable(base, texts[0], lineNo);
        Table to = this.parseTable(base, texts[1], lineNo);
        TablePair pair = new TablePair();
        pair.setFrom(from);
        pair.setTo(to);
        pair.setLine(text);
        pair.setLineNo(lineNo);
        return pair;
    }

    private Table parseTable(String base, String tableText, int lineNo) {
        String[] names;
        int start = tableText.indexOf(40);
        String tablePart = null;
        Table table = new Table();
        if (start > 0) {
            String[] columns;
            tablePart = tableText.substring(0, start).trim();
            if (!tableText.endsWith(")")) {
                throw new InvalidTextException(base, lineNo, "aaaaa(id,val)->bbbbb");
            }
            for (String col : columns = tableText.substring(start + 1, tableText.length() - 1).split("\\s*,\\s*")) {
                Column column = table.newColumn();
                if (CommonUtils.isEmpty((CharSequence)(col = col.trim()))) {
                    throw new InvalidTextException(base, lineNo, "Invalid column definition. value=" + tableText);
                }
                column.setName(col);
                table.getColumns().add((AbstractNamedObject)column);
            }
        } else {
            tablePart = tableText;
        }
        if ((names = tablePart.split("\\.")).length == 1) {
            table.setName(names[0]);
        } else if (names.length == 2) {
            table.setSchemaName(names[0]);
            table.setName(names[1]);
        } else if (names.length == 2) {
            table.setCatalogName(names[0]);
            table.setSchemaName(names[1]);
            table.setName(names[2]);
        } else {
            throw new InvalidTextException(base, lineNo, "Invalid tableName. value=" + tablePart);
        }
        return table;
    }

    static class TablePair {
        private Table from;
        private Table to;
        private String line;
        private int lineNo;

        public Table getFrom() {
            return this.from;
        }

        public Table getTo() {
            return this.to;
        }

        public String getLine() {
            return this.line;
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public void setFrom(Table from) {
            this.from = from;
        }

        public void setTo(Table to) {
            this.to = to;
        }

        public void setLine(String line) {
            this.line = line;
        }

        public void setLineNo(int lineNo) {
            this.lineNo = lineNo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TablePair)) {
                return false;
            }
            TablePair other = (TablePair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Table this$from = this.getFrom();
            Table other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            Table this$to = this.getTo();
            Table other$to = other.getTo();
            if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
                return false;
            }
            String this$line = this.getLine();
            String other$line = other.getLine();
            if (this$line == null ? other$line != null : !this$line.equals(other$line)) {
                return false;
            }
            return this.getLineNo() == other.getLineNo();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TablePair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Table $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            Table $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            String $line = this.getLine();
            result = result * 59 + ($line == null ? 43 : $line.hashCode());
            result = result * 59 + this.getLineNo();
            return result;
        }

        public String toString() {
            return "VirtualForeignKeyLoader.TablePair(from=" + this.getFrom() + ", to=" + this.getTo() + ", line=" + this.getLine() + ", lineNo=" + this.getLineNo() + ")";
        }
    }
}

