/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.converter.TimestampConverter;
import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.jdbc.ConnectionHandler;
import com.sqlapp.jdbc.DataSourceConnectionHandler;
import com.sqlapp.util.OutputTextBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;

public abstract class AbstractDataSourceCommand
extends AbstractCommand {
    private DataSource dataSource;
    private Connection connection;
    private Dialect dialect;
    private ConnectionHandler connectionHandler = null;
    private Converters converters = this.newConverters();

    protected Converters newConverters() {
        Converters converters = new Converters();
        TimestampConverter converter = (TimestampConverter)converters.getConverter(Timestamp.class);
        converter.getZonedDateTimeConverter().setFormat("uuuu-MM-dd HH:mm:ss");
        return converters;
    }

    protected Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        try {
            Connection connection = this.getConnectionHandler().getConnection();
            return connection;
        }
        catch (SQLException e) {
            return (Connection)this.getExceptionHandler().handle((Throwable)e);
        }
    }

    protected void releaseConnection(Connection connection) {
        if (this.connection != null) {
            return;
        }
        try {
            this.getConnectionHandler().releaseConnection(connection);
        }
        catch (SQLException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    protected OutputTextBuilder createOutputTextBuilder() {
        OutputTextBuilder builder = new OutputTextBuilder();
        builder.setConverters(this.converters);
        return builder;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Dialect getDialect() {
        if (this.dialect == null) {
            Connection connection = null;
            try {
                connection = this.getConnection();
                this.dialect = this.getDialect(connection);
            }
            finally {
                this.releaseConnection(connection);
            }
        }
        return this.dialect;
    }

    public Dialect getDialect(Connection connection) {
        try {
            connection = this.getConnection();
            Dialect dialect = DialectResolver.getInstance().getDialect(connection);
            return dialect;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    protected String getCurrentCatalogName(Connection connection) {
        return this.getDialect().getCatalogReader().getCurrentCatalogName(connection);
    }

    protected String getCurrentSchemaName(Connection connection) {
        return this.getDialect().getCatalogReader().getSchemaReader().getCurrentSchemaName(connection);
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public ConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            this.connectionHandler = new DataSourceConnectionHandler(this.dataSource);
        }
        return this.connectionHandler;
    }

    public void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

