/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.data.db.command.OutputFormatType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.OutputTextBuilder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class SqlQueryCommand
extends AbstractDataSourceCommand {
    private String sql = null;
    private OutputFormatType outputFormatType = OutputFormatType.TSV;

    @Override
    protected void doRun() {
        Dialect dialect = this.getDialect();
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement(1003, 1007);
             ResultSet resultSet = statement.executeQuery(this.getSql());){
            Table table = new Table();
            table.setDialect(dialect);
            if (this.getOutputFormatType().isTable()) {
                table.read(connection, resultSet);
                OutputTextBuilder builder = new OutputTextBuilder();
                builder.append(table);
                this.println(builder.toString());
            } else {
                table.readMetaData(connection, resultSet);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                StringBuilder builder = new StringBuilder();
                int size = resultSetMetaData.getColumnCount();
                for (Column column : table.getColumns()) {
                    builder.append(column.getName());
                    builder.append(this.getOutputFormatType().getSeparator());
                }
                this.println(builder.substring(0, builder.length() - 1));
                while (resultSet.next()) {
                    builder = new StringBuilder();
                    for (int i = 1; i <= size; ++i) {
                        Object obj = resultSet.getObject(i);
                        Column column = (Column)table.getColumns().get(i - 1);
                        String text = dialect.getValueForDisplay(column, obj);
                        builder.append(text);
                        builder.append(this.getOutputFormatType().getSeparator());
                    }
                    this.println(builder.substring(0, builder.length() - 1));
                }
            }
        }
        catch (SQLException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public OutputFormatType getOutputFormatType() {
        return this.outputFormatType;
    }

    public void setOutputFormatType(OutputFormatType outputFormatType) {
        this.outputFormatType = outputFormatType;
    }
}

