/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.db.command.html.AbstractSchemaFileCommand;
import com.sqlapp.data.db.command.html.HtmlUtils;
import com.sqlapp.data.db.command.html.MenuDefinition;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.data.schemas.properties.RemarksProperty;
import com.sqlapp.data.schemas.rowiterator.ExcelUtils;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.exceptions.InvalidFileTypeException;
import com.sqlapp.exceptions.InvalidPropertyException;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.LinkedProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.supercsv.io.ICsvListWriter;

public class UpdateDictionariesCommand
extends AbstractSchemaFileCommand {
    private Predicate<String> withSchema = o -> true;
    private boolean outputRemarksAsDisplayName = true;

    @Override
    protected void create(Catalog catalog) {
        try {
            for (MenuDefinition menuDefinition : MenuDefinition.values()) {
                this.createProperties(catalog, menuDefinition, obj -> HtmlUtils.objectFullName(obj));
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    protected void createProperties(Catalog catalog, MenuDefinition menuDefinition, Function<Object, String> nameFunc) throws Exception {
        List list = menuDefinition.getDatas(catalog);
        if (list.isEmpty()) {
            return;
        }
        if (!(list.get(0) instanceof NameProperty)) {
            return;
        }
        String filename = menuDefinition.toString().toLowerCase();
        LinkedProperties fileProperties = new LinkedProperties();
        LinkedProperties mergeProperties = new LinkedProperties();
        File file = this.loadProperties(menuDefinition, this.getDictionaryFileType(), (Properties)fileProperties);
        list.forEach(arg_0 -> this.lambda$createProperties$2(filename, (Properties)fileProperties, (Properties)mergeProperties, arg_0));
        Set keys = CommonUtils.treeSet();
        if (menuDefinition == MenuDefinition.Columns) {
            list.forEach(arg_0 -> this.lambda$createProperties$3(filename, (Properties)fileProperties, (Properties)mergeProperties, arg_0));
            list.forEach(obj -> {
                String fullName = this.getFullName(obj, this.getWithSchema().test(filename));
                String columnNameWithTable = this.getColumnNameWithTable((AbstractDbObject<?>)obj);
                String name = this.getName(obj);
                if (!CommonUtils.eq((Object)fullName, (Object)name) && !CommonUtils.eq((Object)columnNameWithTable, (Object)name)) {
                    keys.add(name);
                }
            });
        } else {
            list.forEach(obj -> {
                String name;
                String fullName = this.getFullName(obj, this.getWithSchema().test(filename));
                if (!CommonUtils.eq((Object)fullName, (Object)(name = this.getName(obj)))) {
                    keys.add(name);
                }
            });
        }
        keys.forEach(arg_0 -> this.lambda$createProperties$6((Properties)fileProperties, (Properties)mergeProperties, arg_0));
        if (file == null) {
            file = new File(this.getDictionaryFileDirectory(), filename + "." + this.getDictionaryFileType());
        }
        FileUtils.createParentDirectory((File)file);
        this.writeProperties(file, menuDefinition, (Properties)mergeProperties);
    }

    private String getColumnNameWithTable(AbstractDbObject<?> obj) {
        Column column = (Column)obj;
        return column.getTableName() + "." + column.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties(File file, MenuDefinition menuDefinition, Properties properties) throws FileNotFoundException, IOException {
        block31: {
            File outputFile = new File(file.getParentFile(), FileUtils.getFileNameWithoutExtension((String)file.getAbsolutePath()) + "." + this.getDictionaryFileType());
            File tempFile = File.createTempFile(FileUtils.getFileNameWithoutExtension((String)file.getAbsolutePath()), "." + this.getDictionaryFileType(), file.getParentFile());
            try {
                if ("properties".equalsIgnoreCase(this.getDictionaryFileType())) {
                    try (FileOutputStream os = new FileOutputStream(tempFile);){
                        properties.store(os, (Object)((Object)menuDefinition) + " dictionaries");
                        break block31;
                    }
                }
                if ("xml".equalsIgnoreCase(this.getDictionaryFileType())) {
                    try (FileOutputStream os = new FileOutputStream(tempFile);){
                        properties.storeToXML(os, (Object)((Object)menuDefinition) + " dictionaries");
                    }
                    tempFile.renameTo(outputFile);
                    if (!outputFile.equals(file)) {
                        FileUtils.remove((File)file);
                    }
                    break block31;
                }
                this.writeOtherProperties(tempFile, menuDefinition, properties);
            }
            finally {
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                tempFile.renameTo(outputFile);
            }
        }
    }

    private void writeOtherProperties(File file, MenuDefinition menuDefinition, Properties properties) throws IOException {
        WorkbookFileType workbookFileType = WorkbookFileType.parse((File)file);
        if (workbookFileType.isTextFile() && workbookFileType.isCsv()) {
            this.writeAsCsv(workbookFileType, file, menuDefinition, properties);
        } else if (workbookFileType.isWorkbook()) {
            this.writeAsWorkbook(workbookFileType, file, menuDefinition, properties);
        } else if (workbookFileType.isJson()) {
            this.writeAsJson(workbookFileType, file, menuDefinition, properties);
        } else {
            throw new InvalidFileTypeException(file);
        }
    }

    private void writeAsCsv(WorkbookFileType workbookFileType, File file, MenuDefinition menuDefinition, Properties properties) throws IOException {
        List menuDefinitions = CommonUtils.list(menuDefinition.getNest());
        int maxNestLebel = this.getMaxNestLebel(properties);
        if (maxNestLebel != menuDefinition.getNestLevel()) {
            menuDefinitions.remove(0);
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, this.getCsvEncoding());
             BufferedWriter bw = new BufferedWriter(writer);
             ICsvListWriter csvWriter = workbookFileType.createCsvListWriter((Writer)bw);){
            List<String> headers = menuDefinitions.stream().map(c -> c.toString()).collect(Collectors.toList());
            for (String keyword : this.getKeywords()) {
                headers.add(keyword);
            }
            csvWriter.writeHeader(headers.toArray(new String[0]));
            Set output = CommonUtils.set();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                if (output.contains(key)) continue;
                String[] values = new String[headers.size()];
                String value = (String)entry.getValue();
                int pos = key.lastIndexOf(46);
                if (pos < 0) {
                    throw new InvalidPropertyException(key, (Object)value);
                }
                String suffix = key.substring(pos + 1);
                String[] args = key.split("\\.");
                for (int i = 0; i < headers.size(); ++i) {
                    values[i] = "";
                    String header = (String)headers.get(i);
                    if (i < headers.size() - 2) {
                        values[i] = this.getHeaderValue(headers, i, args);
                        continue;
                    }
                    if (suffix.equalsIgnoreCase(header)) {
                        values[i] = value;
                        output.add(key);
                        continue;
                    }
                    String otherKey = key.substring(0, pos) + "." + header;
                    output.add(otherKey);
                    String otherValue = properties.getProperty(otherKey);
                    if (otherValue == null) continue;
                    values[i] = otherValue.toString();
                }
                csvWriter.write(values);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeAsWorkbook(WorkbookFileType workbookFileType, File file, MenuDefinition menuDefinition, Properties properties) throws IOException {
        List menuDefinitions = CommonUtils.list(menuDefinition.getNest());
        int maxNestLebel = this.getMaxNestLebel(properties);
        if (maxNestLebel != menuDefinition.getNestLevel()) {
            menuDefinitions.remove(0);
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            void var16_23;
            Workbook workbook = workbookFileType.createWorkbook();
            Sheet sheet = workbook.createSheet(menuDefinition.toString());
            List<String> headers = menuDefinitions.stream().map(c -> c.toString()).collect(Collectors.toList());
            for (String keyword : this.getKeywords()) {
                headers.add(keyword);
            }
            int rowNo = 0;
            Row row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rowNo++);
            int cellNo = 0;
            for (String string : headers) {
                Cell cell = ExcelUtils.getOrCreateCell((Row)row, (int)cellNo++);
                cell.setCellValue(string);
            }
            Set output = CommonUtils.set();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                if (output.contains(key)) continue;
                String[] values = new String[headers.size()];
                String value = (String)entry.getValue();
                int pos = key.lastIndexOf(46);
                if (pos < 0) {
                    throw new InvalidPropertyException(key, (Object)value);
                }
                String suffix = key.substring(pos + 1);
                String[] args = key.split("\\.");
                for (int i = 0; i < headers.size(); ++i) {
                    values[i] = "";
                    String header = (String)headers.get(i);
                    if (i < headers.size() - 2) {
                        values[i] = this.getHeaderValue(headers, i, args);
                        continue;
                    }
                    if (suffix.equalsIgnoreCase(header)) {
                        values[i] = value;
                        output.add(key);
                        continue;
                    }
                    String otherKey = key.substring(0, pos) + "." + header;
                    output.add(otherKey);
                    String otherValue = properties.getProperty(otherKey);
                    if (otherValue == null) continue;
                    values[i] = otherValue.toString();
                }
                row = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rowNo++);
                cellNo = 0;
                for (String val : values) {
                    Cell cell = ExcelUtils.getOrCreateCell((Row)row, (int)cellNo++);
                    cell.setCellValue(val);
                }
            }
            boolean bl = false;
            while (var16_23 < headers.size()) {
                sheet.autoSizeColumn((int)var16_23);
                ++var16_23;
            }
            workbook.write((OutputStream)fos);
        }
    }

    private void writeAsJson(WorkbookFileType workbookFileType, File file, MenuDefinition menuDefinition, Properties properties) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));){
            String suffix;
            String[] args;
            int pos;
            String value;
            String key;
            Map map = CommonUtils.linkedMap();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                key = entry.getKey().toString();
                value = (String)entry.getValue();
                pos = key.lastIndexOf(46);
                args = key.split("\\.");
                suffix = key.substring(pos + 1);
                if (!SchemaProperties.DISPLAY_NAME.getLabel().equalsIgnoreCase(suffix)) continue;
                this.putValue(map, args, value);
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                key = entry.getKey().toString();
                value = (String)entry.getValue();
                pos = key.lastIndexOf(46);
                args = key.split("\\.");
                suffix = key.substring(pos + 1);
                if (SchemaProperties.DISPLAY_NAME.getLabel().equalsIgnoreCase(suffix)) continue;
                this.putValue(map, args, value);
            }
            String text = this.getJsonConverter().toJsonString((Object)map);
            bw.write(text);
        }
    }

    private void putValue(Map<String, Object> map, String[] args, String value) {
        if (args.length == 1 && this.getKeywordsMap().containsKey(args[0])) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (i == args.length - 1) {
                map.put((String)arg, (Object)value);
                continue;
            }
            Object obj = map.get(arg);
            if (obj == null) {
                Map child = CommonUtils.linkedMap();
                map.put(arg, child);
                map = child;
                continue;
            }
            map = (Map)obj;
        }
    }

    private String getHeaderValue(List<String> headers, int i, String[] args) {
        int diff = headers.size() - 2 - (args.length - 1);
        if (i >= diff) {
            return args[i - diff];
        }
        return "";
    }

    private int getMaxNestLebel(Properties properties) {
        int level = 0;
        for (Object key : properties.keySet()) {
            int current = key.toString().split("\\.").length;
            level = Math.max(level, current - 1);
        }
        return level;
    }

    private void putProperty(Properties fileProperties, String name, AbstractDbObject<?> obj, Properties mergeProperties) {
        for (String keyword : this.getKeywords()) {
            String key = name + "." + keyword;
            String value = fileProperties.getProperty(key);
            if (!CommonUtils.isEmpty((CharSequence)value)) {
                mergeProperties.put(key, value);
                continue;
            }
            if (this.isOutputRemarksAsDisplayName() && SchemaProperties.DISPLAY_NAME.getLabel().equals(keyword) && obj instanceof RemarksProperty) {
                RemarksProperty remarksProperty = (RemarksProperty)obj;
                value = remarksProperty.getRemarks();
            }
            if (value != null) {
                mergeProperties.put(key, value);
                continue;
            }
            mergeProperties.put(key, "");
        }
    }

    public Predicate<String> getWithSchema() {
        return this.withSchema;
    }

    public boolean isOutputRemarksAsDisplayName() {
        return this.outputRemarksAsDisplayName;
    }

    public void setOutputRemarksAsDisplayName(boolean outputRemarksAsDisplayName) {
        this.outputRemarksAsDisplayName = outputRemarksAsDisplayName;
    }

    public void setWithSchema(Predicate<String> withSchema) {
        this.withSchema = withSchema;
    }

    private /* synthetic */ void lambda$createProperties$6(Properties fileProperties, Properties mergeProperties, String k) {
        this.putProperty(fileProperties, k, null, mergeProperties);
    }

    private /* synthetic */ void lambda$createProperties$3(String filename, Properties fileProperties, Properties mergeProperties, AbstractDbObject obj) {
        String columnNameWithTable;
        String fullName = this.getFullName(obj, this.getWithSchema().test(filename));
        if (!CommonUtils.eq((Object)fullName, (Object)(columnNameWithTable = this.getColumnNameWithTable(obj)))) {
            this.putProperty(fileProperties, columnNameWithTable, obj, mergeProperties);
        }
    }

    private /* synthetic */ void lambda$createProperties$2(String filename, Properties fileProperties, Properties mergeProperties, AbstractDbObject obj) {
        String fullName = this.getFullName(obj, this.getWithSchema().test(filename));
        this.putProperty(fileProperties, fullName, obj, mergeProperties);
    }

    static class StringComparator
    implements Comparator<String> {
        private Map<String, Integer> keywordsMap;

        StringComparator(Map<String, Integer> keywordsMap) {
            this.keywordsMap = keywordsMap;
        }

        @Override
        public int compare(String o1, String o2) {
            String[] split2;
            String[] split1 = o1.split("\\.");
            if (split1.length > (split2 = o2.split("\\.")).length) {
                return 1;
            }
            if (split1.length < split2.length) {
                return -1;
            }
            int comp = this.compareWithoutLast(split1, split2);
            if (comp != 0) {
                return comp;
            }
            return this.compareLast(split1, split2);
        }

        private int compareWithoutLast(String[] split1, String[] split2) {
            for (int i = 0; i < split1.length - 1; ++i) {
                int comp = split1[i].compareTo(split2[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }

        private int compareLast(String[] split1, String[] split2) {
            String value1 = split1[split1.length - 1];
            String value2 = split2[split2.length - 1];
            Integer int1 = this.keywordsMap.get(value1);
            Integer int2 = this.keywordsMap.get(value2);
            if (int1 == null) {
                if (int2 == null) {
                    return value1.compareTo(value2);
                }
                return 1;
            }
            if (int2 == null) {
                return 0;
            }
            return int1.compareTo(int2);
        }
    }
}

