/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSchemaDataSourceCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.ObjectNameReaderPredicate;
import com.sqlapp.data.db.metadata.ReadDbObjectPredicate;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.sql.ConnectionSqlExecutor;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DropObjectsCommand
extends AbstractSchemaDataSourceCommand {
    private String[] includeSchemas = null;
    private String[] excludeSchemas = null;
    private String[] includeObjects = null;
    private String[] excludeObjects = null;
    private boolean onlyCurrentCatalog = true;
    private boolean onlyCurrentSchema = false;
    private boolean dropObjects = false;
    private boolean dropTables = false;
    private String preDropTableSql;
    private String afterDropTableSql;

    protected SchemaReader getSchemaReader(Dialect dialect) throws SQLException {
        CatalogReader catalogReader = dialect.getCatalogReader();
        try (Connection connection = this.getConnection();){
            SchemaReader schemaReader = catalogReader.getSchemaReader();
            if (this.isOnlyCurrentCatalog()) {
                String catalogName = this.getCurrentCatalogName(connection);
                schemaReader.setCatalogName(catalogName);
            }
            if (this.isOnlyCurrentSchema()) {
                String schemaName = this.getCurrentSchemaName(connection);
                schemaReader.setSchemaName(schemaName);
            }
            schemaReader.setReadDbObjectPredicate(this.getMetadataReaderFilter());
            SchemaReader schemaReader2 = schemaReader;
            return schemaReader2;
        }
    }

    protected ReadDbObjectPredicate getMetadataReaderFilter() {
        ObjectNameReaderPredicate readerFilter = new ObjectNameReaderPredicate(this.getIncludeSchemas(), this.getExcludeSchemas(), this.getIncludeObjects(), this.getExcludeObjects());
        return readerFilter;
    }

    @Override
    protected void doRun() {
        Dialect dialect = this.getDialect();
        SchemaReader schemaReader = null;
        try {
            schemaReader = this.getSchemaReader(dialect);
        }
        catch (SQLException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
        SqlFactoryRegistry sqlFactoryRegistry = dialect.getSqlFactoryRegistry();
        try (Connection connection = this.getConnection();){
            List schemas = schemaReader.getAll(connection);
            for (Schema schema : schemas) {
                if (this.isDropObjects()) {
                    schemaReader.load(connection, schema);
                    this.dropObjects(connection, schemaReader, schema, sqlFactoryRegistry);
                }
                if (!this.isDropTables()) continue;
                if (!this.isDropObjects()) {
                    TableReader tableReader = schemaReader.getTableReader();
                    tableReader.setCatalogName(schema.getCatalogName());
                    tableReader.setSchemaName(schema.getName());
                    tableReader.loadFull(connection, schema);
                }
                this.dropTables(connection, schemaReader, schema, sqlFactoryRegistry);
            }
        }
        catch (SQLException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    protected void dropObjects(Connection connection, SchemaReader schemaReader, Schema schema, SqlFactoryRegistry sqlFactoryRegistry) throws SQLException {
        this.loadDetail(connection, schemaReader, schema);
        ConnectionSqlExecutor operationExecutor = new ConnectionSqlExecutor(connection);
        operationExecutor.setAutoClose(false);
        for (Map.Entry entry : schema.getChildObjectCollectionMap().entrySet()) {
            if (SchemaObjectProperties.TABLES.getLabel().equals(entry.getKey())) continue;
            DbObjectCollection collection = (DbObjectCollection)entry.getValue();
            for (DbObject object : collection) {
                SqlFactory sqlFactory = sqlFactoryRegistry.getSqlFactory((DbCommonObject)object, SqlType.DROP);
                List operations = sqlFactory.createSql((DbCommonObject)object);
                operationExecutor.execute((Collection)operations);
            }
        }
    }

    protected void loadDetail(Connection connection, SchemaReader schemaReader, Schema schema) throws SQLException {
        schemaReader.load(connection, schema);
    }

    protected void dropTables(Connection connection, SchemaReader schemaReader, Schema schema, SqlFactoryRegistry sqlFactoryRegistry) throws SQLException {
        ConnectionSqlExecutor sqlExecutor = new ConnectionSqlExecutor(connection);
        sqlExecutor.setAutoClose(false);
        if (!CommonUtils.isEmpty((CharSequence)this.getPreDropTableSql())) {
            try (Statement statement = connection.createStatement();){
                statement.executeQuery(this.getPreDropTableSql());
            }
        }
        SqlFactory sqlFactory = sqlFactoryRegistry.getSqlFactory((DbCommonObject)new Table(), SqlType.DROP);
        List operations = sqlFactory.createSql((Collection)schema.getTables());
        sqlExecutor.execute((Collection)operations);
        if (!CommonUtils.isEmpty((CharSequence)this.getAfterDropTableSql())) {
            try (Statement statement = connection.createStatement();){
                statement.executeQuery(this.getAfterDropTableSql());
            }
        }
    }

    public String[] getIncludeSchemas() {
        return this.includeSchemas;
    }

    public void setIncludeSchemas(String ... includeSchemas) {
        this.includeSchemas = includeSchemas;
    }

    public String[] getExcludeSchemas() {
        return this.excludeSchemas;
    }

    public void setExcludeSchemas(String ... excludeSchemas) {
        this.excludeSchemas = excludeSchemas;
    }

    public String[] getIncludeObjects() {
        return this.includeObjects;
    }

    public void setIncludeObjects(String ... includeObjects) {
        this.includeObjects = includeObjects;
    }

    public String[] getExcludeObjects() {
        return this.excludeObjects;
    }

    public void setExcludeObjects(String ... excludeObjects) {
        this.excludeObjects = excludeObjects;
    }

    public boolean isOnlyCurrentCatalog() {
        return this.onlyCurrentCatalog;
    }

    public void setOnlyCurrentCatalog(boolean onlyCurrentCatalog) {
        this.onlyCurrentCatalog = onlyCurrentCatalog;
    }

    public boolean isOnlyCurrentSchema() {
        return this.onlyCurrentSchema;
    }

    public void setOnlyCurrentSchema(boolean onlyCurrentSchema) {
        this.onlyCurrentSchema = onlyCurrentSchema;
    }

    public boolean isDropObjects() {
        return this.dropObjects;
    }

    public void setDropObjects(boolean dropObjects) {
        this.dropObjects = dropObjects;
    }

    public boolean isDropTables() {
        return this.dropTables;
    }

    public void setDropTables(boolean dropTables) {
        this.dropTables = dropTables;
    }

    public String getPreDropTableSql() {
        return this.preDropTableSql;
    }

    public void setPreDropTableSql(String preDropTableSql) {
        this.preDropTableSql = preDropTableSql;
    }

    public String getAfterDropTableSql() {
        return this.afterDropTableSql;
    }

    public void setAfterDropTableSql(String afterDropTableSql) {
        this.afterDropTableSql = afterDropTableSql;
    }
}

