/*
 * Copyright (C) 2007-2017 Tatsuo Satoh &lt;multisqllib@gmail.com&gt;
 *
 * This file is part of sqlapp-gradle-plugin.
 *
 * sqlapp-gradle-plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * sqlapp-gradle-plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with sqlapp-gradle-plugin.  If not, see &lt;http://www.gnu.org/licenses/&gt;.
 */

package com.sqlapp.gradle.plugins

import org.gradle.api.tasks.Internal
import org.gradle.api.tasks.TaskAction;

import com.sqlapp.data.db.command.version.VersionUpCommand
import com.sqlapp.gradle.plugins.pojo.VersionUpPojo

class VersionUpTask extends AbstractDbTask {

	@TaskAction
	def exec() {
		VersionUpCommand command=createVersionUpCommand();
		initialize(command);
		run(command);
	}

	protected VersionUpCommand createVersionUpCommand(){
		VersionUpCommand command=new VersionUpCommand();
		return command;
	}

	protected void initialize(VersionUpCommand command){
		VersionUpPojo pojo=getVersionUpPojo();
		this.parameters=pojo.parameters;
		this.debug=pojo.debug;
		command.setDataSource(this.createDataSource(pojo));
		if (pojo.getFileDirectory()!=null){
			command.fileDirectory=getFile(pojo.fileDirectory);
		}
		command.encoding=pojo.encoding;
		command.placeholders=pojo.placeholders;
		command.placeholderPrefix=pojo.placeholderPrefix;
		command.placeholderSuffix=pojo.placeholderSuffix;
		command.sqlDirectory=getFile(pojo.sqlDirectory);
		if (pojo.getDownSqlDirectory()!=null){
			command.downSqlDirectory=getFile(pojo.downSqlDirectory);
		}
		command.lastChangeToApply=pojo.lastChangeNumber;
		command.showVersionOnly=pojo.showVersionOnly;
		command.withSeriesNumber=pojo.withSeriesNumber;
		command.setupSqlDirectory=pojo.setupSqlDirectory;
		command.finalizeSqlDirectory=pojo.finalizeSqlDirectory;
		if (pojo.changeTable!=null){
			command.schemaChangeLogTableName=pojo.changeTable.name;
			command.idColumnName=pojo.changeTable.idColumnName;
			command.appliedByColumnName=pojo.changeTable.appliedByColumnName;
			command.appliedAtColumnName=pojo.changeTable.appliedAtColumnName;
			command.descriptionColumnName=pojo.changeTable.descriptionColumnName;
			command.seriesNumberColumnName=pojo.changeTable.seriesNumberColumnName;
		}
	}

	@Internal
	protected VersionUpPojo getVersionUpPojo(){
		return project.versionUp;
	}
}
