/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.gradle.plugins.extension.CountAllTableExtension;
import com.sqlapp.gradle.plugins.extension.DiffSchemaXmlExtension;
import com.sqlapp.gradle.plugins.extension.DropObjectsExtension;
import com.sqlapp.gradle.plugins.extension.ExportDataExtension;
import com.sqlapp.gradle.plugins.extension.ExportXmlExtension;
import com.sqlapp.gradle.plugins.extension.GenerateDiffSqlExtension;
import com.sqlapp.gradle.plugins.extension.GenerateHtmlExtension;
import com.sqlapp.gradle.plugins.extension.GenerateSqlExtension;
import com.sqlapp.gradle.plugins.extension.ImportDataExtension;
import com.sqlapp.gradle.plugins.extension.SynchronizeSchemaExtension;
import com.sqlapp.gradle.plugins.extension.UpdateDictionariesExtension;
import com.sqlapp.gradle.plugins.extension.VersionUpExtension;
import com.sqlapp.gradle.plugins.tasks.ConfigUtils;
import com.sqlapp.gradle.plugins.tasks.CountAllTableTask;
import com.sqlapp.gradle.plugins.tasks.DiffSchemaXmlTask;
import com.sqlapp.gradle.plugins.tasks.DropObjectsTask;
import com.sqlapp.gradle.plugins.tasks.ExportDataTask;
import com.sqlapp.gradle.plugins.tasks.ExportXmlTask;
import com.sqlapp.gradle.plugins.tasks.GenerateDiffSqlTask;
import com.sqlapp.gradle.plugins.tasks.GenerateHtmlTask;
import com.sqlapp.gradle.plugins.tasks.GenerateSqlTask;
import com.sqlapp.gradle.plugins.tasks.ImportDataTask;
import com.sqlapp.gradle.plugins.tasks.SynchronizeSchemaTask;
import com.sqlapp.gradle.plugins.tasks.UpdateDictionariesTask;
import com.sqlapp.gradle.plugins.tasks.VersionDownSeriesTask;
import com.sqlapp.gradle.plugins.tasks.VersionDownTask;
import com.sqlapp.gradle.plugins.tasks.VersionInsertTask;
import com.sqlapp.gradle.plugins.tasks.VersionRepairTask;
import com.sqlapp.gradle.plugins.tasks.VersionUpTask;
import com.sqlapp.util.CommonUtils;
import groovy.util.ConfigObject;
import java.io.Console;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class DbPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (project.getExtensions() == null) {
            // empty if block
        }
        this.loadEnvironment(project);
        this.registerTaskWithExtensions(project, "exportData", ExportDataExtension.class, ExportDataTask.class);
        this.registerTaskWithExtensions(project, "importData", ImportDataExtension.class, ImportDataTask.class);
        this.registerTaskWithExtensions(project, "countAllTables", CountAllTableExtension.class, CountAllTableTask.class);
        this.registerTaskWithExtensions(project, "dropObjects", DropObjectsExtension.class, DropObjectsTask.class);
        this.registerTaskWithExtensions(project, "versionUp", VersionUpExtension.class, VersionUpTask.class);
        this.registerTaskWithExtensions(project, "versionInsert", VersionUpExtension.class, VersionInsertTask.class);
        this.registerTaskWithExtensions(project, "versionRepair", VersionUpExtension.class, VersionRepairTask.class);
        this.registerTaskWithExtensions(project, "versionDown", VersionUpExtension.class, VersionDownTask.class);
        this.registerTaskWithExtensions(project, "versionDownSeries", VersionUpExtension.class, VersionDownSeriesTask.class);
        this.registerTaskWithExtensions(project, "exportXml", ExportXmlExtension.class, ExportXmlTask.class);
        this.registerTaskWithExtensions(project, "diffSchemaXml", DiffSchemaXmlExtension.class, DiffSchemaXmlTask.class);
        this.registerTaskWithExtensions(project, "synchronizeSchema", SynchronizeSchemaExtension.class, SynchronizeSchemaTask.class);
        this.registerTaskWithExtensions(project, "generateDiffSql", GenerateDiffSqlExtension.class, GenerateDiffSqlTask.class);
        this.registerTaskWithExtensions(project, "generateSql", GenerateSqlExtension.class, GenerateSqlTask.class);
        this.registerTaskWithExtensions(project, "generateHtml", GenerateHtmlExtension.class, GenerateHtmlTask.class);
        this.registerTaskWithExtensions(project, "updateDictionaries", UpdateDictionariesExtension.class, UpdateDictionariesTask.class);
    }

    protected void registerTaskWithExtensions(Project project, String name, Class<?> pojoClass, Class<? extends Task> taskClass) {
        this.createExtensions(project, name, pojoClass);
        this.registerTask(project, name, taskClass);
    }

    protected void registerTask(Project project, String name, Class<? extends Task> taskClass) {
        project.getTasks().register(name, taskClass);
    }

    protected void createExtensions(Project project, String name, Class<?> pojoClass) {
        project.getExtensions().create(name, pojoClass, new Object[0]);
    }

    protected void loadEnvironment(Project project) {
        String envVar;
        String env;
        Object envVal = this.getPropertyInternal(project, "loadTimeEnvironment");
        if (envVal == null) {
            return;
        }
        Boolean bool = this.convert(envVal, Boolean.class);
        if (!bool.booleanValue()) {
            return;
        }
        System.out.println("project.extensions.loadTimeEnvironment=" + bool);
        String environmentFilePath = (String)this.getPropertyInternal(project, "environmentFilePath");
        if (environmentFilePath != null) {
            System.out.println("project.extensions.environmentFilePath=" + environmentFilePath);
        } else {
            environmentFilePath = "src/main/environment";
        }
        File directory = this.getFile(project, environmentFilePath);
        if (!directory.exists()) {
            System.out.println("environmentFilePath does not exists. path=" + directory.getAbsolutePath());
            return;
        }
        if (!directory.isDirectory()) {
            System.out.println("environmentFilePath is not a directory. path=" + directory.getAbsolutePath());
            return;
        }
        TreeMap<String, File> childMap = new TreeMap<String, File>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File child : files) {
                if (!child.isDirectory()) continue;
                childMap.put(child.getName(), child);
            }
        }
        if ((env = (String)this.getPropertyInternal(project, "env")) == null) {
            if (childMap.isEmpty()) {
                System.err.println("No environment found. path=" + directory.getAbsolutePath());
                throw new InvalidUserDataException("No environment found. path=" + directory.getAbsolutePath());
            }
            if (childMap.size() == 1) {
                env = (String)CommonUtils.first(childMap.keySet());
            } else {
                String envText = this.getEnvText(childMap.keySet());
                Console console = System.console();
                if (console != null) {
                    while ((env = console.readLine("%s:", "select environment. [" + envText + "]")) == null || !childMap.containsKey(env)) {
                    }
                    System.out.println("environment[" + env + "] was selected.");
                }
            }
        }
        if (env == null) {
            String defaultEnvironment = (String)this.getPropertyInternal(project, "defaultEnvironment");
            envVar = defaultEnvironment != null ? defaultEnvironment : "default";
            System.out.println("project.extensions.defaultEnvironment=" + envVar);
        } else {
            envVar = env;
        }
        File envDir = new File(directory, envVar);
        if (!envDir.exists()) {
            System.out.println("Env direcotry does not exists. path=" + envDir.getAbsolutePath());
            return;
        }
        if (!envDir.isDirectory()) {
            System.out.println("Env direcotry is not a directory. path=" + envDir.getAbsolutePath());
            throw new InvalidUserDataException("Env direcotry is not a directory. path=" + envDir.getAbsolutePath());
        }
        ConfigObject config = new ConfigObject();
        Map props = project.getProperties();
        File[] envFiles = envDir.listFiles();
        if (envFiles != null) {
            ConfigUtils.readConfig(props, (Map)config, envFiles);
        }
        config.forEach((k, v) -> {
            String key = (String)k;
            Object value = v;
            props.put(key, value);
            Object obj = project.getExtensions().findByName(key);
            if (obj == null) {
                project.getExtensions().add(key, value);
            }
        });
    }

    private String getEnvText(Set<String> set) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String value : set) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(value);
        }
        return builder.toString();
    }

    private <T> T getPropertyInternal(Project project, String key) {
        String value = System.getProperty(key);
        if (value == null && project.hasProperty(key)) {
            value = project.getProperties().get(key);
        }
        return (T)value;
    }

    private <T> T convert(Object value, Class<T> clazz) {
        return (T)Converters.getDefault().convertObject(value, clazz);
    }

    protected File getFile(Project project, String file) {
        return project.file((Object)file);
    }
}

