/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.extension;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.gradle.plugins.extension.AbstractExtension;
import com.sqlapp.gradle.plugins.extension.DataSourceExtension;
import com.sqlapp.gradle.plugins.extension.DataSourceInject;
import com.sqlapp.jdbc.SqlappDataSource;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.gradle.api.Project;
import org.gradle.api.tasks.Internal;

public abstract class AbstractDbExtension
extends AbstractExtension
implements DataSourceInject {
    @Inject
    protected AbstractDbExtension(Project project) {
        super(project);
        this.setDataSource((DataSourceExtension)this.getProject().getObjects().newInstance(DataSourceExtension.class, new Object[0]));
    }

    @Override
    @Internal
    public void setCommand(AbstractCommand command, boolean debug) {
        super.setCommand(command, debug);
        if (command instanceof AbstractDataSourceCommand) {
            AbstractDataSourceCommand com = (AbstractDataSourceCommand)command;
            HikariConfig config = this.getConfig();
            com.setDataSource(this.createDataSource(config, debug));
        }
    }

    @Internal
    private DataSource createDataSource(HikariConfig config, boolean debug) {
        if (!debug) {
            HikariDataSource ds = new HikariDataSource(config);
            return ds;
        }
        SqlappDataSource sds = new SqlappDataSource((DataSource)new HikariDataSource(config));
        sds.setDebug(debug);
        return sds;
    }
}

