/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.extension;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.SynchronizeSchemaCommand;
import com.sqlapp.data.db.sql.SqlExecutor;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.gradle.plugins.extension.AbstractSchemaFileExtension;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public abstract class SynchronizeSchemaExtension
extends AbstractSchemaFileExtension {
    @Inject
    public SynchronizeSchemaExtension(Project project) {
        super(project);
    }

    @Internal
    public void call(Action<SynchronizeSchemaExtension> cons) {
        cons.execute((Object)this);
    }

    @Input
    @Optional
    public abstract Property<EqualsHandler> getEqualsHandler();

    public void equalsHandler(Action<? super Property<EqualsHandler>> action) {
        action.execute(this.getEqualsHandler());
    }

    @InputFile
    @Optional
    public abstract ConfigurableFileCollection getFiles();

    @Input
    @Optional
    public abstract Property<SqlExecutor> getSqlExecutor();

    public void sqlExecutor(Action<? super SqlExecutor> action) {
        if (this.getSqlExecutor().isPresent()) {
            action.execute(this.getSqlExecutor().get());
        }
    }

    @Override
    @Internal
    public void setCommand(AbstractCommand command, boolean debug) {
        super.setCommand(command, debug);
        if (command instanceof SynchronizeSchemaCommand) {
            SynchronizeSchemaCommand com = (SynchronizeSchemaCommand)command;
            if (this.getEqualsHandler().isPresent()) {
                com.setEqualsHandler((EqualsHandler)this.getEqualsHandler().get());
            }
            if (this.getFiles().isEmpty()) {
                com.setFiles(this.getFiles().getFiles().toArray(new File[0]));
            }
            if (this.getSqlExecutor().isPresent()) {
                com.setSqlExecutor((SqlExecutor)this.getSqlExecutor().get());
            }
        }
    }
}

