/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.tasks;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.export.ConvertDataFileCommand;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.gradle.plugins.tasks.AbstractTask;
import com.sqlapp.util.JsonConverter;
import java.io.File;
import java.util.function.Predicate;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class ConvertDataFileTask
extends AbstractTask {
    @Internal
    public void call(Action<ConvertDataFileTask> cons) {
        cons.execute((Object)this);
    }

    @InputDirectory
    public abstract DirectoryProperty getDirectory();

    @Input
    @Optional
    public abstract Property<Predicate<File>> getFileFilter();

    @Input
    @Optional
    public abstract Property<String> getCsvEncoding();

    @Input
    @Optional
    public abstract Property<JsonConverter> getJsonConverter();

    public void jsonConverter(Action<? super Property<JsonConverter>> action) {
        action.execute(this.getJsonConverter());
    }

    @Input
    @Optional
    public abstract Property<Boolean> getRecursive();

    @Input
    @Optional
    public abstract Property<String> getSheetName();

    @Input
    @Optional
    public abstract Property<String> getOutputFileType();

    @Input
    @Optional
    public abstract Property<Converters> getConverters();

    public void converters(Action<? super Property<Converters>> action) {
        action.execute(this.getConverters());
    }

    @Input
    @Optional
    public abstract Property<Boolean> getRemoveOriginalFile();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getOutputDirectory();

    @TaskAction
    public void exec() {
        ConvertDataFileCommand command = new ConvertDataFileCommand();
        this.initialize(command);
        this.run((AbstractCommand)command);
    }

    protected void initialize(ConvertDataFileCommand command) {
        command.setDirectory((File)this.getDirectory().getAsFile().get());
        if (this.getFileFilter().isPresent()) {
            command.setFileFilter((Predicate)this.getFileFilter().get());
        }
        if (this.getCsvEncoding().isPresent()) {
            command.setCsvEncoding((String)this.getCsvEncoding().get());
        }
        if (this.getJsonConverter().isPresent()) {
            command.setJsonConverter((JsonConverter)this.getJsonConverter().get());
        }
        if (this.getRecursive().isPresent()) {
            command.setRecursive(((Boolean)this.getRecursive().get()).booleanValue());
        }
        if (this.getSheetName().isPresent()) {
            command.setSheetName((String)this.getSheetName().get());
        }
        if (this.getOutputFileType().isPresent()) {
            command.setOutputFileType(WorkbookFileType.parse((String)((String)this.getOutputFileType().get())));
        }
        if (this.getConverters().isPresent()) {
            command.setConverters((Converters)this.getConverters().get());
        }
        if (this.getRemoveOriginalFile().isPresent()) {
            command.setRemoveOriginalFile(((Boolean)this.getRemoveOriginalFile().get()).booleanValue());
        }
        if (this.getOutputDirectory().isPresent()) {
            command.setOutputDirectory(((Directory)this.getOutputDirectory().get()).getAsFile());
        }
    }
}

