/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.extension;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.html.AbstractSchemaFileCommand;
import com.sqlapp.gradle.plugins.extension.AbstractDbExtension;
import com.sqlapp.util.JsonConverter;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public abstract class AbstractSchemaFileExtension
extends AbstractDbExtension {
    private final RegularFileProperty targetFile;

    @Inject
    protected AbstractSchemaFileExtension(Project project) {
        super(project);
        this.targetFile = project.getObjects().fileProperty();
    }

    @InputFile
    public RegularFileProperty getTargetFile() {
        return this.targetFile;
    }

    @Input
    @Optional
    public abstract DirectoryProperty getDictionaryFileDirectory();

    @Input
    @Optional
    public abstract Property<String> getDictionaryFileType();

    @Input
    @Optional
    public abstract Property<String> getCsvEncoding();

    @Input
    @Optional
    public abstract Property<JsonConverter> getJsonConverter();

    public void jsonConverter(Action<? super JsonConverter> action) {
        if (this.getJsonConverter().isPresent()) {
            action.execute(this.getJsonConverter().get());
        }
    }

    @Override
    @Internal
    public void setCommand(AbstractCommand command, boolean debug) {
        super.setCommand(command, debug);
        if (command instanceof AbstractSchemaFileCommand) {
            AbstractSchemaFileCommand com = (AbstractSchemaFileCommand)command;
            com.setTargetFile((File)this.getTargetFile().getAsFile().get());
            if (this.getDictionaryFileDirectory().isPresent()) {
                com.setDictionaryFileDirectory((File)this.getDictionaryFileDirectory().getAsFile().get());
            }
            if (this.getDictionaryFileType().isPresent()) {
                com.setDictionaryFileType((String)this.getDictionaryFileType().get());
            }
            if (this.getCsvEncoding().isPresent()) {
                com.setCsvEncoding((String)this.getCsvEncoding().get());
            }
            if (this.getJsonConverter().isPresent()) {
                com.setJsonConverter((JsonConverter)this.getJsonConverter().get());
            }
        }
    }
}

