/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.extension;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.ExportXmlCommand;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.gradle.plugins.extension.AbstractExportDataExtension;
import com.sqlapp.gradle.plugins.extension.OptionsExtension;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public abstract class ExportXmlExtension
extends AbstractExportDataExtension {
    @Inject
    public ExportXmlExtension(Project project) {
        super(project);
    }

    @Internal
    public void call(Action<ExportXmlExtension> cons) {
        cons.execute((Object)this);
    }

    @Input
    @Optional
    public abstract Property<String> getTarget();

    @InputDirectory
    public abstract DirectoryProperty getOutputPath();

    @Input
    @Optional
    public abstract Property<String> getOutputFileName();

    @Input
    @Optional
    public abstract ListProperty<String> getIncludeObjects();

    @Input
    @Optional
    public abstract ListProperty<String> getExcludeObjects();

    @Nested
    public abstract Property<OptionsExtension> getSchemaOptions();

    @Input
    @Optional
    public abstract Property<Boolean> getDumpRows();

    @Input
    @Optional
    public abstract ListProperty<String> getIncludeRowDumpTables();

    @Input
    @Optional
    public abstract ListProperty<String> getExcludeRowDumpTables();

    @Input
    @Optional
    public abstract Property<Consumer<DbObject<?>>> getConverter();

    @Override
    @Internal
    public void setCommand(AbstractCommand command, boolean debug) {
        super.setCommand(command, debug);
        if (command instanceof ExportXmlCommand) {
            ExportXmlCommand com = (ExportXmlCommand)command;
            if (this.getTarget().isPresent()) {
                com.setTarget((String)this.getTarget().get());
            }
            if (this.getOutputPath().isPresent()) {
                com.setOutputPath(((Directory)this.getOutputPath().get()).getAsFile());
            }
            if (this.getOutputFileName().isPresent()) {
                com.setOutputFileName((String)this.getOutputFileName().get());
            }
            if (this.getIncludeObjects().isPresent()) {
                com.setIncludeObjects(((List)this.getIncludeObjects().get()).toArray(new String[0]));
            }
            if (this.getExcludeObjects().isPresent()) {
                com.setExcludeObjects(((List)this.getExcludeObjects().get()).toArray(new String[0]));
            }
            if (this.getDumpRows().isPresent()) {
                com.setDumpRows(((Boolean)this.getDumpRows().get()).booleanValue());
            }
            if (this.getIncludeRowDumpTables().isPresent()) {
                com.setIncludeRowDumpTables(((List)this.getIncludeRowDumpTables().get()).toArray(new String[0]));
            }
            if (this.getExcludeRowDumpTables().isPresent()) {
                com.setExcludeRowDumpTables(((List)this.getExcludeRowDumpTables().get()).toArray(new String[0]));
            }
            if (this.getSchemaOptions().isPresent()) {
                com.setSchemaOptions((Options)this.getSchemaOptions().get());
            }
            if (this.getConverter().isPresent()) {
                com.setConverter((Consumer)this.getConverter().get());
            }
        }
    }
}

