/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.extension;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.html.GenerateHtmlCommand;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.gradle.plugins.extension.AbstractSchemaFileExtension;
import com.sqlapp.gradle.plugins.extension.RenderOptionExtension;
import java.io.File;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public abstract class GenerateHtmlExtension
extends AbstractSchemaFileExtension {
    @Inject
    public GenerateHtmlExtension(Project project) {
        super(project);
    }

    @Internal
    public void call(Action<GenerateHtmlExtension> cons) {
        cons.execute((Object)this);
    }

    @Input
    @Optional
    public abstract Property<RenderOptionExtension> getRenderOptions();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getOutputDirectory();

    @Input
    @Optional
    public abstract Property<String> getDiagramFont();

    @Input
    @Optional
    public abstract Property<String> getDiagramFormat();

    @Input
    @Optional
    public abstract Property<String> getDot();

    @Input
    @Optional
    public abstract Property<Boolean> getMultiThread();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getFileDirectory();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getDirectory();

    @Input
    @Optional
    public abstract Property<Boolean> getUseSchemaNameDirectory();

    @Input
    @Optional
    public abstract Property<Boolean> getUseTableNameDirectory();

    @Input
    @Optional
    public abstract Property<Predicate<File>> getFileFilter();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getForeignKeyDefinitionDirectory();

    @Input
    @Optional
    public abstract Property<Function<ForeignKeyConstraint, String>> getVirtualForeignKeyLabel();

    @Input
    @Optional
    public abstract Property<String> getPlaceholderPrefix();

    @Input
    @Optional
    public abstract Property<String> getPlaceholderSuffix();

    @Input
    @Optional
    public abstract Property<Boolean> getPlaceholders();

    @Override
    @Internal
    public void setCommand(AbstractCommand command, boolean debug) {
        super.setCommand(command, debug);
        if (command instanceof GenerateHtmlCommand) {
            GenerateHtmlCommand com = (GenerateHtmlCommand)command;
            if (this.getRenderOptions().isPresent()) {
                ((RenderOptionExtension)this.getRenderOptions().get()).setRenderOption(com.getRenderOptions());
            }
            if (this.getOutputDirectory().isPresent()) {
                com.setOutputDirectory(((Directory)this.getOutputDirectory().get()).getAsFile());
            }
            if (this.getDiagramFont().isPresent()) {
                com.setDiagramFont((String)this.getDiagramFont().get());
            }
            if (this.getDiagramFormat().isPresent()) {
                com.setDiagramFormat((String)this.getDiagramFormat().get());
            }
            if (this.getDot().isPresent()) {
                com.setDot((String)this.getDot().get());
            }
            if (this.getMultiThread().isPresent()) {
                com.setMultiThread(((Boolean)this.getMultiThread().get()).booleanValue());
            }
            if (this.getFileDirectory().isPresent()) {
                com.setFileDirectory(((Directory)this.getFileDirectory().get()).getAsFile());
            }
            if (this.getDirectory().isPresent()) {
                com.setDirectory(((Directory)this.getDirectory().get()).getAsFile());
            }
            if (this.getUseSchemaNameDirectory().isPresent()) {
                com.setUseSchemaNameDirectory(((Boolean)this.getUseSchemaNameDirectory().get()).booleanValue());
            }
            if (this.getUseTableNameDirectory().isPresent()) {
                com.setUseTableNameDirectory(((Boolean)this.getUseTableNameDirectory().get()).booleanValue());
            }
            if (this.getForeignKeyDefinitionDirectory().isPresent()) {
                com.setForeignKeyDefinitionDirectory(((Directory)this.getForeignKeyDefinitionDirectory().get()).getAsFile());
            }
            if (this.getVirtualForeignKeyLabel().isPresent()) {
                com.setVirtualForeignKeyLabel((Function)this.getVirtualForeignKeyLabel().get());
            }
            if (this.getPlaceholderPrefix().isPresent()) {
                com.setPlaceholderPrefix((String)this.getPlaceholderPrefix().get());
            }
            if (this.getPlaceholderSuffix().isPresent()) {
                com.setPlaceholderSuffix((String)this.getPlaceholderSuffix().get());
            }
            if (this.getPlaceholders().isPresent()) {
                com.setPlaceholders(((Boolean)this.getPlaceholders().get()).booleanValue());
            }
        }
    }
}

