/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.tasks;

import com.sqlapp.util.MapUtils;
import groovy.json.JsonSlurper;
import groovy.util.ConfigSlurper;
import groovy.yaml.YamlSlurper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class ConfigUtils {
    public static void readConfig(Map<?, ?> binding, Map map, Collection<File> files) {
        File[] fs = (File[])files.stream().toArray(File[]::new);
        ConfigUtils.readConfig(binding, map, fs);
    }

    public static void readConfig(Map<?, ?> binding, Map map, File ... files) {
        ConfigSlurper slurper = new ConfigSlurper();
        if (binding != null) {
            slurper.setBinding(binding);
        }
        for (File file : files) {
            FileInputStream is;
            Properties prop;
            if (!file.exists() || file.isDirectory()) continue;
            String lowerName = file.getAbsolutePath().toLowerCase();
            if (lowerName.endsWith(".properties")) {
                prop = new Properties();
                try {
                    is = new FileInputStream(file);
                    try {
                        prop.load(is);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                MapUtils.merge((Map)map, (Map)slurper.parse(prop));
                continue;
            }
            if (lowerName.endsWith(".xml")) {
                prop = new Properties();
                try {
                    is = new FileInputStream(file);
                    try {
                        prop.loadFromXML(is);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                MapUtils.merge((Map)map, (Map)slurper.parse(prop));
                continue;
            }
            if (lowerName.endsWith(".json")) {
                JsonSlurper jsonSlurper = new JsonSlurper();
                MapUtils.merge((Map)map, (Map)((Map)jsonSlurper.parse(file)));
                continue;
            }
            if (!lowerName.endsWith(".yaml") && !lowerName.endsWith(".yml")) continue;
            YamlSlurper yamlSlurper = new YamlSlurper();
            try {
                MapUtils.merge((Map)map, (Map)((Map)yamlSlurper.parse(file)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

