/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.tasks;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.generator.GenerateGeneratorSettingCommand;
import com.sqlapp.data.db.command.generator.GeneratorSettingFileType;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.gradle.plugins.extension.DataSourceExtension;
import com.sqlapp.gradle.plugins.extension.DataSourceInject;
import com.sqlapp.gradle.plugins.extension.TableOptionsExtension;
import com.sqlapp.gradle.plugins.tasks.AbstractDbTask;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateDataGeneratorSettingTask
extends AbstractDbTask
implements DataSourceInject {
    public GenerateDataGeneratorSettingTask() {
        this.setDataSource((DataSourceExtension)this.getProject().getObjects().newInstance(DataSourceExtension.class, new Object[0]));
        this.getTableOptions().convention((Object)((TableOptionsExtension)((Object)this.getProject().getObjects().newInstance(TableOptionsExtension.class, new Object[0]))));
    }

    @Internal
    public void call(Action<GenerateDataGeneratorSettingTask> cons) {
        cons.execute((Object)this);
    }

    @Input
    @Optional
    public abstract Property<String> getSchemaName();

    @Input
    @Optional
    public abstract Property<String> getTableName();

    @Input
    @Optional
    public abstract DirectoryProperty getDirectory();

    @Input
    @Optional
    public abstract Property<String> getSqlType();

    @Input
    @Optional
    public abstract Property<String> getFileType();

    @Nested
    public abstract Property<TableOptionsExtension> getTableOptions();

    public void tableOptions(Action<? super TableOptionsExtension> action) {
        action.execute(this.getTableOptions().get());
    }

    @TaskAction
    public void exec() {
        GenerateGeneratorSettingCommand command = new GenerateGeneratorSettingCommand();
        command.setDataSource(this.createDataSource(this.getDataSource()));
        if (this.getSchemaName().isPresent()) {
            command.setSchemaName((String)this.getSchemaName().get());
        }
        if (this.getTableName().isPresent()) {
            command.setTableName((String)this.getTableName().get());
        }
        if (this.getDirectory().isPresent()) {
            command.setDirectory(((Directory)this.getDirectory().get()).getAsFile());
        }
        if (this.getSqlType().isPresent()) {
            command.setSqlType(SqlType.parse((String)((String)this.getSqlType().get())));
        }
        if (this.getTableOptions().isPresent()) {
            command.setTableOptions((TableOptions)this.getTableOptions().get());
        }
        if (this.getFileType().isPresent()) {
            command.setFileType(GeneratorSettingFileType.parse((String)((String)this.getFileType().get())));
        }
        this.run((AbstractCommand)command);
    }
}

