/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.tasks;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.generator.GenerateDataInsertCommand;
import com.sqlapp.data.db.command.generator.factory.TableGeneratorSettingFactory;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.gradle.plugins.extension.CachedMvelEvaluatorExtension;
import com.sqlapp.gradle.plugins.extension.DataSourceExtension;
import com.sqlapp.gradle.plugins.extension.DataSourceInject;
import com.sqlapp.gradle.plugins.extension.TableOptionsExtension;
import com.sqlapp.gradle.plugins.tasks.AbstractDbTask;
import com.sqlapp.util.eval.CachedEvaluator;
import com.sqlapp.util.eval.mvel.CachedMvelEvaluator;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateDataTask
extends AbstractDbTask
implements DataSourceInject {
    public GenerateDataTask() {
        this.setDataSource((DataSourceExtension)this.getProject().getObjects().newInstance(DataSourceExtension.class, new Object[0]));
        this.getTableOptions().convention((Object)((TableOptionsExtension)((Object)this.getProject().getObjects().newInstance(TableOptionsExtension.class, new Object[0]))));
        this.getEvaluator().convention((Object)((CachedMvelEvaluatorExtension)((Object)this.getProject().getObjects().newInstance(CachedMvelEvaluatorExtension.class, new Object[0]))));
        this.getGeneratorSettingFactory().convention((Object)((TableGeneratorSettingFactory)this.getProject().getObjects().newInstance(TableGeneratorSettingFactory.class, new Object[0])));
    }

    @Internal
    public void call(Action<GenerateDataTask> cons) {
        cons.execute((Object)this);
    }

    @Input
    @Optional
    public abstract Property<String> getSchemaName();

    @Input
    @Optional
    public abstract Property<String> getTableName();

    @Input
    @Optional
    public abstract DirectoryProperty getFileDirectory();

    @Input
    @Optional
    public abstract Property<Long> getQueryCommitInterval();

    @Nested
    public abstract Property<CachedMvelEvaluatorExtension> getEvaluator();

    @Nested
    public abstract Property<TableOptionsExtension> getTableOptions();

    @Nested
    public abstract Property<TableGeneratorSettingFactory> getGeneratorSettingFactory();

    public void tableOptions(Action<? super TableOptionsExtension> action) {
        action.execute(this.getTableOptions().get());
    }

    public void evaluator(Action<? super CachedMvelEvaluator> action) {
        action.execute(this.getEvaluator().get());
    }

    public void generatorSettingFactory(Action<? super TableGeneratorSettingFactory> action) {
        action.execute(this.getGeneratorSettingFactory().get());
    }

    @TaskAction
    public void exec() {
        GenerateDataInsertCommand command = new GenerateDataInsertCommand();
        command.setDataSource(this.createDataSource(this.getDataSource()));
        if (this.getSchemaName().isPresent()) {
            command.setSchemaName((String)this.getSchemaName().get());
        }
        if (this.getTableName().isPresent()) {
            command.setTableName((String)this.getTableName().get());
        }
        if (this.getFileDirectory().isPresent()) {
            command.setFileDirectory(((Directory)this.getFileDirectory().get()).getAsFile());
        }
        if (this.getQueryCommitInterval().isPresent()) {
            command.setQueryCommitInterval(((Long)this.getQueryCommitInterval().get()).longValue());
        }
        if (this.getEvaluator().isPresent()) {
            command.setEvaluator((CachedEvaluator)this.getEvaluator().get());
        }
        if (this.getTableOptions().isPresent()) {
            command.setTableOptions((TableOptions)this.getTableOptions().get());
        }
        if (this.getGeneratorSettingFactory().isPresent()) {
            command.setGeneratorSettingFactory((TableGeneratorSettingFactory)this.getGeneratorSettingFactory().get());
        }
        this.run((AbstractCommand)command);
    }
}

