/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.tasks;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.SqlExecuteCommand;
import com.sqlapp.gradle.plugins.extension.DataSourceExtension;
import com.sqlapp.gradle.plugins.extension.DataSourceInject;
import com.sqlapp.gradle.plugins.tasks.AbstractDbTask;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class SqlExecuteTask
extends AbstractDbTask
implements DataSourceInject {
    public SqlExecuteTask() {
        this.setDataSource((DataSourceExtension)this.getProject().getObjects().newInstance(DataSourceExtension.class, new Object[0]));
    }

    @Internal
    public void call(Action<SqlExecuteTask> cons) {
        cons.execute((Object)this);
    }

    @Input
    @Optional
    public abstract Property<String> getSqlText();

    @InputFile
    @Optional
    public abstract ConfigurableFileCollection getSqlFiles();

    @Input
    @Optional
    public abstract Property<String> getEncoding();

    @Input
    @Optional
    public abstract Property<String> getPlaceholderPrefix();

    @Input
    @Optional
    public abstract Property<String> getPlaceholderSuffix();

    @Input
    @Optional
    public abstract Property<Boolean> getPlaceholders();

    @TaskAction
    public void exec() {
        SqlExecuteCommand command = new SqlExecuteCommand();
        command.setDataSource(this.createDataSource(this.getDataSource()));
        if (this.getSqlText().isPresent()) {
            command.setSqlText(new String[]{(String)this.getSqlText().get()});
        }
        if (!this.getSqlFiles().isEmpty()) {
            command.setSqlFiles((Collection)this.getSqlFiles().getFiles());
        }
        if (this.getEncoding().isPresent()) {
            command.setEncoding((String)this.getEncoding().get());
        }
        if (this.getPlaceholderPrefix().isPresent()) {
            command.setPlaceholderPrefix((String)this.getPlaceholderPrefix().get());
        }
        if (this.getPlaceholderSuffix().isPresent()) {
            command.setPlaceholderSuffix((String)this.getPlaceholderSuffix().get());
        }
        if (this.getPlaceholders().isPresent()) {
            command.setPlaceholders(((Boolean)this.getPlaceholders().get()).booleanValue());
        }
        this.run((AbstractCommand)command);
    }
}

