/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.tasks;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.OutputFormatType;
import com.sqlapp.data.db.command.SqlQueryCommand;
import com.sqlapp.gradle.plugins.extension.DataSourceExtension;
import com.sqlapp.gradle.plugins.extension.DataSourceInject;
import com.sqlapp.gradle.plugins.tasks.AbstractDbTask;
import com.sqlapp.util.FileUtils;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class SqlQueryTask
extends AbstractDbTask
implements DataSourceInject {
    @Input
    @Optional
    OutputFormatType outputFormatType = null;

    public SqlQueryTask() {
        this.setDataSource((DataSourceExtension)this.getProject().getObjects().newInstance(DataSourceExtension.class, new Object[0]));
    }

    @Internal
    public void call(Action<SqlQueryTask> cons) {
        cons.execute((Object)this);
    }

    @Input
    @Optional
    public abstract Property<String> getSql();

    @InputFile
    @Optional
    public abstract RegularFileProperty getSqlFile();

    @Input
    @Optional
    public abstract Property<String> getEncoding();

    @Input
    @Optional
    public abstract Property<String> getOutputFormatType();

    @TaskAction
    public void exec() {
        SqlQueryCommand command = new SqlQueryCommand();
        command.setDataSource(this.createDataSource(this.getDataSource()));
        if (this.getSql().isPresent()) {
            command.setSql((String)this.getSql().get());
        }
        if (this.getSqlFile().isPresent()) {
            command.setSql(FileUtils.readText((File)((RegularFile)this.getSqlFile().get()).getAsFile(), (String)(this.getEncoding().isPresent() ? (String)this.getEncoding().get() : "UTF-8")));
        }
        if (this.getOutputFormatType().isPresent()) {
            command.setOutputFormatType(OutputFormatType.parse((String)((String)this.getOutputFormatType().get())));
        }
        this.run((AbstractCommand)command);
    }
}

