/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.extension;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.export.AbstractExportCommand;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.gradle.plugins.extension.AbstractDbTableExtension;
import com.sqlapp.gradle.plugins.extension.TableOptionsExtension;
import com.sqlapp.util.JsonConverter;
import com.sqlapp.util.YamlConverter;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public abstract class AbstractExportDataExtension
extends AbstractDbTableExtension {
    @Inject
    protected AbstractExportDataExtension(Project project) {
        super(project);
        this.getTableOptions().convention((Object)((TableOptionsExtension)((Object)project.getObjects().newInstance(TableOptionsExtension.class, new Object[0]))));
    }

    @InputDirectory
    public abstract DirectoryProperty getDirectory();

    @Input
    @Optional
    public abstract Property<Boolean> getUseSchemaNameDirectory();

    @Input
    @Optional
    public abstract Property<String> getCsvEncoding();

    public abstract Property<JsonConverter> getJsonConverter();

    public abstract Property<YamlConverter> getYamlConverter();

    @Override
    @Nested
    public abstract Property<TableOptionsExtension> getTableOptions();

    @Override
    public void tableOptions(Action<? super TableOptionsExtension> action) {
        action.execute(this.getTableOptions().get());
    }

    @Override
    @Internal
    public void setCommand(AbstractCommand command, boolean debug) {
        super.setCommand(command, debug);
        if (command instanceof AbstractExportCommand) {
            AbstractExportCommand com = (AbstractExportCommand)command;
            if (this.getUseSchemaNameDirectory().isPresent()) {
                com.setUseSchemaNameDirectory(((Boolean)this.getUseSchemaNameDirectory().get()).booleanValue());
            }
            if (this.getCsvEncoding().isPresent()) {
                com.setCsvEncoding((String)this.getCsvEncoding().get());
            }
            if (this.getJsonConverter().isPresent()) {
                com.setJsonConverter((JsonConverter)this.getJsonConverter().get());
            }
            if (this.getYamlConverter().isPresent()) {
                com.setYamlConverter((YamlConverter)this.getYamlConverter().get());
            }
            if (this.getDirectory().isPresent()) {
                com.setDirectory((File)this.getDirectory().getAsFile().get());
            }
            if (this.getTableOptions().isPresent()) {
                com.setTableOptions((TableOptions)this.getTableOptions().get());
            }
        }
    }
}

