/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.extension;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.html.AbstractSchemaFileCommand;
import com.sqlapp.gradle.plugins.extension.AbstractDbExtension;
import com.sqlapp.gradle.plugins.extension.OptionsExtension;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public abstract class AbstractGenerateSqlExtension
extends AbstractDbExtension {
    @Inject
    protected AbstractGenerateSqlExtension(Project project) {
        super(project);
    }

    @InputFile
    @Optional
    public abstract RegularFileProperty getTargetFile();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getOutputPath();

    @Input
    @Optional
    public abstract Property<String> getEncoding();

    @Input
    @Optional
    public abstract Property<Boolean> getOutputAsMultiFiles();

    @Input
    @Optional
    public abstract Property<String> getOutputFileExtension();

    @Input
    @Optional
    public abstract Property<Long> getLastChangeNumber();

    @Input
    @Optional
    public abstract Property<Long> getChangeNumberStep();

    @Input
    @Optional
    public abstract Property<Integer> getNumberOfDigits();

    @Internal
    public int getOrElseNumberOfDigits() {
        return (Integer)this.getNumberOfDigits().getOrElse((Object)19);
    }

    @Input
    @Optional
    public abstract Property<OptionsExtension> getSchemaOptions();

    public void schemaOptions(Action<? super OptionsExtension> action) {
        action.execute(this.getSchemaOptions().get());
    }

    @Override
    @Internal
    public void setCommand(AbstractCommand command, boolean debug) {
        super.setCommand(command, debug);
        if (command instanceof AbstractSchemaFileCommand) {
            AbstractSchemaFileCommand com = (AbstractSchemaFileCommand)command;
            if (this.getTargetFile().isPresent()) {
                com.setTargetFile((File)this.getTargetFile().getAsFile().get());
            }
        }
    }
}

